#include "jabber.h"


// Application Code

void jabber::ReadyToRun(void)
{
   // Figure out the rectangle that will center window on the screen.
   int xdim = 500;
   int ydim = 400+20;

   BRect screen_frame = BScreen(B_MAIN_SCREEN_ID).Frame();

   int left = (screen_frame.right - xdim) / 2;
   int top = (screen_frame.bottom - ydim) / 2;
	
   BRect window_frame(left, top, left+xdim, top+ydim);

	// Create the window.
   window = new jabber_window(window_frame);
   view = new jabber_view(BRect(0,0,xdim,ydim));

   window->Lock();
   window->AddChild(view);
   window->Unlock();
   window->Show();
}


void jabber::AboutRequested(void)
{
   OpenAlertWindow("Written by Wesley Dungan (wesley@idsi.net) 1998.");
}


bool jabber::QuitRequested(void)
{
   if (talkio_thread > 0) {
      if (talkio->announce_thread > 0)
	 kill_thread(talkio->announce_thread);
		
      if (talkio->accept_thread > 0)
	 kill_thread(talkio->accept_thread);
		
      if (talkio->read_thread > 0)
	 kill_thread(talkio->read_thread);

      kill_thread(talkio_thread);
   }
		
   BApplication::QuitRequested();
	
   return true;
}


void jabber::MessageReceived(BMessage *message)
{
   BAlert *alert;
   char buffer[512];
   const char *text;
	
   switch (message->what) {
   case TALK_REQUESTED :
      sprintf(buffer, "'%s' is requesting a talk session.", 
	      message->FindString("ruser"));

      alert = new BAlert("", buffer,
			 "Refuse", "Accept", NULL, B_WIDTH_AS_USUAL, B_INFO_ALERT);

      alert->SetShortcut(0, B_ESCAPE);

      if (alert->Go() == 0) {
	 Quit();
      } else {
	 PostMessage(new BMessage(OPEN_CONNECTION));
	 BMessage *new_message = new BMessage(message);
	 new_message->what = INIT_TALK_PARAMS;
	 PostMessage(new_message);
      }
      break;

   case OPEN_CONNECTION :
      window->Lock();
      view->EnableOpen(false);
      local_view->SetText(NULL);
      remote_view->SetText(NULL);
      window->Unlock();
      break;
	
   case CLOSE_CONNECTION :
      talkio->PostMessage(ABORT);
      window->Lock();
      local_view->MakeEditable(false);
      window->Unlock();
      // Give the TalkIO thread time to abort.
      sleep(3);
      if (talkio_thread > 0) {
	 if (talkio->announce_thread > 0)
	    kill_thread(talkio->announce_thread);
		
	 if (talkio->accept_thread > 0)
	    kill_thread(talkio->accept_thread);
		
	 if (talkio->read_thread > 0)
	    kill_thread(talkio->read_thread);

	 kill_thread(talkio_thread);
			
	 talkio_thread = -1;
      }
      window->Lock();
      view->EnableOpen(true);
      window->Unlock();
      break;
	
   case INIT_TALK_PARAMS :
      OpenWaitWindow();
      talkio = new TalkIO();
      talkio_thread = talkio->Run();
      talkio->Lock();
      sprintf(buffer, "%s", message->FindString("ruser"));
      if (talkio->InitParameters(buffer, "")) {
	 if (!talkio->OpenSockets()) {
	    PostMessage(new BMessage(CLOSE_CONNECTION));
	    CloseWaitWindow();
	    OpenAlertWindow("A socket initialization error occured.");
	 } else {
	    talkio->PostMessage(new BMessage(START_TALKING));
	 }
      } else {
	 PostMessage(new BMessage(CLOSE_CONNECTION));
	 CloseWaitWindow();
	 OpenAlertWindow("The remote host is unreachable.");
      }
      talkio->Unlock();
      break;
		
   case LOCAL_INPUT :
      talkio->PostMessage(message);
      break;

   case REMOTE_INPUT :
      text = message->FindString("text");
      window->Lock();
      remote_view->MakeEditable(true);
      remote_view->Select(INT_MAX, INT_MAX);
		
      for (int i=0; i<strlen(text); i++) {
	 // This is like the remote user was actually typing
	 // at the local keyboard.
	 if (isprint(text[i]) || (text[i] == B_RETURN) || 
	     (text[i] == B_BACKSPACE) || (text[i] == B_TAB)) {
	    int32 start, finish;
	    remote_view->GetSelection(&start, &finish);
	    if (!((start > 0) && (remote_view->ByteAt(start-1) == B_RETURN) && 
		  (text[i] == B_BACKSPACE))) {
	       remote_view->KeyDown(&text[i], 1);
	       remote_view->KeyUp(&text[i], 1);
	    }
	 }
      }
		
      remote_view->MakeEditable(false);
      window->Unlock();
      break;
   }
}

void jabber::OpenWaitWindow(void)
{
   int xdim = 400;
   int ydim = 80;
	
   window->Lock();
   BPoint upper_left = window->ConvertToScreen(BPoint(0,0));
   window->Unlock();
	
   int left = upper_left.x + 50;
   int top = upper_left.y + 90;

   // Make sure the wait window will be on the screen.
   BRect screen_frame = BScreen(B_MAIN_SCREEN_ID).Frame();
   if (!(screen_frame.Contains(BRect(left, top, left+xdim, top+ydim)))) {
      left = (screen_frame.right - xdim) / 2;
      top = (screen_frame.bottom - ydim) / 2;
   }
		
   wait_win = new wait_window(BRect(left, top, left+xdim, top+ydim));

   wait_win->Show();
}


void jabber::CloseWaitWindow(void) {
   wait_win->PostMessage(B_QUIT_REQUESTED);
}


void jabber::OpenAlertWindow(char *text)
{
   int xdim = 400;
   int ydim = 80;
	
   window->Lock();
   BPoint upper_left = window->ConvertToScreen(BPoint(0,0));
   window->Unlock();
	
   int left = upper_left.x + 50;
   int top = upper_left.y + 90;

   // Make sure the wait window will be on the screen.
   BRect screen_frame = BScreen(B_MAIN_SCREEN_ID).Frame();
   if (!(screen_frame.Contains(BRect(left, top, left+xdim, top+ydim)))) {
      left = (screen_frame.right - xdim) / 2;
      top = (screen_frame.bottom - ydim) / 2;
   }
	
   alert_window *alert_win = new alert_window(BRect(left, top, left+xdim, top+ydim),
					      text);

   alert_win->Show();
}
