/*
 * ArpTelnet Copyright (c)1997-98 by Dianne Hackborn.
 * All rights reserved.
 *
 * Based (increasingly loosly) on WebTerm, a Web-based terminal
 * applet written in Java, which is
 * Copyright (C)1996 by the National Alliance for Computational
 * Science and Engineering (NACSE).
 * See <URL:http://www.nacse.org/> for more information.
 *
 * This code is not public domain, nor freely distributable.
 * Please direct any questions or requests to Dianne Hackborn,
 * at <hackbod@lucent.com> or <hackbod@angryredplanet.com>.
 *
 */

#ifndef _APPLICATION_H
#include <app/Application.h>
#endif

#ifndef _SCREEN_H
#include <interface/Screen.h>
#endif

#ifndef _RECT_H
#include <interface/Rect.h>
#endif

#ifndef _ALERT_H
#include <interface/Alert.h>
#endif

#ifndef ARPCOMMON_ARPDEBUG_H
#include <ArpCommon/ArpDebug.h>
#endif

#ifndef ARPCOMMON_ARPMULTIDIR_H
#include <ArpCommon/ArpMultiDir.h>
#endif

#ifndef MAIN_H
#include "Main.h"
#endif

#ifndef TERMINALWIN_H
#include "TerminalWin.h"
#endif

#include <stdlib.h>

main()
{	
	MainApp *myApplication;

	myApplication = new MainApp();

#if 0
	// Here is an example using ArpMultiDir...  originally written
	// just for my own testing, but I thought I'd leave it in since
	// the class is otherwise rather undocumented. ;)
	BPath path;
	if( find_directory(B_BEOS_ADDONS_DIRECTORY,&path) == B_OK ) {
		printf("BEOS ADDONS: %s\n",path.Path());
	}
	if( find_directory(B_COMMON_ADDONS_DIRECTORY,&path) == B_OK ) {
		printf("COMMON ADDONS: %s\n",path.Path());
	}
	if( find_directory(B_USER_ADDONS_DIRECTORY,&path) == B_OK ) {
		printf("USER ADDONS: %s\n",path.Path());
	}
	
	ArpMultiDir mdir;
	mdir.AddDirectory(B_BEOS_ADDONS_DIRECTORY,"emulator");
	mdir.AddDirectory(B_COMMON_ADDONS_DIRECTORY,"emulator");
	mdir.AddDirectory(B_USER_ADDONS_DIRECTORY,"emulator");
	mdir.AddEnvVar("ADDON_PATH","emulator");
	BEntry entry;
	mdir.Rewind();
	while( mdir.GetNextEntry(&entry,true) == B_NO_ERROR ) {
		BPath path;
		entry.GetPath(&path);
		printf("In dir %s found %s\n","<unknown>",path.Path());
	}
#endif
	
	myApplication->Run();
	
	delete(myApplication);
	return(0);
}

MainApp::MainApp()
	: BApplication("application/x-vnd.ARP-ArpTelnet"),
	  termwin(NULL), cmdline(false)
{
	termwin = new TerminalWin(BPoint(20,20),
								"ArpTelnet v" PROGRAM_VERSION,
								"About ArpTelnet" B_UTF8_ELLIPSIS);
	
	// make window visible
	if(termwin) {
		BScreen screen(termwin);
		if( screen.IsValid() ) {
			BRect wfrm = termwin->Frame();
			BRect sfrm = screen.Frame();
			float height = wfrm.Height();
			float width = wfrm.Width();
			if( height > sfrm.Height() ) height = sfrm.Height();
			if( width > sfrm.Width() ) width = sfrm.Width();
			termwin->MoveTo( sfrm.left + (sfrm.Width()-width)/2,
								sfrm.top + (sfrm.Height()-height)/2 );
			termwin->ResizeTo(width,height);
		}
		termwin->Show();
	}
}

void MainApp::AboutRequested(void)
{
	BAlert* alert =
		new BAlert("About ArpTelnet",
					"ArpTelnet version " PROGRAM_VERSION
					" / " __DATE__ "\n"
					B_UTF8_COPYRIGHT "1997-98 Dianne Hackborn.\n\n"
					"A terminal class featuring add-on emulators and "
					"a TELNET client.  More "
					"information is available from Dianne Hackborn "
					"<hackbod@angryredplanet.com>.\n\n"
					"This program and associated code is NOT public domain.  "
					"You may freely use the application however you would "
					"like, and freely use the associated program classes in "
					"your own free programs.  However, if you would like to "
					"use pieces of the terminal or other components in a "
					"shareware or commercial application, please talk with "
					"me.  "
					"(Basically, "
					"I haven't yet decided what I'm going to do with the "
					"thing" B_UTF8_ELLIPSIS " ;)",
					"Fantastic");
	if( alert ) {
		alert->Go(NULL);
	}
}

void MainApp::DispatchMessage(BMessage *message,
								  BHandler *handler)
{
	DB(DBALL, cerr << "MainApp::DispatchMessage: " <<
				*message << endl);
	inherited::DispatchMessage(message,handler);
}

void MainApp::ArgvReceived(int32 argc, char** argv)
{
	// Process command line arguments:  Connect to given host
	// and optional port.
	const char* host = NULL;
	int32 port = 23;
	if( argc >= 2 ) host = argv[1];
	if( argc >= 3 ) port = atoi(argv[2]);
	if( host != NULL ) {
		cmdline = true;
		termwin->Connect(host,port);
	}
}

