/*
 * ArpTelnet Copyright (c)1997 by Dianne Hackborn.
 * All rights reserved.
 *
 * Based (increasingly loosly) on WebTerm, a Web-based terminal
 * applet written in Java, which is
 * Copyright (C)1996 by the National Alliance for Computational
 * Science and Engineering (NACSE).
 * See <URL:http://www.nacse.org/> for more information.
 *
 * This code is not public domain, nor freely distributable.
 * Please direct any questions or requests to Dianne Hackborn,
 * at <hackbod@lucent.com> or <hackbod@enteract.com>.
 *
 * ----------------------------------------------------------------------
 *
 * Loopback.h
 *
 * This class is a (very) simple example of a remote device.
 * All it does is echo all text it receives from the terminal
 * back to it, allowing the user to see what is typed.
 *
 * ----------------------------------------------------------------------
 *
 * Known Bugs
 * ~~~~~~~~~~
 *
 * ----------------------------------------------------------------------
 *
 * History
 * ~~~~~~~
 *
 * 0.1: Created this file.
 *
 */

#ifndef LOOPBACK_H
#define LOOPBACK_H

#ifndef _LOCKER_H
#include <Locker.h>
#endif

#ifndef _LOOPER_H
#include <Looper.h>
#endif

#ifndef _MESSENGER_H
#include <Messenger.h>
#endif

#ifndef ARPCOMMON_ARPSTRING_H
#include <ArpCommon/ArpString.h>
#endif

class Loopback : public BLooper {
private:
	typedef BLooper inherited;
	
public:

	Loopback(void);
	virtual ~Loopback();
	
	// Directly setting terminal: this normally isn't needed,
	// since the terminal sends a message with its BMessenger
	// when it is attached to the Loopback.
	Loopback(const BMessenger& term);
	void SetTerminal(const BMessenger& term) { terminal = term; }
	const BMessenger& GetTerminal(void) { return terminal; }
		
protected:

	virtual void MessageReceived(BMessage* message);

	/* ------------------------------------------------------------
	   INSTANCE DATA SECTION
	   ------------------------------------------------------------ */

	BMessenger terminal;
	int curWidth, curHeight; // Current window dimensions.
};

#endif
