/*
 * ArpTelnet Copyright (c)1997-98 by Dianne Hackborn.
 * All rights reserved.
 *
 * Based (increasingly loosly) on WebTerm, a Web-based terminal
 * applet written in Java, which is
 * Copyright (C)1996 by the National Alliance for Computational
 * Science and Engineering (NACSE).
 * See <URL:http://www.nacse.org/> for more information.
 *
 * This code is not public domain, nor freely distributable.
 * Please direct any questions or requests to Dianne Hackborn,
 * at <hackbod@lucent.com> or <hackbod@angryredplanet.com>.
 *
 * ----------------------------------------------------------------------
 *
 * ConnectWin.h
 *
 * Window to prompt for connection host and port.  If a
 * connection is selected, sends a message back to the handler
 * given at construction.
 *
 * ----------------------------------------------------------------------
 *
 * Known Bugs
 * ~~~~~~~~~~
 *
 * ----------------------------------------------------------------------
 *
 * History
 * ~~~~~~~
 *
 * 7/26/1997:
 *	• Created this file.
 *
 */

#ifndef CONNECTWIN_H
#define CONNECTWIN_H

#ifndef _WINDOW_H
#include <Window.h>
#endif

// forward refs
class BTextControl;

enum {
	CONNECT_SELECTED_MSG = 'csel'
	/* "host" (STRING) is the host name,
	 * "port" (INT32) is the port number */
};

class ConnectWin : public BWindow {
private:
	typedef BWindow inherited;
	
public:
	ConnectWin(BRect frame, BHandler* inreply,
				const char* defhost = "", int32 defport=23);
	~ConnectWin();
	
	virtual void MessageReceived(BMessage *message);
	virtual	bool QuitRequested();
	
	BHandler* reply;
	
	BTextControl* hosttext;
	BTextControl* porttext;
};

#endif
