/*
 * ArpTelnet Copyright (c)1997-98 by Dianne Hackborn.
 * All rights reserved.
 *
 * Based (increasingly loosly) on WebTerm, a Web-based terminal
 * applet written in Java, which is
 * Copyright (C)1996 by the National Alliance for Computational
 * Science and Engineering (NACSE).
 * See <URL:http://www.nacse.org/> for more information.
 *
 * This code is not public domain, nor freely distributable.
 * Please direct any questions or requests to Dianne Hackborn,
 * at <hackbod@lucent.com> or <hackbod@angryredplanet.com>.
 *
 */

//#define DEBUG 1
//#define USE_STREAMS 1

#ifndef _SCROLL_VIEW_H
#include <interface/ScrollView.h>
#endif

#ifndef _TEXT_CONTROL_H
#include <interface/TextControl.h>
#endif

#ifndef _BUTTON_H
#include <interface/Button.h>
#endif

#ifndef CONNECTWIN_H
#include "ConnectWin.h"
#endif

#ifndef _AUTOLOCK_H
#include <support/Autolock.h>
#endif

#ifndef ARPCOMMON_ARPDEBUG_H
#include <ArpCommon/ArpDebug.h>
#endif

#include <stdlib.h>

enum {
	SEND_CONNECT_MSG = '.scn',
};

ConnectWin::ConnectWin(BRect frame, BHandler* inreply,
						const char* defhost, int32 defport)
	: BWindow(frame, "Telnet Connect",
				B_TITLED_WINDOW, B_NOT_RESIZABLE),
	  reply(inreply), hosttext(NULL), porttext(NULL)
{
	// set up a rectangle and instantiate a new view
	// view rect should be same size as window rect but with
	// left top at (0, 0)
	BRect aRect(Bounds());
	
	const BFont* font = be_plain_font;
	
	font_height fh;
	font->GetHeight(&fh);
	float spaceh = (fh.ascent+fh.descent+fh.leading)/2;
	float spacew = font->StringWidth("W");
	
	BView* top = new BView(Bounds(),"top",B_FOLLOW_ALL,B_WILL_DRAW);
	if( !top ) return;
	top->SetViewColor(0xe0,0xe0,0xe0);
	AddChild(top);
	
	aRect.top += spaceh;
	aRect.bottom += spaceh;
	aRect.left += spacew;
	aRect.right += spacew;
	
	hosttext = new BTextControl(aRect, "host", "Host: ", defhost,
								NULL, B_FOLLOW_NONE);
	float hw=0, hh=0;
	if( hosttext ) {
		top->AddChild(hosttext);
		hosttext->GetPreferredSize(&hw,&hh);
		hw += font->StringWidth("telnet.enteract.com");
		hosttext->ResizeTo(hw,hh);
		hosttext->SetDivider(font->StringWidth("Host: "));
		hosttext->MakeFocus(true);
	}
	hw += spacew;
	
	char buffer[16];
	sprintf(&buffer[0],"%d",defport);
	porttext = new BTextControl(BRect(aRect.left+hw,aRect.top,
										aRect.right,aRect.bottom),
								"port", "Port: ", &buffer[0],
								NULL, B_FOLLOW_NONE);
	float pw=0, ph=0;
	if( porttext ) {
		top->AddChild(porttext);
		porttext->GetPreferredSize(&pw,&ph);
		pw += font->StringWidth("00");
		porttext->ResizeTo(pw,ph);
		porttext->SetDivider(font->StringWidth("Port: "));
	}
	
	hh += spaceh;
	
	BButton* connectbut =
		new BButton(aRect, "connect", "Connect",
					new BMessage(SEND_CONNECT_MSG), B_FOLLOW_NONE);
	float cw=0, ch=0;
	if( connectbut ) {
		top->AddChild(connectbut);
		SetDefaultButton(connectbut);
		connectbut->GetPreferredSize(&cw,&ch);
		connectbut->ResizeToPreferred();
		connectbut->MoveTo(aRect.left+hw+pw-cw, aRect.top+hh);
		connectbut->SetTarget(this);
	}
	
	BButton* cancelbut =
		new BButton(BRect(aRect.left,aRect.top+hh,
							0,1), "cancel", "Cancel",
					new BMessage(B_QUIT_REQUESTED), B_FOLLOW_NONE);
	if( cancelbut ) {
		float canw=0, canh=0;
		top->AddChild(cancelbut);
		cancelbut->GetPreferredSize(&canw,&canh);
		cancelbut->ResizeToPreferred();
		cancelbut->MoveTo(aRect.left,aRect.top+hh+(ch-canh)/2);
		cancelbut->SetTarget(this);
	}

	ResizeTo(aRect.left+hw+pw+spacew,aRect.top+hh+ch+spaceh);
}

ConnectWin::~ConnectWin()
{
}

void ConnectWin::MessageReceived(BMessage *message)
{
	switch( message->what ) {
		case SEND_CONNECT_MSG: {
			if( reply && reply->Looper() && hosttext && porttext ) {
				BMessage cmsg(CONNECT_SELECTED_MSG);
				cmsg.AddString("host",hosttext->Text());
				cmsg.AddInt32("port",atoi(porttext->Text()));
				reply->Looper()->PostMessage(&cmsg,reply);
			}
			PostMessage(B_QUIT_REQUESTED);
		} break;
		default:
			inherited::MessageReceived(message);
	}
}

bool ConnectWin::QuitRequested()
{
	return(true);
}
