/*****************************************************************************

	Projet	: Droids

	Fichier	:	bCWinEcran.cpp
	Partie	: Video

	Auteur	: RM
	Date		: 110297
	Format	: tabs==2

*****************************************************************************/

#include "bCWinEcran.h"
#include "gCMoteur.h"
#include "gCApplication.h"
#include "externs.h"

//---------------------------------------------------------------------------

// fast hack... where should I get the height ?
#define K_MENU_HEIGHT		19

//---------------------------------------------------------------------------


//***************************************************************************
CWinEcran::CWinEcran(BRect frame, char *titre)
					:BWindow(BRect(frame.left, frame.top, frame.right, frame.bottom+K_MENU_HEIGHT),
										titre, B_TITLED_WINDOW,	B_NOT_RESIZABLE | B_NOT_ZOOMABLE)
//***************************************************************************
{
	mAskToQuit = true;
	mEcran1 = NULL;
	mEcran2 = NULL;
} // end of constructor for CWinEcran


//***************************************************************************
CWinEcran::~CWinEcran(void)
//***************************************************************************
{
	printf("CWinEcran::~CWinEcran -- destructor\n");
} // end of destructor for CWinEcran


//---------------------------------------------------------------------------


//***************************************************************************
BOOL CWinEcran::init(void)
//***************************************************************************
{
BRect rect1;

	printf("CWinEcran::init\n");

	Lock();

	BMenuBar *menubar = new BMenuBar(BRect(0,0,640,K_MENU_HEIGHT-1), "MainMenuBar");
	if (menubar && gApplication && gApplication->mMainMenu)
		menubar->AddItem(gApplication->mMainMenu);
	AddChild(menubar);

	//rect1 = Bounds();
	rect1 = BRect(0,K_MENU_HEIGHT,640*2, K_MENU_HEIGHT+480*1.5);
	mEcran1 = new CViewEcran(true, rect1, rect1, "ecran1");
	if (!mEcran1 || !mEcran1->init()) return FALSE;
	AddChild(mEcran1);
	mEcran1->ResizeTo(640, 480-128);
	mEcran1->setScroll(0,0);

	rect1 = BRect(0,K_MENU_HEIGHT+480-128+1,640,K_MENU_HEIGHT+480);
	mEcran2 = new CViewEcran(false, rect1, rect1, "ecran2");
	if (!mEcran2 || !mEcran2->init()) return FALSE;
	AddChild(mEcran2);

	Unlock();
	Show();
	return TRUE;
} // end of init for CWinEcran


//***************************************************************************
bool CWinEcran::QuitRequested(void)
//***************************************************************************
{
	printf("CWinEcran::QuitRequested -- %d\n", mAskToQuit);
	if (mAskToQuit)
	{
		be_app->PostMessage(B_QUIT_REQUESTED);
		mAskToQuit = false;
		return FALSE;
	}
	else
		return TRUE;
} // end of QuitRequested for CClasse


//***************************************************************************
void CWinEcran::DispatchMessage(BMessage *message, BHandler *handler)
//***************************************************************************
{
	if (message->what == B_MOUSE_UP)
		gMoteur->mouseUp();
	BWindow::DispatchMessage(message, handler);
} // end of DispatchMessage for CWinEcran


//---------------------------------------------------------------------------


//***************************************************************************
void CWinEcran::setScroll(ULONG x, ULONG y)
//***************************************************************************
{
	if (Lock())
	{
		mEcran1->setScroll(x, y);
		mEcran1->ScrollTo(x,y);
		Unlock();
	}
} // end of setHeight for CWinEcran


//---------------------------------------------------------------------------

// eoc
