/*****************************************************************************

	Projet	: Droids

	Fichier	:	bCVideo.h
	Partie	: Video

	Auteur	: RM
	Date		: 110297
	Format	: tabs==2

*****************************************************************************/

#ifndef _H_BCVIDEO_
#define _H_BCVIDEO_

#include "machine.h"

//---------------------------------------------------------------------------
// forward definition
class CWinEcran;

//---------------------------------------------------------------------------


//*************
struct SbSprite
//*************
// structure d'un sprite transforme depuis STable pour la Be.
{
	SbSprite(void) {data[0] = NULL; data[1]=NULL;}
	~SbSprite(void) {if (data[0]) delete data[0]; if (data[0]) delete data[1];}

	ULONG sx, sy;
	// data et mask sont des mallocs de sx*sy octets. Bytes per row = sx.
	UBYTE *data[2];
	// donne remappees en 256 couleurs palette Be, 1 octet par pixel
	// le masque est donne directement par les pixels : 0==transparent, >0=data
};



//**********
class CVideo
//**********
{
public:
	CVideo(void);
	virtual ~CVideo(void);

	BOOL init(void);

	// fonction de draw sur la partie camera
	void blitSpriteNoMask(long x, long y, ULONG sprite, ULONG ecran=0);
	void blitSpriteMask(long x, long y, ULONG sprite, ULONG ecran=0);
	void blitSpriteFond(long x, long y, ULONG sprite);

	CWinEcran * ecran(void) {return mWinEcran;}
	void clearScreen(ULONG mask);
	void redraw(ULONG mask);
	void setScroll(ULONG x, ULONG y);
	void setSpriteMode(BOOL pulco) {mSpriteMode = (pulco & 0x1);}

	void setScore(UWORD scoreNerd, UWORD scoreAction)	;
	void drawScore(void);

//----
protected:

	BOOL loadSprite(CHAR *sprite1, CHAR *sprite2, CHAR *fondname);
	void extractSprite(UBYTE *image[2], long len[2], long x, long y, long sx, long sy);
	void createFullFond(long idfond, long idfull);

//----
	SbSprite	*mSprite;
	ULONG			mNbSprite;
	ULONG			mNbAllocSprite;

	CWinEcran	*mWinEcran;

	UBYTE			*mEcran[2];
	ULONG			mLenEcran[2];
	ULONG			mBprEcran[2];

	ULONG			mScrollX, mScrollY;
	LONG			mSpriteFond;
	LONG			mSpriteFullFond;

	BDirectory mDirImg;

	UBYTE			sph_palette[256*3];
	UBYTE			sph_index_noir;

	UBYTE			mSpriteMode;

	UWORD			mScoreNerd;
	UWORD			mScoreAction;
	BBitmap		*mScoreBitmap;
	BView			*mScoreView;

}; // end of class defs for CVideo




//---------------------------------------------------------------------------

#endif // of _H_BCVIDEO_

// eoh
