//Hammurabi
//Matt Wronkiewicz, 1997 10 12


#include "Player.h"
#include "HamConsole.h"
#include "HamAlert.h"
#include "Hammurabi.h"


Player::Player (HamConsole* new_console)
	{
	console = new_console;
	land = 1000;
	population = 100;
	storage = 3000;
	last_food = 0;
	last_yield = 0;
	harvest = 3;
	land_price = 20;
	rats = 1;
	rat_grain = 0;
	flooded = 0;
	plague = false;
	}


void Player::doStats ()
	{
	land_price += rand() % 8 - 3;
	if (land_price < 10)
		land_price = 10;
	
	if (plague)
		{
		int killed = 1 + rand() % (population / 2);
		char message[256];
		if (killed == 1)
			sprintf(message, "A horrible plague has killed 1 person.\n");
		else
			sprintf(message, "A horrible plague has killed %d people.\n", killed);
		(new HamAlert(message, "Death Bitmap", false))->Show();
		population -= killed;
		}
	if (!(rand() % 5))
		{
		flooded = rand() % 100 + 1;
		if (flooded > land)
			flooded = land;
		if (flooded > 0)
			{
			char message[256];
			if (flooded == 1)
				sprintf(message, "Flooding has rendered 1 acre unusable this year.\n");
			else
				sprintf(message, "Flooding has rendered %d acres unusable this year.\n", flooded);
			(new HamAlert(message, "Proverbs Bitmap", false))->Show();
			}
		}
	else
		flooded = 0;
	updateControls();
	}


void Player::doBuy ()
	{
	int purchase = console->getTrade();
	if (purchase > storage / land_price)
		purchase = storage / land_price;
	if (purchase < 0)
		purchase = 0;
	land += purchase;
	storage -= land_price * purchase;
	updateControls();
	}


void Player::doSell ()
	{
	int sale = console->getTrade();
	if (sale > land)
		sale = land;
	if (sale < 0)
		sale = 0;
	land -= sale;
	storage += land_price * sale;
	updateControls();
	}


void Player::doGrow ()
	{
	storage += last_yield;
	last_yield = 0;
	harvest = 1 + rand() % 5;
	
	if (last_food < population * 20)
		{
		population = last_food / 20;
		}
	last_food = 0;
	if (population < 0)
		population = 0;
	population += population * 0.05;
	population += rand() % 2;
	updateControls();
	}


void Player::doFeed ()
	{
	console->feed_status->SetMaxValue(population * 20);
	int feedable = console->getFeed();
	if (feedable > storage)
		feedable = storage;
	if (feedable > console->feed_status->MaxValue() - console->feed_status->CurrentValue())
		feedable = console->feed_status->MaxValue() - console->feed_status->CurrentValue();
	if (feedable < 0)
		feedable = 0;
	last_food += feedable;
	storage -= feedable;
	updateControls();
	}


void Player::doPlant ()
	{
	console->plant_status->SetMaxValue(land - flooded);
	int plantable = console->getPlant();
	if (plantable > storage * 2)
		plantable = storage * 2;
	if (plantable > console->plant_status->MaxValue() - console->plant_status->CurrentValue())
		plantable = console->plant_status->MaxValue() - console->plant_status->CurrentValue();
	if (plantable > population * 10 - console->plant_status->CurrentValue())
		plantable = population * 10 - console->plant_status->CurrentValue();
	if (plantable < 0)
		plantable = 0;
	storage -= plantable * 0.5;
	last_yield += plantable * harvest;
	updateControls();
	}


void Player::doRats ()
	{
	rats += rats + rand() % 5;
	rat_grain = rats * 2;
	if (rat_grain < storage)
		storage -= rat_grain;
	else
		{
		rats = storage / 2;
		storage = 0;
		}
	updateControls();
	plague = (rats > population) && !(rand() % 5);
	}


void Player::updateControls ()
	{
	console->setPopulation(population);
	console->setStorage(storage);
	console->setLand(land);
	console->setMarket(land_price);
	console->plant_status->SetMaxValue(land - flooded);
	console->plant_status->Update(last_yield / harvest - console->plant_status->CurrentValue());
	int plantable = storage * 2;
	if (plantable > console->plant_status->MaxValue() - console->plant_status->CurrentValue())
		plantable = console->plant_status->MaxValue() - console->plant_status->CurrentValue();
	if (plantable > population * 10 - console->plant_status->CurrentValue())
		plantable = population * 10 - console->plant_status->CurrentValue();
	if (plantable < 0)
		plantable = 0;
	console->setPlant(plantable);
	
	console->feed_status->SetMaxValue(population * 20);
	console->feed_status->Update(last_food - console->feed_status->CurrentValue());
	int feedable = storage;
	if (feedable > console->feed_status->MaxValue() - console->feed_status->CurrentValue())
		feedable = console->feed_status->MaxValue() - console->feed_status->CurrentValue();
	console->setFeed(feedable);
	}


void Player::doEnd ()
	{
	char message[512];
	if (isRebellion())
		{
		sprintf(message, "Rebellion!\n\nThe peasants, led by your mother, storm the palace and remove you from office.");
		(new HamAlert(message, "Rebellion Bitmap", true))->Show();
		}
	else
		{
		sprintf(message, "Congratulations!\n\nYour reign has come to an end.\nEach person in your kingdom has %d acres of land.", land / population);
		(new HamAlert(message, "Advisor Bitmap", true))->Show();
		}
	}


bool Player::isRebellion ()
	{
	return (population < 50);
	}
