/*
	
	MorpionWindow.cpp
	
	Copyright 1998 Fumihiko Shibata, All Rights Reserved.
	
*/

#include <Be.h>

#include "MorpionWindow.h"
#include "MorpionView.h"

#define bmsgNewGame			'ngam'
#define bmsgQuitGame		'qgam'
#define	bmsgShowMoves		'smov'
#define	bmsgAutoPlay		'aply'
#define bmsgShowAbout		'sabt'
#define	bmsgShowHelp		'shlp'

MorpionWindow::MorpionWindow(BRect frame)
				: BWindow(frame, "Morpion", B_TITLED_WINDOW, B_NOT_RESIZABLE | B_NOT_ZOOMABLE )
{
	BRect			aRect;

	aRect.Set(0, menuHeight, boardSize, boardSize + menuHeight);
	aView = new MorpionView(aRect, "MorpionView");
	AddChild(aView);

	frame = Bounds();
	frame.bottom = frame.top+15;
	aMenu = new BMenuBar(frame,"MenuBar");

	BMenu *submenu = new BMenu("Game");
	BMenuItem *item;
	submenu->AddItem(item = new BMenuItem(	"New",new BMessage(bmsgNewGame),
											'N',B_COMMAND_KEY));
	submenu->AddSeparatorItem();
	submenu->AddItem(item = new BMenuItem(	"Quit",new BMessage(bmsgQuitGame),
											'Q',B_COMMAND_KEY));
	aMenu->AddItem(submenu);

	submenu = new BMenu("Option");
	submenu->AddItem(showMovesItem = new BMenuItem(	"Show Moves",new BMessage(bmsgShowMoves),
											'S',B_COMMAND_KEY));
	isShowMoves = false;
	submenu->AddItem(item = new BMenuItem(	"Automatic Play",new BMessage(bmsgAutoPlay),
											'P',B_COMMAND_KEY));
	aMenu->AddItem(submenu);

	submenu = new BMenu("Help");
	submenu->AddItem(item = new BMenuItem(	"About...",new BMessage(bmsgShowAbout),
											'A',B_COMMAND_KEY));
	submenu->AddSeparatorItem();
	submenu->AddItem(item = new BMenuItem(	"Help...",new BMessage(bmsgShowHelp),
											'H',B_COMMAND_KEY));
	aMenu->AddItem(submenu);

	aMenu->ResizeToPreferred();
	AddChild(aMenu);
}

bool MorpionWindow::QuitRequested()
{
	be_app->PostMessage(B_QUIT_REQUESTED);
	return(true);
}

void MorpionWindow::MessageReceived(BMessage* message)
{
	switch (message->what) {
		case bmsgNewGame:
			aView->Create();
			break;
		case bmsgQuitGame:
			QuitRequested();
			break;
		case bmsgShowMoves:
			isShowMoves = !isShowMoves;
			showMovesItem->SetMarked(isShowMoves);
			aView->ToggleShowMoves();
			break;
		case bmsgAutoPlay:
			aView->AutoPlay();
			break;
		case bmsgShowAbout:
			beep();
			(new BAlert("", "Morpion\nBeOS Version\n(C) 1998 by Fumihiko Shibata", "Ok"))->Go();
			break;
		case bmsgShowHelp:
			beep();
			(new BAlert("", "Sorry, No Help yet!", "Sigh"))->Go();
			break;
		default:
			BWindow::MessageReceived(message);
	}
}