/*
	
	MorpionView.h
	
	Copyright © 1998 Fumihiko Shibata, All Rights Reserved.
	
*/

#ifndef MORPION_VIEW_H
#define MORPION_VIEW_H

#include <View.h>

const int max_row = 20, max_col = 20;
const int cross = 4, len = 5;

class MorpionView : public BView
{
public:
					MorpionView(BRect frame, const char *name);
					~MorpionView();
	virtual	void	AttachedToWindow();
	virtual void	MouseDown(BPoint point);
	virtual	void	Draw(BRect rect);

	void	AutoPlay();
	void	Create();
	void	ToggleShowMoves();

private:
	int 	dr[8], dc[8];
	bool	finished, automatic, show;
	bool	vertex[max_row + 1][max_col + 1];
	char	edges[max_row + 1][max_col + 1];
	int		score, moves;
	int		mover, movec, moved;
	int		diff;
	
	void	Resize();
	void	DrawBoard();
	bool	InRange(int r, int c);
	bool	PointToCell(BPoint pt, int *r, int *c);
	void	CellToPoint(int r, int c, BPoint *pt);
	void	DrawVertex(int r, int c);
	bool	ValidLine(int r, int c, int d);
	void	ShowMoves();
	void	DLine(BPoint start, int dir);
	void	DoLine(int r, int c, int d);
	void	DoMove(BPoint pt);
	bool	RandomChance(int n);
	void	TestDirection(int r, int c, int i, int *cnt, BPoint start);
};

#endif
