#! /bin/sh
#
# Install script for SWIG 1.1p5 for BeOS (PowerPC Edition).
#
# This was automatically generated by /src/packager/packager.py.

home_dest=/boot/home/config
app_dest=/boot/apps/SWIG1.1p5
app_dir=SWIG1.1p5

trash_path=/boot/home/Desktop/Trash

do_an_error() {
	cat << HTMLEOF > /tmp/${app_dir}_error.html
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0//EN">
<html>
<head>
<title>SWIG 1.1p5 for BeOS (PowerPC Edition)</title>
<meta name="generated-by" content="install.sh">
</head>
<body bgcolor="#ffffcb" text="#000000" link="#0000ff" vlink="#ff00ff" alink="#ff0000">
<h1>SWIG 1.1p5 for BeOS (PowerPC Edition) Installation Error</h1>
<p>You must run <tt>install.sh</tt> from a Terminal in the
<tt>SWIG1.1p5</tt> directory.</p>
<p>Please open a Terminal and run:</p>
<pre>
./install.sh
</pre>
<p>from the directory where you unpacked SWIG 1.1p5 for BeOS (PowerPC Edition).</p>
</body>
</html>
HTMLEOF
	/boot/apps/NetPositive file:///tmp/${app_dir}_error.html
	rm -f /tmp/${app_dir}_error.html
	exit 1
}

do_trash() {
	for item in $@ ; do
		if [ -e $item ] ; then
			echo "Moving old $item to the Trash..."
			mv $item $trash_path
		fi
	done
}

echo "Checking for the installation files..."
for item in "SWIG1.1p5/BeOS" "SWIG1.1p5/Copyright" "SWIG1.1p5/Doc" "SWIG1.1p5/Examples" "SWIG1.1p5/INSTALL" "SWIG1.1p5/Misc" "SWIG1.1p5/NEW" "SWIG1.1p5/README" "SWIG1.1p5/TROUBLESHOOTING" "SWIG1.1p5/Tests" "SWIG1.1p5/ToDo" "SWIG1.1p5/config.cache" "SWIG1.1p5/config.status" "SWIG1.1p5/home/config/bin/swig" "SWIG1.1p5/home/config/include/swig.h" "SWIG1.1p5/home/config/lib/libswig.a" "SWIG1.1p5/home/config/lib/libswigpy.a" "SWIG1.1p5/home/config/lib/libswigpy.so" "SWIG1.1p5/home/config/lib/libswigtcl.a" "SWIG1.1p5/home/config/lib/swig_lib" "SWIG1.1p5/home/config/man/man1/swig.1"  ; do
	if [ ! -e "$item" ] ; then
		echo "Can't find $item in SWIG1.1p5!"
		do_an_error
	fi
done

echo "Making target folders..."
for folder in "/boot/apps/SWIG1.1p5" "/boot/home/config/bin" "/boot/home/config/include" "/boot/home/config/lib" "/boot/home/config/man/man1"  ; do
	if [ ! -e "$folder" ] ; then
		mkdir -p "$folder"
	fi
done

cp README.html $app_dest
settype -t text/html ${app_dest}/README.html

echo "Installing BeOS into ${app_dest}..."
do_trash /boot/apps/SWIG1.1p5/BeOS
mv SWIG1.1p5/BeOS /boot/apps/SWIG1.1p5

echo "Installing Copyright into ${app_dest}..."
do_trash /boot/apps/SWIG1.1p5/Copyright
mv SWIG1.1p5/Copyright /boot/apps/SWIG1.1p5

echo "Installing Doc into ${app_dest}..."
do_trash /boot/apps/SWIG1.1p5/Doc
mv SWIG1.1p5/Doc /boot/apps/SWIG1.1p5

echo "Installing Examples into ${app_dest}..."
do_trash /boot/apps/SWIG1.1p5/Examples
mv SWIG1.1p5/Examples /boot/apps/SWIG1.1p5

echo "Installing INSTALL into ${app_dest}..."
do_trash /boot/apps/SWIG1.1p5/INSTALL
mv SWIG1.1p5/INSTALL /boot/apps/SWIG1.1p5

echo "Installing Misc into ${app_dest}..."
do_trash /boot/apps/SWIG1.1p5/Misc
mv SWIG1.1p5/Misc /boot/apps/SWIG1.1p5

echo "Installing NEW into ${app_dest}..."
do_trash /boot/apps/SWIG1.1p5/NEW
mv SWIG1.1p5/NEW /boot/apps/SWIG1.1p5

echo "Installing README into ${app_dest}..."
do_trash /boot/apps/SWIG1.1p5/README
mv SWIG1.1p5/README /boot/apps/SWIG1.1p5

echo "Installing TROUBLESHOOTING into ${app_dest}..."
do_trash /boot/apps/SWIG1.1p5/TROUBLESHOOTING
mv SWIG1.1p5/TROUBLESHOOTING /boot/apps/SWIG1.1p5

echo "Installing Tests into ${app_dest}..."
do_trash /boot/apps/SWIG1.1p5/Tests
mv SWIG1.1p5/Tests /boot/apps/SWIG1.1p5

echo "Installing ToDo into ${app_dest}..."
do_trash /boot/apps/SWIG1.1p5/ToDo
mv SWIG1.1p5/ToDo /boot/apps/SWIG1.1p5

echo "Installing config.cache into ${app_dest}..."
do_trash /boot/apps/SWIG1.1p5/config.cache
mv SWIG1.1p5/config.cache /boot/apps/SWIG1.1p5

echo "Installing config.status into ${app_dest}..."
do_trash /boot/apps/SWIG1.1p5/config.status
mv SWIG1.1p5/config.status /boot/apps/SWIG1.1p5

echo "Installing bin/swig into ${home_dest}..."
do_trash /boot/home/config/bin/swig
mv SWIG1.1p5/home/config/bin/swig /boot/home/config/bin

echo "Installing include/swig.h into ${home_dest}..."
do_trash /boot/home/config/include/swig.h
mv SWIG1.1p5/home/config/include/swig.h /boot/home/config/include

echo "Installing lib/libswig.a into ${home_dest}..."
do_trash /boot/home/config/lib/libswig.a
mv SWIG1.1p5/home/config/lib/libswig.a /boot/home/config/lib

echo "Installing lib/libswigpy.a into ${home_dest}..."
do_trash /boot/home/config/lib/libswigpy.a
mv SWIG1.1p5/home/config/lib/libswigpy.a /boot/home/config/lib

echo "Installing lib/libswigpy.so into ${home_dest}..."
do_trash /boot/home/config/lib/libswigpy.so
mv SWIG1.1p5/home/config/lib/libswigpy.so /boot/home/config/lib

echo "Installing lib/libswigtcl.a into ${home_dest}..."
do_trash /boot/home/config/lib/libswigtcl.a
mv SWIG1.1p5/home/config/lib/libswigtcl.a /boot/home/config/lib

echo "Installing lib/swig_lib into ${home_dest}..."
do_trash /boot/home/config/lib/swig_lib
mv SWIG1.1p5/home/config/lib/swig_lib /boot/home/config/lib

echo "Installing man/man1/swig.1 into ${home_dest}..."
do_trash /boot/home/config/man/man1/swig.1
mv SWIG1.1p5/home/config/man/man1/swig.1 /boot/home/config/man/man1

echo "Installation done!"

exit 0
