// =============================================================================
//	sample.cp -- Sample Application for Red 1.0
// =============================================================================

#include "sample.h"

#include <Bitmap.h>
#include <MenuBar.h>
#include <File.h>
#include <Resources.h>
#include <stdlib.h>

SIcons	*s_icons = NULL;

enum {
	MENU_ICON = 0,
	BUTTON_ICON
};

// -----------------------------------------------------------------------------
//	SApplication
// -----------------------------------------------------------------------------

SApplication::SApplication(
	const char	*signature)
		: BApplication(signature)
{
	s_icons = new SIcons;

	BRect		frame(100, 100, 240, 190);
	BWindow		*window = new SWindow(frame, "Red Sample", B_TITLED_WINDOW, 0);
	window->Show();
}

// -----------------------------------------------------------------------------
//	SIcons
// -----------------------------------------------------------------------------

SIcons::SIcons()
{
	status_t	status;

	app_info	info;
	status = be_app->GetAppInfo(&info);
	if (status != B_OK) return;

	BFile	file;
	status = file.SetTo(&info.ref, B_READ_ONLY);
	if (status != B_OK) return;

	BResources	resources;
	status = resources.SetTo(&file);
	if (status != B_OK) return;

	size_t	size;
	void	*p = resources.FindResource('RIcn', 0, &size);
	if (p == NULL) return;

	BMessage	msg;
	status = msg.Unflatten(static_cast<char *>(p));
	free(p);
	if (status != B_OK) return;

	int32		index = 0;
	BMessage	archive;
	while (true) {
		status = msg.FindMessage("icons", index++, &archive);
		if (status != B_OK) break;
		BBitmap		*bitmap = cast_as(instantiate_object(&archive), BBitmap);
		if (bitmap) mList.AddItem(bitmap);
	}
}

const BBitmap *
SIcons::Bitmap(
	int32	index) const
{
	return static_cast<BBitmap *>(mList.ItemAt(index));
}

// -----------------------------------------------------------------------------
//	SWindow
// -----------------------------------------------------------------------------

SWindow::SWindow(
	BRect			frame,
	const char		*title, 
	window_type		type,
	uint32			flags,
	uint32			workspace)
		: BWindow(frame, title, type, flags, workspace)
{
	frame.OffsetTo(B_ORIGIN);
	BMenuBar	*menuBar = new BMenuBar(frame, NULL);
	BMenu		*menu = new SMenu("File");
	BMenuItem	*item = new SMenuItem(
		"Quit", new BMessage(B_QUIT_REQUESTED), s_icons->Bitmap(MENU_ICON),
		'Q', B_COMMAND_KEY);

	menu->AddItem(item);
	menuBar->AddItem(menu);
	AddChild(menuBar);
	
	frame.Set(0, 0, 43, 43);
	frame.OffsetTo(10, 30);
	BView	*view = new SButton(frame, NULL, s_icons->Bitmap(BUTTON_ICON), NULL);
	AddChild(view);
}

bool
SWindow::QuitRequested()
{
	be_app->PostMessage(B_QUIT_REQUESTED);
	return true;
}

// -----------------------------------------------------------------------------
//	SMenu
// -----------------------------------------------------------------------------

SMenu::SMenu(
	const char		*title,
	menu_layout		layout)
		: BMenu(title, layout)
{
	float	left, top, right, bottom;
	GetItemMargins(&left, &top, &right, &bottom);
	left += 10;
	SetItemMargins(left, top, right, bottom);
}

// -----------------------------------------------------------------------------
//	SMenuItem
// -----------------------------------------------------------------------------

SMenuItem::SMenuItem(
	const char		*label,
	BMessage		*message,
	const BBitmap	*bitmap,
	char			shortcut,
	uint32			modifiers)
		: mBitmap(bitmap),
		  BMenuItem(label, message, shortcut, modifiers)
{
}

void
SMenuItem::DrawContent()
{
	BMenuItem::DrawContent();

	BMenu	*menu = Menu();

	BRect	frame  = menu->Frame(),
			bounds = mBitmap->Bounds();
	
	frame.OffsetBy(0, (frame.Height()-bounds.Height())/2);
	
	menu->SetDrawingMode(B_OP_OVER);
	menu->DrawBitmapAsync(mBitmap, frame.LeftTop());
	menu->SetDrawingMode(B_OP_COPY);
}

// -----------------------------------------------------------------------------
//	SButton
// -----------------------------------------------------------------------------

SButton::SButton(
	BRect			frame,
	const char		*name,
	const BBitmap	*bitmap, 
	BMessage		*message,
	uint32			resizeMask,
	uint32			flags)
		: mBitmap(bitmap),
		  BButton(frame, name, B_EMPTY_STRING, message, resizeMask, flags)
{
}

void
SButton::Draw(
	BRect	updateRect)
{
	BButton::Draw(updateRect);
	
	BRect	bounds1 = Bounds(),
			bounds2 = mBitmap->Bounds();
	
	bounds1.OffsetBy(
		(bounds1.Width ()-bounds2.Width ())/2,
		(bounds1.Height()-bounds2.Height())/2);

	BPoint	pt = bounds1.LeftTop();
	if (Value() == B_CONTROL_ON) {
		pt += BPoint(2, 2);
	}
	
	
	SetDrawingMode(B_OP_OVER);
	DrawBitmapAsync(mBitmap, pt);
	SetDrawingMode(B_OP_COPY);
}

// -----------------------------------------------------------------------------
//	main
// -----------------------------------------------------------------------------

main()
{
	new SApplication("application/x-vnd.EarthSoft-RedSample");
	be_app->Run();
	delete be_app;
	
	return 0;
}
