#! /bin/sh
#
# Install script for Python on BeOS.
#
# By Chris Herborth (chrish@qnx.com)

python_version=1.5.1

config_path=/boot/home/config
app_path=/boot/apps/Python-$python_version
npos_path=/boot/apps/NetPositive
trash_path=/boot/home/Desktop/Trash

do_an_error() {
	cat << HTMLEOF > /tmp/Python_error.html
<html>
<head><title>Python $python_version Installation Error</title></head>
<body text="#000000" bgcolor="#ffffcb">
<h1>Python Installation Error</h1>
<p>You must run <tt>install.sh</tt> from a Terminal in the <tt>Python</tt>
directory.</p>
</body>
</html>
HTMLEOF
	$npos_path file:///tmp/Python_error.html
	rm -f /tmp/Python_error.html
	exit 1
}

do_trash() {
	for item in $@; do
		if [ -e $item ] ; then
			echo "Moving old $item to the Trash..."
			mv -v $item $trash_path
		fi
	done
}

echo "Checking for the Python files..."
for item in Python-$python_version Python-$python_version/Grammar \
	Python-$python_version/home Python-$python_version/Misc \
	Python-$python_version/README Python-$python_version/Tools ; do
	if test ! -e $item ; then
		echo "Can't find $i! ARGH!"
		do_an_error
	fi
done

echo "Installing Python executable into $config_path/bin..."
do_trash $config_path/bin/python $config_path/bin/python1.5
mv -v Python-$python_version/home/config/bin/python* $config_path/bin

echo "Installing Python shared library into $config_path/lib..."
if [ ! -e $config_path/lib ] ; then
	mkdir -p $config_path/lib
fi
do_trash $config_path/lib/libpython1.5.so $config_path/lib/python1.5
mv -v Python-$python_version/home/config/lib/libpython1.5.so $config_path/lib
mv -v Python-$python_version/home/config/lib/python1.5 $config_path/lib

echo "Installing Python include files into $config_path/include..."
if [ ! -e $config_path/include ] ; then
	mkdir -p $config_path/include
fi
do_trash $config_path/include/python1.5
mv -v Python-$python_version/home/config/include/python1.5 $config_path/include

echo "Installing Python man(1) page into $config_path/man..."
if [ ! -e $config_path/man/man1 ] ; then
	mkdir -p $config_path/man/man1
fi
do_trash $config_path/man/man1/python.1
mv -v Python-$python_version/home/config/man/man1/python.1 $config_path/man/man1

echo "Installing other Python goodies in $app_path..."
do_trash $app_path
mkdir -p $app_path
for item in Grammar Misc README Tools ; do
	mv -v Python-$python_version/$item $app_path
done
cp -V README.html $app_path
settype -t text/html $app_path/README.html

echo "Testing the Python installation..."
cat > ./test.py << EOF
#! /bin/env python
""" Simple test. """

def main():
	print "*** Hello, world!"
	print "*** If you can read this, your Python is installed properly."

if __name__ == "__main__":
	main()
EOF
chmod +x ./test.py
./test.py
