#pragma once
/////////////////////////////////////////////////////////////////////////////
//
//	License Agreement.
//
//	SideTree Relese 1 (c)		
//
//	If you are using this library to develop a software which is free and
//	won't give you a profit (monetary), then you are allowed to use this
//	software for free. Otherwise, if you are using this library to develop
//	a commercial software and will get profit from it, you have to pay US$1.00,
//	for each copy that you sell, to Gerardo Diaz; or negotiate with him to agree
//	in a payment if it is a one-copy software.
//	
//	All the prices (for copies sold or for one-copy software)are subject to 
//	explicit negociation within the parties.
//	 
//	Please contact gdiaz@blackbox.cegs.itesm.mx for any commets, feedback, 
//	inform that you are using SideTree, or to negociate in a certain payment. 
//	
//	Developed by:
//		Gerardo Diaz
//		gdiaz@blackbox.cegs.itesm.mx
//
/////////////////////////////////////////////////////////////////////////////

#include "STNode.h"
#include <ListView.h>

#define ST_MULTIPLE_SELECTION_TREE B_MULTIPLE_SELECTION_LIST
#define ST_SINGLE_SELECTION_TREE B_SINGLE_SELECTION_LIST

#define ST_ERROR -1

typedef list_view_type SIDETREE_VIEW_TYPE;

typedef struct{
    int level;
    short *path;
    char *name;
    void *exdata;
} ST_TRANSACTION;

class SideTree : public BView, public BInvoker
{
	public:
		SideTree(BRect, char *, SIDETREE_VIEW_TYPE, uint32, uint32, short);
		SideTree(BMessage *);
		BArchivable *Instantiate(BMessage *);
		void Init();
		~SideTree(void);
		status_t Archive(BMessage *, bool);
		AddItem(ST_TRANSACTION *);
		RemoveItem(ST_TRANSACTION *);
		SelectItem(ST_TRANSACTION *);
		SelectItem(ST_TRANSACTION *stToParent, int32 *sons, int32 nsons, bool extend = false);
		SelectRange(ST_TRANSACTION *stToParent, int32 start, int32 end, bool extend = false);
		void DeselectAll();
		void Deselect(ST_TRANSACTION *);
		int32 *CurrentSelection(ST_TRANSACTION *stToParent, size_t *numElems);
		bool IsSelectionEqualToCurrent(ST_TRANSACTION *stt, int32 *sons, size_t numSons);
		bool IsPathToParentEqualToCurrent(ST_TRANSACTION *);
		void GetItem(ST_TRANSACTION *);
		virtual void MessageReceived(BMessage *);
		virtual void SetSelectionMessage(BMessage *);
		BMessage *SelectionMessage();
		uint32 SelectionCommand();
		virtual void SetInvocationMessage(BMessage *);
		BMessage *InvocationMessage();
		uint32 InvocationCommand();
		virtual void TargetedByScrollView(BScrollView *);
		virtual void AttachedToWindow();
		
	private:
		RemoveSonsOfItemWithPointer(STNode *);
		STNode *tree;
		short *selpath;
		short levels;
		short withsons;
		int32 mltpSel;
		
		
		int cols;
		float widthL;
		BScrollView *scroller;
		
		BMessage *SelMsg;
		BMessage *InvMsg;
		
		BScrollView **listOfScrollableLists;
		
		SIDETREE_VIEW_TYPE typeofLists;
		
};