#include "Window.h"
#include "View.h"
#pragma export on
#include "SideTree.h"
#pragma export off

Window::Window(BRect wndFrame) :
			BWindow(wndFrame, "SideTreeTest", B_TITLED_WINDOW, B_NOT_RESIZABLE | B_NOT_ZOOMABLE)
{
	ST_TRANSACTION stt;
	short p[10];
	BRect r = Bounds();
	View  *myView = new View(r);
	AddChild(myView);
	
	r.Set(10, 110, 364, 210);
	SideTree *mySTree = new SideTree(r, "SideTree1", ST_MULTIPLE_SELECTION_TREE,
							B_FOLLOW_ALL, B_WILL_DRAW, 2);
	stt.level = 0;
	stt.path = p;
	stt.name = "BArchivable";	
	mySTree->AddItem(&stt);

	stt.level = 0;
	stt.path = p;
	stt.name = "BMessage";
	mySTree->AddItem(&stt);
	
	stt.level=0;
	stt.name="BStatable";
	mySTree->AddItem(&stt);
	
	p[0] = 2;
	stt.level = 1;
	stt.path = p;
	stt.name="BNode";
	mySTree->AddItem(&stt);
	
	p[0] = 0;
	stt.level = 1;
	stt.path = p;
	stt.name = "BHandler";
	mySTree->AddItem(&stt);
	
	stt.level = 1;
	stt.path = p;
	stt.name = "BListItem";
	mySTree->AddItem(&stt);
	
	p[1] = 0;
	stt.level = 2;
	stt.path = p;
	stt.name = "BLooper";
	mySTree->AddItem(&stt);
	
	stt.name = "BView";
	mySTree->AddItem(&stt);
	
	myView->AddChild(new BScrollView("ScrollTree",
			 mySTree, B_FOLLOW_LEFT | B_FOLLOW_TOP,
			 0, true, false) );
	//myView->AddChild(mySTree);
	mySTree->Init();
	mySTree->SetTarget(myView);
	//mySTree->SetSelectionMessage(new BMessage(SIDETREE_SELECTION));
	
	r.Set(110, 10, 160, 30);
	BButton *addButton = new BButton(r, "Button", "Add", new BMessage(10));
	myView->AddChild(addButton);
	addButton->SetTarget(myView);
	
	r.Set(110, 40, 160, 60);
	BButton *remButton = new BButton(r, "Button", "Remove", new BMessage(11));
	myView->AddChild(remButton);
	remButton->SetTarget(myView);
	
	r.Set(170, 10, 220, 30);
	BButton *selButton1 = new BButton(r, "Button", "Select 1", new BMessage(12));
	myView->AddChild(selButton1);
	selButton1->SetTarget(myView);
	
	r.Set(170, 40, 220, 60);
	BButton *selButton2 = new BButton(r, "Button", "Select 2", new BMessage(13));
	myView->AddChild(selButton2);
	selButton2->SetTarget(myView);
	
	r.Set(230, 10, 280, 30);
	BButton *desButton1 = new BButton(r, "Button", "DeselectAll", new BMessage(14));
	myView->AddChild(desButton1);
	desButton1->SetTarget(myView);
	
	myView->st = mySTree;
	
	Show();
}

bool Window::QuitRequested()
{
	be_app->PostMessage(B_QUIT_REQUESTED);
	return(true);
}