#include "View.h"
#include "SideTree.h"

View::View(BRect viewFrame)
		: BView(viewFrame, "View", B_FOLLOW_ALL, B_WILL_DRAW)
{
	BRect r;
	ST_TRANSACTION stt;
	short p[10];
	
	SetViewColor(216, 216, 216, 0);
}

void View::MessageReceived(BMessage *msg)
{
	ST_TRANSACTION stt;
	short *p;
	
	switch (msg->what){
		case SIDETREE_SELECTION:
			BAlert *alert = new BAlert("Side Tree Selection", "We have a selection", "OK");
			alert->Go();

			
			break;
		case 10: //Add
			p = (short *)malloc(sizeof(short)*3);
			stt.level = 1;
			p[0] = 0;
			p[1] = 1;
			stt.path = p;
			stt.name = "BSelf";
			st->AddItem(&stt);

			break;
		case 11://Remove
			p = (short *)malloc(sizeof(short)*3);
			stt.level = 1;
			p[0] = 0;
			p[1] = 0;
			p[2] = 0;
			stt.path = p;
			st->RemoveItem(&stt);
			
			break;
		case 12://Select 1
			p=(short *)malloc(sizeof(short)*3);
			p[0] = 0;
			p[1] = 0;
			p[2] = 1;
			stt.level = 2;
			stt.path = p;
			st->SelectItem(&stt);
			break;
		case 13://Select 2
			p=(short *)malloc(sizeof(short)*2);
			p[0] = 2;
			p[1] = 0;
			stt.level = 1;
			stt.path = p;
			st->SelectItem(&stt);
			break;
		case 14: //DeselectAll
			st->DeselectAll();
			break;
		default:
			BView::MessageReceived(msg);
			break;
	}
}