//Extracts sounds from applications resources

//IMPORTANT!
//Requires libmedia.so

#include "Resources.h"
#include <media/Sound.h>

//---Prototypes--
BSound *getsound(long id);
BSound *getsound(const char *name);
void decodeformat(unsigned char *buffer,media_raw_audio_format *format);
void decode4(unsigned char *buffer,void* toop);

//---Useful Functions---
BSound *getsound(long id) {
	unsigned char *sound;
	size_t length;
	get_app_resource('nois',id,&sound,&length);
	media_raw_audio_format format;
	decodeformat(sound,&format);
	unsigned char *worker = sound + 20;
	return new BSound(worker,length - 20,format);
}

BSound *getsound(const char *name) {
	unsigned char *sound;
	size_t length;
	get_app_resource('nois',name,&sound,&length);
	media_raw_audio_format format;
	decodeformat(sound,&format);
	unsigned char *worker = sound + 20;
	return new BSound(worker,length - 20,format);
}

//-----------Internal use--------------------
void decode4(unsigned char *buffer,void* toop) {
	char *one = (char *)(toop);
	char *two = one + 1;
	char *three = two + 1;
	char *four = three + 1;
	*one = *buffer;
	*two = *(buffer + 1);
	*three = *(buffer + 2);
	*four = *(buffer + 3);
}

void decodeformat(unsigned char *buffer,media_raw_audio_format *format) {
	unsigned char *worker;
	worker = buffer;
	decode4(worker,&(format->frame_rate));
	worker = worker + 4;
	decode4(worker,&(format->channel_count));
	worker = worker + 4;
	decode4(worker,&(format->format));
	worker = worker + 4;
	decode4(worker,&(format->byte_order));
	worker = worker + 4;
	decode4(worker,&(format->buffer_size));
	worker = worker + 4;
}