MODULE POPdump;  (* RC 6.3.89 / 29.7.91 *)

  IMPORT OPT := POPT, Out, SYSTEM;
  
  CONST
    (* object modes *)
    Var = 1; VarPar = 2; Con = 3; Fld = 4; Typ = 5; LProc = 6; XProc = 7;
    SProc = 8; CProc = 9; IProc = 10; Mod = 11; Head = 12; TProc = 13;

    (* symbol values and ops *)
    times = 1; slash = 2; div = 3; mod = 4;
    and = 5; plus = 6; minus = 7; or = 8; eql = 9;
    neq = 10; lss = 11; leq = 12; gtr = 13; geq = 14;
    in = 15; is = 16; ash = 17; msk = 18; len = 19;
    conv = 20; abs = 21; cap = 22; odd = 23; not = 33;
    (*SYSTEM*)
    adr = 24; cc = 25; bit = 26; lsh = 27; rot = 28; val = 29;

    (* structure forms *)
    Undef = 0; Byte = 1; Bool = 2; Char = 3; SInt = 4; Int = 5; LInt = 6;
    Real = 7; LReal = 8; Set = 9; String = 10; NilTyp = 11; NoTyp = 12;
    Pointer = 13; ProcTyp = 14; Comp = 15;

    (* composite structure forms *)
    Basic = 1; Array = 2; DynArr = 3; Record = 4;

    (* nodes classes *)
    Nvar = 0; Nvarpar = 1; Nfield = 2; Nderef = 3; Nindex = 4; Nguard = 5; Neguard = 6;
    Nconst = 7; Ntype = 8; Nproc = 9; Nupto = 10; Nmop = 11; Ndop = 12; Ncall = 13;
    Ninittd = 14; Nif = 15; Ncaselse = 16; Ncasedo = 17; Nenter = 18; Nassign = 19;
    Nifelse = 20; Ncase = 21; Nwhile = 22; Nrepeat = 23; Nloop = 24; Nexit = 25;
    Nreturn = 26; Nwith = 27; Ntrap = 28;

    (*function number*)
    assign = 0; newfn = 1; incfn = 13; decfn = 14;
    inclfn = 15; exclfn = 16; copyfn = 18;

    (*SYSTEM function number*)
    getfn = 24; putfn = 25; getrfn = 26; putrfn = 27; sysnewfn = 30; movefn = 31;

  VAR
    allocated: BOOLEAN;
    pl: ARRAY 16384 OF LONGINT;
    plx: INTEGER;
    typform: ARRAY 16, 10 OF CHAR;
    typcomp: ARRAY 5, 10 OF CHAR;
    op: ARRAY 34, 10 OF CHAR;
    pmode: ARRAY 14, 10 OF CHAR;
    fn: ARRAY 32, 10 OF CHAR;


  PROCEDURE OpenViewer;
  BEGIN
    allocated:=TRUE
  END OpenViewer;
  
  PROCEDURE CheckOpen;
  BEGIN
    IF ~allocated THEN OpenViewer END
  END CheckOpen;
  
  PROCEDURE Ch*(ch: CHAR);
  BEGIN CheckOpen; Out.Char(ch);
  END Ch;

  PROCEDURE NL*;
  BEGIN CheckOpen; Out.Ln;
  END NL;

  PROCEDURE Str*(s: ARRAY OF CHAR);
    VAR i: INTEGER;
  BEGIN CheckOpen;
    i:=0;
    WHILE (i <= LEN(s, 0)) & (s[i] # 0X) DO
      IF s[i] = "$" THEN NL ELSE Out.Char(s[i]) END;
      INC(i)
    END;
  END Str;
  
  PROCEDURE LongInt*(i: LONGINT; n: INTEGER);
  BEGIN CheckOpen;
    IF i = MIN(LONGINT) THEN (* avoids TRAP 7 in Texts = bug *)
      Str("-2147483648")
    ELSE Out.LongInt(i, n)
    END
  END LongInt;

  PROCEDURE Hex*(i: LONGINT);
  BEGIN CheckOpen; Out.Hex(i, 8)
  END Hex;

  PROCEDURE WReal*(r: REAL; n: INTEGER);
  BEGIN CheckOpen; Out.Real(r, n, 0)
  END WReal;

  PROCEDURE LongReal*(r: LONGREAL; n: INTEGER);
  BEGIN CheckOpen; Out.LongReal(r, n, 0)
  END LongReal;
  
  PROCEDURE BitSet*(s: SET);
    VAR i, j: INTEGER; notfirst: BOOLEAN;
  BEGIN i := 0; notfirst := FALSE; Ch("{");
    WHILE i <= MAX(SET) DO
      IF i IN s THEN
        IF notfirst THEN Str(", ")
        ELSE notfirst := TRUE
        END ;
        j := i; LongInt(i, 1); INC(i);
        WHILE (i <= MAX(SET)) & (i IN s) DO INC(i) END ;
        IF i-1 > j THEN
          IF i-2 = j THEN Str(", ") ELSE Str("..") END ;
          LongInt(i-1, 1)
        END
      END ;
      INC(i)
    END ;
    Ch("}")
  END BitSet;

  PROCEDURE Ptr(x: OPT.Node): INTEGER;
    VAR i: INTEGER; n: LONGINT;
  BEGIN
    n := SYSTEM.ADR(x^); i := plx-1;
    WHILE (i >= 0) & (pl[i] # n) DO DEC(i) END ;
    IF i < 0 THEN pl[plx]:=n; i := plx; INC(plx) END ; 
    RETURN i
  END Ptr;
  
  PROCEDURE Nr(x: OPT.Node);
  BEGIN
    Ch("["); LongInt(Ptr(x), 1); Str("] ")
  END Nr;
  
  PROCEDURE NrAndPos(x: OPT.Node);
  BEGIN
    Nr(x); Str("= "); Hex(SYSTEM.ADR(x^)); Str("  ")
  END NrAndPos;

  PROCEDURE Error(msg: ARRAY OF CHAR; x: OPT.Node);
  BEGIN
    Str("******error: "); Str(msg); Str(", class="); LongInt(x^.class, 1); NL
  END Error;
  
  PROCEDURE Left(x: OPT.Node);
  BEGIN
    Str("left=");
    IF x^.left = NIL THEN Str("NIL ")
    ELSE Nr(x^.left)
    END
  END Left;
  
  PROCEDURE Right(x: OPT.Node);
  BEGIN
    Str("right=");
    IF x^.right = NIL THEN Str("NIL ")
    ELSE Nr(x^.right)
    END
  END Right;
  
  PROCEDURE Link(x: OPT.Node);
  BEGIN
    Str("link=");
    IF x^.link = NIL THEN Str("NIL ")
    ELSE Nr(x^.link)
    END
  END Link;

  PROCEDURE Type(x: OPT.Struct);
  BEGIN
    IF x^.comp = Basic THEN Str(typform[x^.form])
    ELSE Str(typcomp[x^.comp])
    END
  END Type;
  
  PROCEDURE NameAndType(x: OPT.Node);
  BEGIN
    Str(x^.obj^.name); Ch(" "); Type(x^.typ)
  END NameAndType;
  
  PROCEDURE conval*(x: OPT.Const; typ: OPT.Struct);
    VAR r: REAL;
  BEGIN
    CASE typ^.form OF
      Undef:
    | Bool:
        IF x^.intval = 0 THEN Str("FALSE") ELSE Str("TRUE") END
    | Char..LInt:
        LongInt(x^.intval, 1)
    | Real:
        r := SHORT(x^.realval); WReal(r, 1)
    | LReal:
        LongReal(x^.realval, 1)
    | Set:
        BitSet(x^.setval)
    | String:
        Str(" adr="); LongInt(x^.intval, 1);
        Str(" len="); LongInt(x^.intval2, 1)
    | NilTyp:
    END ;
    Ch(" "); Str(typform[typ^.form])
  END conval;
  
  PROCEDURE^ expr*(x: OPT.Node; followlink: BOOLEAN);
  PROCEDURE^ stat*(x: OPT.Node);

  PROCEDURE design*(x: OPT.Node; nl: BOOLEAN);
  
    PROCEDURE Leaf;
    BEGIN
      IF x^.obj^.mnolev >= 0 THEN
        IF x^.obj^.leaf THEN Str("leaf ")
        ELSE Str("~leaf ")
        END
      END
    END Leaf;
    
  BEGIN
    CASE x^.class OF
      Nvar:
        NrAndPos(x); Str("Nvar "); Leaf; NameAndType(x)
    | Nvarpar:
        NrAndPos(x); Str("Nvarpar "); Leaf; NameAndType(x)
    | Nfield:
        design(x^.left, TRUE); NrAndPos(x); Str("Nfield "); NameAndType(x); Left(x)
    | Nderef:
        design(x^.left, TRUE); NrAndPos(x); Str("Nderef "); Type(x^.typ); Left(x)
    | Nindex:
        design(x^.left, TRUE); expr(x^.right, FALSE); NrAndPos(x); Str("Nindex "); Type(x^.typ); Left(x); Right(x)
    | Nguard:
        design(x^.left, TRUE); NrAndPos(x); Str("Nguard ");
        IF x^.typ^.strobj # NIL THEN Str(x^.typ^.strobj^.name)
        ELSE Type(x^.typ)
        END ;
        Left(x)
    | Neguard:
        design(x^.left, TRUE); NrAndPos(x); Str("Neguard ");
        IF x^.typ^.strobj # NIL THEN Str(x^.typ^.strobj^.name)
        ELSE Type(x^.typ)
        END ;
        Left(x)
    | Ntype:
        NrAndPos(x); Str("Ntype "); NameAndType(x)
    | Nproc:
        NrAndPos(x); Str("Nproc "); NameAndType(x)
    ELSE NrAndPos(x); Error("design expected", x)
    END ;
    IF nl THEN NL END
  END design;
  
  PROCEDURE stat*(x: OPT.Node);
  
    PROCEDURE CaseStat(x: OPT.Node);
      VAR case: OPT.Node;
    BEGIN
      expr(x^.left, FALSE); case := x^.right^.left;
      WHILE case # NIL DO
        expr(case^.left, TRUE); stat(case^.right);
        NrAndPos(case); Str("Ncasedo "); Left(case); Right(case); Link(case); NL;
        case := case^.link
      END ;
      stat(x^.right^.right);
      NrAndPos(x^.right); Str("Ncaselse "); Left(x^.right); Right(x^.right); NL;
      NrAndPos(x); Str("Ncase "); Left(x); Right(x)
    END CaseStat;

  BEGIN
    WHILE x # NIL DO
      CASE x^.class OF
        Nenter:
          NrAndPos(x); Str("Nenter (entry) ");
          IF x^.obj = NIL THEN Str("module ")
          ELSE
            IF x^.obj^.leaf THEN Str("leaf ")
            ELSE Str("~leaf ")
            END ;
            Str("proc="); NameAndType(x); Str("mode="); Str(pmode[x^.obj^.mode])
          END ;
          NL;
          IF x^.left # NIL THEN stat(x^.left);
            NrAndPos(x); Str("Nenter (jump here) ");
            IF x^.obj = NIL THEN Str("module ")
            ELSE Str("proc="); NameAndType(x)
            END ;
            NL
          END ;
          stat(x^.right);
          NrAndPos(x); Str("Nenter (return from here) ");
          IF x^.obj = NIL THEN Str("module ")
          ELSE Str("proc="); NameAndType(x)
          END ;
          Left(x); Right(x)
      | Ninittd:
          NrAndPos(x); Str("Ninittd ")
      | Nassign:
          IF x^.subcl = movefn THEN
            expr(x^.left, FALSE); expr(x^.right, FALSE); expr(x^.right^.link, FALSE); NrAndPos(x);
            Str("Nassign movefn "); Left(x); Right(x); Str("Right-"); Link(x^.right)
          ELSE
            expr(x^.left, FALSE); IF x^.right # NIL THEN expr(x^.right, FALSE) END ;
            NrAndPos(x); Str("Nassign "); Str(fn[x^.subcl]);
            Left(x); Right(x)
          END
      | Ncall:
          design(x^.left, TRUE); expr(x^.right, TRUE); NrAndPos(x); Str("Ncall "); Left(x); Right(x)
      | Nifelse:
          stat(x^.left); stat(x^.right); NrAndPos(x); Str("Nifelse "); Left(x); Right(x)
      | Nif:
          expr(x^.left, FALSE); stat(x^.right); NrAndPos(x); Str("Nif "); Left(x); Right(x)
      | Ncase:
          CaseStat(x)
      | Nwhile:
          expr(x^.left, FALSE); stat(x^.right); NrAndPos(x); Str("Nwhile "); Left(x); Right(x)
      | Nrepeat:
          stat(x^.left); expr(x^.right, FALSE); NrAndPos(x); Str("Nrepeat "); Left(x); Right(x)
      | Nloop:
          stat(x^.left); NrAndPos(x); Str("Nloop "); Left(x)
      | Nexit:
          NrAndPos(x); Str("Nexit ")
      | Nreturn:
          IF x^.left # NIL THEN expr(x^.left, FALSE) END ;
          NrAndPos(x); Str("Nreturn ");
          IF x^.obj = NIL THEN Str("module ")
          ELSE Str("proc="); NameAndType(x); Str("mode="); Str(pmode[x^.obj^.mode]);
            Str("psize="); conval(x^.obj^.conval, OPT.linttyp)
          END ;
          Left(x)
      | Nwith:
          stat(x^.left); stat(x^.right); NrAndPos(x); Str("Nwith "); Left(x); Right(x)
      | Ntrap:
          expr(x^.right, FALSE); NrAndPos(x); Str("Ntrap "); Right(x)
      ELSE NrAndPos(x); Error("stat expected", x)
      END ;
      Link(x); NL; x := x^.link
    END
  END stat;
  
  PROCEDURE expr*(x: OPT.Node; followlink: BOOLEAN);
  BEGIN
    IF x # NIL THEN
      CASE x^.class OF
        Nconst:
          NrAndPos(x); Str("Nconst "); conval(x^.conval, x^.typ)
      | Nupto:
          expr(x^.left, FALSE); expr(x^.right, FALSE); NrAndPos(x); Str("Nupto ");
          Type(x^.typ); Left(x); Right(x)
      | Nmop:
          expr(x^.left, FALSE); NrAndPos(x); Str("Nmop "); Str(op[x^.subcl]);
          IF x^.subcl = is THEN Str(x^.obj^.name); Ch(" "); Type(x^.obj^.typ) END ;
          Type(x^.typ); Left(x)
      | Ndop:
          expr(x^.left, FALSE); expr(x^.right, FALSE); NrAndPos(x); Str("Ndop ");
          Str(op[x^.subcl]); Type(x^.typ); Left(x); Right(x)
      | Ncall:
          design(x^.left, TRUE); expr(x^.right, TRUE); NrAndPos(x); Str("Ncall ");
          Type(x^.typ); Left(x); Right(x)
      ELSE design(x, FALSE)
      END ;
      IF followlink THEN Link(x) END ;
      NL;
      IF followlink THEN expr(x^.link, TRUE) END
    END
  END expr;
  
  PROCEDURE Init;
    VAR i: INTEGER;
  BEGIN i := 0;
    WHILE i < LEN(pmode) DO COPY("****** ", pmode[i]); INC(i) END ;
    COPY("LProc ", pmode[LProc]);
    COPY("XProc ", pmode[XProc]);
    COPY("IProc ", pmode[IProc]);
    COPY("Mod ", pmode[Mod]);
    COPY("TProc ", pmode[TProc]);
    i := 0;
    WHILE i < LEN(typform) DO COPY("****** ", typform[i]); INC(i) END ;
    COPY("Undef ", typform[Undef]);
    COPY("Byte ", typform[Byte]);
    COPY("Bool ", typform[Bool]);
    COPY("Char ", typform[Char]);
    COPY("SInt ", typform[SInt]);
    COPY("Int ", typform[Int]);
    COPY("LInt ", typform[LInt]);
    COPY("Real ", typform[Real]);
    COPY("LReal ", typform[LReal]);
    COPY("Set ", typform[Set]);
    COPY("String ", typform[String]);
    COPY("NilTyp ", typform[NilTyp]);
    COPY("NoTyp ", typform[NoTyp]);
    COPY("Pointer ", typform[Pointer]);
    COPY("ProcTyp ", typform[ProcTyp]);
    i := 0;
    WHILE i < LEN(typcomp) DO COPY("****** ", typcomp[i]); INC(i) END ;
    COPY("Array ", typcomp[Array]);
    COPY("DynArr ", typcomp[DynArr]);
    COPY("Record ", typcomp[Record]);
    i := 0;
    WHILE i < LEN(op) DO COPY("****** ", op[i]); INC(i) END ;
    COPY("times ", op[times]);
    COPY("slash ", op[slash]);
    COPY("div ", op[div]);
    COPY("mod ", op[mod]);
    COPY("and ", op[and]);
    COPY("plus ", op[plus]);
    COPY("minus ", op[minus]);
    COPY("or ", op[or]);
    COPY("eql ", op[eql]);
    COPY("neq ", op[neq]);
    COPY("lss ", op[lss]);
    COPY("leq ", op[leq]);
    COPY("gtr ", op[gtr]);
    COPY("geq ", op[geq]);
    COPY("in ", op[in]);
    COPY("is ", op[is]);
    COPY("ash ", op[ash]);
    COPY("msk ", op[msk]);
    COPY("len ", op[len]);
    COPY("conv ", op[conv]);
    COPY("abs ", op[abs]);
    COPY("cap ", op[cap]);
    COPY("odd ", op[odd]);
    COPY("adr ", op[adr]);
    COPY("not ", op[not]);
    COPY("cc ", op[cc]);
    COPY("bit ", op[bit]);
    COPY("lsh ", op[lsh]);
    COPY("rot ", op[rot]);
    COPY("val ", op[val]);
    i := 0;
    WHILE i < LEN(fn) DO COPY("****** ", fn[i]); INC(i) END ;
    COPY("assign ", fn[assign]);
    COPY("newfn ", fn[newfn]);
    COPY("incfn ", fn[incfn]);
    COPY("decfn ", fn[decfn]);
    COPY("inclfn ", fn[inclfn]);
    COPY("exclfn ", fn[exclfn]);
    COPY("copyfn ", fn[copyfn]);
    COPY("getfn ", fn[getfn]);
    COPY("putfn ", fn[putfn]);
    COPY("getrfn ", fn[getrfn]);
    COPY("putrfn ", fn[putrfn]);
    COPY("sysnewfn ", fn[sysnewfn]);
    COPY("movefn ", fn[movefn]);
  END Init;
  
  PROCEDURE Reset*;
  BEGIN plx := 0
  END Reset;

  PROCEDURE ShowProg* (prog: OPT.Node);
  BEGIN stat(prog)
  END ShowProg;
  
BEGIN Init; Reset; allocated := FALSE
END POPdump.
