MODULE Compiler;  (* RC 6.3.89 / 16.10.92, mmb 19.2.93 / 31.5.94, MG 27.2.96 *)
(* 94-05-24 OptionChar changed *) (* MAH 20.7.94 Debugger interface*)
(* MG 27.2.96 Port to command line interface *)

  IMPORT
    Out, br:=BinaryRider, Files, Args:=ProgramArgs, 
    tr:=TextRider, Strings, POPdump,
    OPP := POPP, OPB := POPB, OPV := POPV, OPT := POPT,
    OPS := POPS, OPC := POPC, OPL := POPL, OPM := POPM;
  
  CONST
    (* compiler options: *)
    inxchk* = 0;  (* x - index check on *)
    ovflchk* = 1;  (* v - overflow check on *)
    ranchk* = 2;  (* r- range check on *)
    typchk* = 3;  (* t - type check on *)
    newsf* = 4;  (* s- generation of new symbol file allowed *)
    ptrinit* = 5;  (* p - pointer initialization *)
    intprinf* = 6;  (* inter-procedural information about register allocation used *)
    nilchk* = 7;  (* n - nil pointer checks on read accesses *)
    assert* = 8;  (* a - assert evaluation *)
    findpc* = 9;  (* f - find text position of breakpc *)
    powerpc* = 10;  (* c - use PowerPC instruction set *)
    now301 = 11; (* w - supress warning 301 *)
    defopt* = {inxchk, typchk, nilchk, ptrinit, assert, powerpc};  (* default options *)
    
    SignOnMessage = "Compiler  RC / MB 31.5.94 / MG 2.8.98";
    
  VAR
    prog*: OPT.Node;
    nocom, showTree, watch: BOOLEAN;
    (* global because of the GC call on Ceres*)
    mainMod*: OPT.Object;  (*<<<< MAH 20.7.94 *)
    flags: SET;
    prgname: OPS.Name;
    cli: tr.Reader;
    
  PROCEDURE Module* (source: ARRAY OF CHAR; options: SET; breakpc: LONGINT; VAR error: BOOLEAN);
    VAR
      key: LONGINT; opt: SET; newSF: BOOLEAN;
      p: OPT.Node; modName: OPS.Name;
      i: INTEGER;
      src: Files.File;
      srcRead: br.Reader;
      res: INTEGER;
  BEGIN
    (* open the source file -- if it exists *)
    IF ~Files.Exists(source) THEN
      Out.String("Source file "); Out.String(source); Out.String(" was not found!"); Out.Ln; error:=TRUE; RETURN
    ELSE
      Out.String(source); Out.String("  compiling  ");
      src:=Files.Old(source, {Files.read}, res);
      srcRead:=br.ConnectReader(src)
    END;
  
    (* IF watch THEN command := "System.Watch"; Oberon.Call(command, Oberon.Par, FALSE, res) END; *)
    opt := defopt / options; i := 0;
    OPM.Init(srcRead); OPS.Init; OPT.Init; OPB.typSize := OPV.TypSize;
    newSF := newsf IN opt;
    IF now301 IN opt THEN OPM.err (-10000) END;
    OPT.OpenScope(0, NIL);
    OPP.Module(p, modName);
    IF findpc IN opt THEN mainMod:=OPT.topScope; ELSE mainMod:=NIL; END;    (*<<<< MAH 21.06.94 *)
    IF OPM.noerr THEN
      OPL.Init(opt); OPV.Init(opt, breakpc);
      OPV.AdrAndSize(OPT.topScope);
      OPM.errpos := 0;
      key := OPM.NewKey();
      OPT.Export(modName, newSF, key);
      IF newSF THEN OPM.LogWStr(" new symbol file") END;
      IF showTree THEN prog := p; POPdump.ShowProg(prog); prog := NIL END;
      IF OPM.noerr THEN
        OPM.OpenRefObj(modName);
        OPC.Init(opt);
        OPV.Module(p);
        IF OPM.noerr THEN
          OPL.OutCode(modName, key);
          IF OPM.noerr THEN
            OPM.CloseRefObj; OPM.LogWNum(4*OPL.pc, 8); OPM.LogWNum(OPL.dsize, 8)
          END
        END
      END ;
      OPL.Close
    END;
    OPT.CloseScope; OPT.Close;
    OPM.LogWLn; error := ~OPM.noerr;
    src.Close();
    (* IF watch THEN command := "System.Watch"; Oberon.Call(command, Oberon.Par, FALSE, res) END *)
  END Module;
  
  PROCEDURE ShowTree*;
  BEGIN showTree := TRUE
  END ShowTree;

  PROCEDURE HideTree*;
  BEGIN showTree := FALSE
  END HideTree;

  PROCEDURE DoWatch*;
  BEGIN watch := TRUE
  END DoWatch;

  PROCEDURE DontWatch*;
  BEGIN watch := FALSE
  END DontWatch;

  PROCEDURE Help;
  BEGIN
    Out.String (prgname); Out.String (" [options] {file}"); Out.Ln;
    Out.String ("where: "); Out.Ln;
    Out.String ("  file   : Name of file to be compiled"); Out.Ln;
    Out.String ("Options:"); Out.Ln;
    Out.String ("-h         Print this text"); Out.Ln;
    Out.String ("-d         Show intermediate syntax tree"); Out.Ln;
    Out.String ("-x         Index check on"); Out.Ln;
    Out.String ("-v         Overflow check on"); Out.Ln;
    Out.String ("-r         Range check on"); Out.Ln;
    Out.String ("-t         Type check on"); Out.Ln;
    Out.String ("-s         Generation of new symbol file allowed"); Out.Ln;
    Out.String ("-p         Pointer initialization"); Out.Ln;
    Out.String ("-n         NIL pointer checks on read accesses"); Out.Ln;
    Out.String ("-a         Assert evaluation"); Out.Ln;
    Out.String ("-f         Find text position of breakpc"); Out.Ln;
    Out.String ("-c         Use PowerPC instruction set"); Out.Ln;
    Out.String ("-w         Suppress warning 301"); Out.Ln;
    Out.Ln;
    Out.String ("Default options: -x -t -n -p -a -c"); Out.Ln
  END Help;

  PROCEDURE Option (arg: ARRAY OF CHAR): BOOLEAN;
  (* pre: 'arg' is a command line parameter, an option to be precise.
     post: 'result' is TRUE iff the back end can handle the passed option.
     side: Some back end internal flags are set depending on the argument
     passed. *)
  BEGIN
    IF arg = "-h" THEN
      Help;
      nocom := TRUE;
    ELSIF arg = "-x" THEN
      flags := flags / {inxchk}
    ELSIF arg = "-v" THEN
      flags := flags / {ovflchk}
    ELSIF arg = "-r" THEN
      flags := flags / {ranchk}
    ELSIF arg = "-t" THEN
      flags := flags / {typchk}
    ELSIF arg = "-s" THEN
      flags := flags / {newsf}
    ELSIF arg = "-p" THEN
      flags := flags / {ptrinit}
    ELSIF arg = "-n" THEN
      flags := flags / {nilchk}
    ELSIF arg = "-a" THEN
      flags := flags / {assert}
    ELSIF arg = "-f" THEN
      flags := flags / {findpc} 
    ELSIF arg = "-c" THEN
      flags := flags / {powerpc} 
    ELSIF arg = "-w" THEN
      flags := flags / {now301}      
    ELSIF arg = "-d" THEN
      showTree := ~showTree            
    ELSE
      RETURN FALSE
    END; (* IF *)
    RETURN TRUE
  END Option;

  PROCEDURE EvalOptions (VAR lastArg: ARRAY OF CHAR);
  BEGIN
    lastArg[0]:=0X;
    LOOP
      IF cli.Res()#tr.done THEN EXIT; END;
      cli.ReadLine(lastArg);
      IF (lastArg[0] # "-") OR ~Option(lastArg) THEN
        EXIT  (* no more options *)
      END (* IF *)
    END (* LOOP *)
  END EvalOptions;

  PROCEDURE Run;
  VAR
    error: BOOLEAN;
    file: ARRAY 256 OF CHAR;
  BEGIN
    cli.ReadLine (prgname);
    nocom := FALSE;
    flags := {};
    error := FALSE;

    IF Args.args.ArgNumber() > 0 THEN
      EvalOptions (file);

      (* all following args should be file names *)
      IF (cli.Res()#tr.done) & (file[0]=0X) THEN  (* error: no module name given *)
        IF ~nocom THEN
          Out.String ("Error: Nothing to compile."); Out.Ln;
          error := TRUE
        END  (* IF *)
      ELSE
        (* just compile single module *)
        LOOP
          Module (file, flags, 0, error);
          cli.ReadLine (file);
          IF cli.Res()#tr.done THEN EXIT
          ELSIF error THEN HALT(1) 
          END
        END
      END; (* IF *)
    ELSE
      Help;
    END; (* IF *)
  END Run;

BEGIN
  HideTree; DontWatch; prog := NIL;
  cli:=tr.ConnectReader(Args.args);
  Out.String(SignOnMessage); Out.Ln; Run
END Compiler.








