/* ------------------------------------------------------------------ 

	Title: GDWindow

	Description:  A window for drawing the WGStdGraph view.

	Author :
		Stephen Wardlaw, M.D.
		Yale University School of Medicine
		20 York St.
		New Haven, CT  06504

	Edit History:	
		03 Dec 97
			Created
------------------------------------------------------------------ */ 
#include "GDWindow.h"

const float mb_height = 15;

GDWindow::GDWindow(BRect frame)
				: BWindow(frame, "Test Graph", B_DOCUMENT_WINDOW, NULL)
{
	Lock();
	// Add the graph to the window
	BRect grafRect = Bounds();
	grafRect.top += mb_height + 2;
	mGraphView= new GDView(grafRect);
	AddChild(mGraphView);
	SetSizeLimits(frame.right - frame.left,9999,frame.bottom - frame.top,9999);

	// Add the main menu bar and menus
	BRect menuRect(0,0,1000,mb_height);
	BMenuBar* menuBar = new BMenuBar(menuRect,"MB");
	
	BMenu*	fileMenu = new BMenu("File");
	BMenuItem* aboutItem = new BMenuItem("About...",new BMessage(B_ABOUT_REQUESTED));
	aboutItem->SetTarget(be_app);
	fileMenu->AddItem(aboutItem);
	fileMenu->AddSeparatorItem();
	fileMenu->AddItem(new BMenuItem("Quit",new BMessage(B_QUIT_REQUESTED)));
	menuBar->AddItem(fileMenu);
	
	BMenu*	editMenu = new BMenu("Edit");
	editMenu->AddItem(new BMenuItem("Erase",new BMessage(G_erase_data)));
	editMenu->SetTargetForItems(mGraphView);
	menuBar->AddItem(editMenu);
	
	BMenu*	paramsMenu = new BMenu("Params");
	BMessage* cFitMesg = new BMessage(G_set_params);
	cFitMesg->AddInt16(pName,0);
	BMessage* p2Mesg = new BMessage(G_set_params);
	p2Mesg->AddInt16(pName,2);
	BMessage* p3Mesg = new BMessage(G_set_params);
	p3Mesg->AddInt16(pName,3);
	BMessage* p4Mesg = new BMessage(G_set_params);
	p4Mesg->AddInt16(pName,4);
	paramsMenu->AddItem(new BMenuItem("Cubic Spline",cFitMesg));
	paramsMenu->AddSeparatorItem();
	paramsMenu->AddItem(new BMenuItem("1st Order",p2Mesg));
	paramsMenu->AddItem(new BMenuItem("2nd Order",p3Mesg));
	paramsMenu->AddItem(new BMenuItem("3rd Order",p4Mesg));
	paramsMenu->SetRadioMode(true);
	paramsMenu->FindItem("2nd Order")->SetMarked(true);
	paramsMenu->SetTargetForItems(mGraphView);
	menuBar->AddItem(paramsMenu);

	BMenu*	axisMenu = new BMenu("Axes");
	BMessage* linMesg = new BMessage(G_change_axis);
	linMesg->AddInt16(aName,scale_linear);
	BMessage* log2Mesg = new BMessage(G_change_axis);
	log2Mesg->AddInt16(aName,scale_log2);
	BMessage* log10Mesg = new BMessage(G_change_axis);
	log10Mesg->AddInt16(aName,scale_log10);
	axisMenu->AddItem(new BMenuItem("Linear",linMesg));
	axisMenu->AddItem(new BMenuItem("Log Base 2",log2Mesg));
	axisMenu->AddItem(new BMenuItem("Common Log",log10Mesg));
	axisMenu->SetRadioMode(true);
	axisMenu->FindItem("Linear")->SetMarked(true);
	axisMenu->SetTargetForItems(mGraphView);
	menuBar->AddItem(axisMenu);

	AddChild(menuBar);
	
	Unlock();
}
// -------------------------------------------------------------------
bool GDWindow::QuitRequested()
{
	be_app->PostMessage(B_QUIT_REQUESTED);
	return(TRUE);
}
