/* ------------------------------------------------------------------ 

	Title: GDView

	Description:  The master view for the GrafDemo application

	Author :
		Stephen Wardlaw, M.D.
		Medical R&D
		191 North Cove Road
		Old Saybrook, CT

	Edit History:	
		12 Dec 97
			Created
------------------------------------------------------------------ */ 
#include "GDView.h"

// -------------------------------------------------------------------
// *  Constructors & Destructor             
// -------------------------------------------------------------------
GDView::GDView(BRect frame,
					const char* title,
					uint32 mode, 
					uint32 flags):BView(frame,title,mode,flags)
{
	const float fView_ht = 20;
	
	// Add the display for the goodness of fit
	BRect fFrame(0,5,150,fView_ht);
	mFitView = new BStringView(fFrame,"Fit View","");
	mFitView->SetFontSize(12);
	AddChild(mFitView);
	
	// Offset the frame to make room for the data display
	frame.OffsetTo(B_ORIGIN);
	BFont theFont;
	GetFont(&theFont);
	float width = theFont.StringWidth("Cubic Spline Fit  ");
	frame.right -= width;
	mGraph = new GDPolyPlot(frame);	
	mGraph->LinkToData(&mData);
	AddChild(mGraph);	
	
	
	// Add the display for the parameters
	BRect dFrame(frame.right,0,Bounds().right,50);
	mDisp = new GDPolyDisp(dFrame);
	mDisp->LinkToData(&mData);
	AddChild(mDisp);
	
	// Add the odometer
	mOdometer = new WGOdometer();
	mOdometer->SetResizingMode(B_FOLLOW_RIGHT | B_FOLLOW_BOTTOM);
	AddChild(mOdometer);
	// Let the components know about each other
	mOdometer->LinkToGraph(mGraph);
	mGraph->AttachOdometer(mOdometer);
	mOdometer->SizeOdometer();
	BRect oFrame = mOdometer->Bounds();
	frame = Bounds();	// Get parent's size
	mOdometer->MoveTo(frame.right - oFrame.Width(),frame.bottom - oFrame.Height() - 15);
	
   
	SetFontSize(12);
	GetFont(&theFont);
	// mGraph->SetGraphFont(&theFont);
	
	rgb_color red = {255,100,100,0};
	rgb_color black = {0,0,0,0};
	// mGraph->SetGraphColor(black);
 }
// -------------------------------------------------------------------
// *  Protected Methods             
// -------------------------------------------------------------------
void
GDView::MessageReceived(BMessage* theMessage)
{   
 	switch ( theMessage->what ){
 	
		case G_erase_data:
			mData.ClearData();
 	   	Reset();
 			break;
			
		case G_invalidate :
			Reset();
			break;
				
		case G_set_params:
			int16 theParam;
			if((theMessage->FindInt16(pName,&theParam) == B_OK) &&
				(theParam != mData.GetFitParams())) {
				mData.SetFitParams(theParam);
 	   		Reset();
			}
			break;
			
		case G_change_axis:
			int16 scaleVal;
			if((theMessage->FindInt16(aName,&scaleVal) == B_OK)) {
				SetGraphAxis(mGraph->mXAxis,(EAxisScale)scaleVal);
				SetGraphAxis(mGraph->mYAxis,(EAxisScale)scaleVal);
				mGraph->ForceReDraw();
			}
			break;
			
   	
		default :
			this->BView::MessageReceived(theMessage);
	}
}
// -------------------------------------------------------------------
void
GDView::Reset()
{
	char text[32] = {0};
	char numStr[16];
	
	if(mData.GetFitParams() > 0 && mData.HaveFit()) {
		::strcpy(text," Chi Sq.of Fit: ");
		::FormatReal(mData.ChiSqValue(),realFmt_float,3,numStr);
		::strcat(text,numStr);
	}
	mFitView->SetText(text);
	mDisp->Invalidate();
	mGraph->Invalidate();
}
// -------------------------------------------------------------------
void
GDView::SetGraphAxis(WGGraphAxis* theAxis, EAxisScale newScale)
{
	theAxis->SetScale(newScale);
	theAxis->SetLabelFormat(realFmt_fixed,0);
	theAxis->SetMinorDivisions(1);
	
	switch (newScale) {
	
		case scale_log2:
			theAxis->SetSpan(1,128);
			break;
		
		case scale_log10:
			theAxis->SetSpan(0.1,1000);
			theAxis->SetLabelFormat(realFmt_float,1);
			theAxis->SetMinorDivisions(9);
			break;

		default:	// Default is linear
			theAxis->SetSpan(0,100);
			theAxis->SetInterval(10);
			break;
	}
}
// -------------------------------------------------------------------

		
