/* ------------------------------------------------------------------ 

	Title: GDPolyPlot

	Description:  A class which puts a graph window to demonstrate
		polynomial data fitting and cubic spline interpolation

	Author :
		Stephen Wardlaw, M.D.
		Yale University School of Medicine
		20 York St.
		New Haven, CT  06504

	Edit History:
		27 Dewcember, 1997
			Adapted for BeOS
		31 March, 1995
			Broke original into three separate classes
		09 Dec 94
			Much alteration for new PP and other classes
		08 May 94
			Added cubic fit routine
		22 Mar 94
			Created for CW C++ from an earlier M2 program
		
------------------------------------------------------------------ */ 

#include "GDPolyPlot.h"
#include "GDView.h"
#include "Cross.h"

//#include "GraphOdometer.h"

// -------------------------------------------------------------------
// *  Constructors & Destructor             
// -------------------------------------------------------------------

GDPolyPlot::GDPolyPlot(BRect frame,  
					  		  const char* title,
					  		  uint32 mode,
					  		  uint32 flags):WGStdGraph(frame,title,mode,flags)
{
	mData = NULL;
	mOdometer = NULL;
}
 
		
GDPolyPlot::~GDPolyPlot()
{
}		
// -------------------------------------------------------------------
// *  Public Methods             
// -------------------------------------------------------------------
void
GDPolyPlot::LinkToData(GDData* theData)
{
	mData = theData;
}
// -------------------------------------------------------------------
void
GDPolyPlot::MouseMoved(BPoint thePt, uint32 transit, const BMessage* theMesg)
{
	/* Since the plot area is somewhat smaller than the area of the view,
	 	we need to specifically test for it and set the cursors as appropriate.
	 	Note that this is a little sloppy, because it will not show a shift key
	 	change until after the cursor position is moved.
 	*/
 	
	uint32 buttons;
	
	GetMouse(&thePt,&buttons);	// Get exact position
	bool inside = mPlotArea.Contains(thePt);
	bool shift = false;
	
	key_info theKeys;
	if(get_key_info(&theKeys) == B_OK) {
		shift = B_SHIFT_KEY & theKeys.modifiers;
	} 
	
	if(inside && transit != B_EXITED_VIEW) {	// Set new cursor type
		mOdometer->Update(thePt);
		
		if(shift) {
			be_app->SetCursor(HollowCross);
		} else {
			be_app->SetCursor(Cross);
		}
		
	} else {
		be_app->SetCursor(B_HAND_CURSOR);
		mOdometer->Update(BPoint(-1,-1));
	}	
}
// -------------------------------------------------------------------
void
GDPolyPlot::RefreshPlot()
{
}
// -------------------------------------------------------------------
// *  Protected Methods             
// -------------------------------------------------------------------
void
GDPolyPlot::MouseDown(BPoint thePoint)
{
	const float pix_err = 3;
	double x,y;
	bool shift = false;
	
	if(!PosnToValue(thePoint,x,y)) {
		return;	// EXIT HERE if not in a valid graph area
	}
	
	key_info theKeys;
	if(get_key_info(&theKeys) == B_OK) {
		shift = B_SHIFT_KEY & theKeys.modifiers;
	} 
	
	if(!shift) {	// Add data point
		if(!mData->AddPoint(x,y)) {
			beep();
		} else {
			// Send an invalidate message
			BMessage theMesg(G_invalidate);
			Parent()->MessageReceived(&theMesg);
		}
		
	} else {		// See if there is a data point to be deleted
		double 	xErr, yErr;
		
		if(!mXAxis->XPosnToVal(thePoint.x + pix_err,xErr)) {
			mXAxis->XPosnToVal(thePoint.x - pix_err,xErr);
		}
		if(mYAxis->YPosnToVal(thePoint.y - pix_err,yErr)) {
			mYAxis->YPosnToVal(thePoint.y + pix_err,yErr);
		}
		xErr = fabs(x - xErr);
		yErr = fabs(y - yErr);
		if(mData->DeletePoint(x,xErr,y,yErr)) {
			BMessage theMesg(G_invalidate);
			Parent()->MessageReceived(&theMesg);
		}
	}
}
// -------------------------------------------------------------------
void
GDPolyPlot::Draw(BRect frame)
{
	double x,y;
	WGStdGraph::Draw(frame);
	SetPlotMark(plotMark_plus);
	for(int n = 0; n < mData->MaxPoints(); n++) {
		if(mData->GetPoint(n,x,y)) {
			PlotPoint(x,y);
		}
	}
	PlotFunct(mData);
}
	
