/* ------------------------------------------------------------------ 

	Title: GDData

	Description:  A class holding and fitting data

	Author :
		Stephen Wardlaw, M.D.
		Yale University School of Medicine
		20 York St.
		New Haven, CT  06504

	Edit History:
		27 December, 1997
			Adapted for BeOS
		31 March, 1995
			Even more reorganization
		09 Dec 94
			Much alteration for new PP and other classes
		08 May 94
			Added cubic fit routine
		22 Mar 94
			Created for CW C++ from an earlier M2 program
		
------------------------------------------------------------------ */ 

#pragma once

#include "WMCubicFit.h"
#include "WMFunctBase.h"
#include "WMPolyFit.h"

const int	max_points = 25;	// Max # of data points

class GDData : public WMFunctBase {

	public:
			GDData();
			
		virtual
			~GDData();
		
	bool	// Tries to add a data point to the array
		AddPoint(double xVal, double yVal);
		
	double	// Returns a value based on fitted data
		CalcYFromX(double xVal);
		
	void	// Clears all of the data points
		ClearData();
		
	double	// The chi-sq value, if a polynomial fit
		ChiSqValue();
		
	bool	// Find and delete a point in specified region, if any
		DeletePoint(double xVal, double xErr,
						double yVal, double yErr);
	int
		GetFitParams() {return mFitParams;}
		
	double	// Returns the requested parameter number
		GetParam(int paramNum);
		
	bool	// Returns true if the requested set is valid
		GetPoint(int index, double &x, double &y);
		
	bool	// Returns true if a valid fit of some kind
		HaveFit() {return mDataFitted;}
		
	int
		MaxPoints() {return max_points;}
			
	void	// If < 2, a cubic spline fit, otherwise a polynomial(numParams) fit
		SetFitParams(int numParams);
		
	protected:
	void
		DoFit();
		
	void
		SortData();
	
	public : // Data
	DataFitSet		mFitSet[max_points];
	int16				mFitParams;
	double			mChiSq;
	bool				mChiSqValid;
	bool				mDataFitted;
	
	protected:	// Data
	WMPolyFit*		mPolyFit;	
	WMCubicFit*		mCubicFit;
};
