// VCard Parser Classes
// Copyright 2002 Peter J. Goodeve
/***************************************************************
You are permitted to use this code for any purpose, provided that
the original author is acknowledged.
No warranty as to fitness for any particular purpose, nor responsibility
for any consequential damage, is expressed or implied.
****************************************************************/


#include <stdio.h>
#include "vcardparser.h"


void VCardItem::clear() {
	void *item;
	for (int i=0; item=keys.ItemAt(i); i++) delete item;
	keys.MakeEmpty();
	for (int i=0; item=texts.ItemAt(i); i++) delete item;
	texts.MakeEmpty();
	used = false;
	next = NULL;
}

bool VCardItem::parse() {
	BString temp(line);
	int32 brkpt = -1;
	do {brkpt = temp.FindFirst(":", brkpt+1);}
		while (brkpt > 0 && temp[brkpt-1] == '\\');
//	if (brkpt < 0) return false;	// not a proper VCard line
	if (brkpt < 0) brkpt = temp.Length();	// probably a key spec -- fudge it
	BString key, textpart;
	temp.MoveInto(key, 0, brkpt);
	if (temp.Length()) temp.MoveInto(textpart, 1, temp.Length()-1);
//	printf("textpart of key %s: %s\n", key.String(), textpart.String());
	int32 n = -1;
	BString *p;
	while ((n = key.FindFirst(";", n+1)) >= 0) {
		if (key[n-1] == '\\') continue;
		p = new BString;
		if (n) key.MoveInto(*p, 0, n);	// note -- may be empty!
		key.Remove(0,1);
		n = -1;
		p->CharacterDeescape('\\');
		keys.AddItem(p);
	}
	p = new BString(key);	// remainder if any
	p->CharacterDeescape('\\');
	keys.AddItem(p);
	n = -1;
	while ((n = textpart.FindFirst(";", n+1)) >= 0) {
		if (textpart[n-1] == '\\') continue;
		BString *p = new BString;
		if (n) textpart.MoveInto(*p, 0, n);	// note -- may be empty!
		textpart.Remove(0,1);
		n = -1;
		p->CharacterDeescape('\\');
		texts.AddItem(p);
//		printf("added text segment %s\n", p->String());
	}
	p = new BString(textpart);	// remainder if any
	p->CharacterDeescape('\\');
	texts.AddItem(p);
	return true;
}

int32 VCardItem::findModifier(BString &m) {
	for (int i=1; i<numKeys(); i++) {
		if (m == *key(i)) return i;
	}
	return 0;
}

///////////////////////////////////////////////////////////////////////

void VCard::clear() {
	void *item;
	for (int i=0; item=items.ItemAt(i); i++) delete item;
	items.MakeEmpty();
	state = EMPTY;
	picked = NULL;
}

bool VCard::addLine(char *s) {
	if (!s) return (state == COMPLETE);
	BString temp(s);
//	printf("string is %d chars -- last is %x\n", temp.Length(), temp[temp.Length()-1]);
//	printf("next to last is %x, then %x\n", temp[temp.Length()-2], temp[temp.Length()-3]);
	int32 last = temp.Length()-1;
	if (last>=0 && temp[last]=='\n') temp.Truncate(last--);
	if (last>=0 && temp[last]=='\r') temp.Truncate(last);
	VCardItem *vcp = new VCardItem(temp);
//	printf("new item %s keyp %p textp %p state %d\n",
//		 vcp->line.String(), vcp->key(), vcp->text(), state);
	if (!vcp->key() || !vcp->text()) return (state == COMPLETE);
//	printf(" key [%s] text [%s]\n", vcp->keyStr(), vcp->textStr());
	switch (state) {
	case EMPTY:
			if (*vcp->key() == "BEGIN" && *vcp->text() == "VCARD") {
				state = BUILDING;
//				printf("set state to BUILDING\n");
			}
			delete vcp;
			break;
	case BUILDING:
			if (*vcp->key() == "END") {
				state = COMPLETE;
//				printf("set state to COMPLETE\n");
				delete vcp;
				return true;
			}
			else items.AddItem(vcp);
			break;
	case COMPLETE:
			delete vcp;
			return true;
			break;
	}
	return false;
}

int32 VCard::pick(char *keyspec) {
	VCardItem temp(keyspec);
	int32 matchcount = 0;
	picked = NULL;
//	printf("picking key %s\n", temp.keyStr());
	for (int i=numLines()-1; i >= 0; i--) {
		VCardItem *curr = line(i);
//		printf("  matching %s ptr %p\n", curr->keyStr(), curr->key());
		if (curr->used || *curr->key() != *temp.key()) continue;
		bool match = true;
		for (int j=1; j < temp.numKeys(); j++)
			if (!curr->findModifier(*temp.key(j))) {
				match = false;
				break;
			}
		if (!match) continue;
		curr->next = picked;
		picked = curr;
		matchcount++;
	}
	return matchcount;
}

VCardItem * VCard::getPicked() {
	VCardItem *temp = picked;
	if (temp) picked = temp->next;
	return temp;
}

///////////////////////////////////////////////////////////////////////
