/**************************************************************************
 **
 ** XCalcView.cpp
 **
 ** The XCalc window
 **
 **************************************************************************
 **
 ** Author  : Nicolas Mougel
 ** E-Mail  : mougel@netcourrier.com
 **
 ** If you update this program, please contact the author.
 **
 ** Edited by BeForum <beforum@hotbox.ru>
 **
 **************************************************************************/

#include <Application.h>
#include <MenuBar.h>
#include <Menu.h>

#include <stdio.h>

#include "XCalcWindow.h"
#include "Preferences.h"

extern Preferences Prefs;

/* 
 * Window constructor : add a view and menus
 */

XCalcWindow :: XCalcWindow(BRect frame) :
	BWindow(frame, "XCalc v2.5.1", B_TITLED_WINDOW_LOOK, B_NORMAL_WINDOW_FEEL, B_NOT_ZOOMABLE | B_NOT_RESIZABLE)
{
	// Load preferences
	if (Prefs.LoadPrefs()==false)
	{
		Prefs.SetDefaultPrefs();
	}

	// View
	myView = new XCalcView(Bounds());
	
	// Menu Bar
	BMenuBar *menubar = new BMenuBar(Bounds(),"Menu Bar");

	// File Menu	
	BMenu *menu = new BMenu("File");
	menu->AddItem(new BMenuItem("About",new BMessage(MENU_FILE_ABOUT)));
	menu->AddSeparatorItem();
	menu->AddItem(new BMenuItem("Quit",new BMessage(MENU_FILE_QUIT),'Q'));
	menubar->AddItem(menu);

	// Edit Menu
	menu = new BMenu("Edit");
	menu->AddItem(new BMenuItem("Cut",new BMessage(MENU_EDIT_CUT),'X'));
	menu->AddItem(new BMenuItem("Copy",new BMessage(MENU_EDIT_COPY),'C'));
	menu->AddItem(new BMenuItem("Paste",new BMessage(MENU_EDIT_PASTE),'V'));
	menubar->AddItem(menu);

	// Tools Menu
	menu = new BMenu("View");
	menu->AddItem(new BMenuItem("Preferences",new BMessage(MENU_VIEW_PREFS), 'P'));
	menu->AddItem(new BMenuItem("Quick Help",new BMessage(MENU_VIEW_HELP), 'H'));
	menu->AddSeparatorItem();
	if (Prefs.GetView()==X_LESS)
		MenuItemLessMore=new BMenuItem("More",new BMessage(MENU_VIEW_MORE),'S');
	else
		MenuItemLessMore=new BMenuItem("Less",new BMessage(MENU_VIEW_MORE),'S');
	menu->AddItem(MenuItemLessMore);
	menubar->AddItem(menu);

	// Add
	AddChild(menubar);
	AddChild(myView);

	// View Less / More
	if (Prefs.GetView()==X_LESS)
		viewMore = false;
	else
	{
		ResizeTo(266,205);
		viewMore = true;
		myView->ViewMore();
	}
	
	MoveTo(Prefs.GetLeft(),Prefs.GetTop());

}

/* 
 * Window Messages : about and quit
 */

void XCalcWindow :: MessageReceived(BMessage* message)
{	
	switch(message->what)
	{
		/* About */
		case MENU_FILE_ABOUT:
           	myAbout=new AboutWindow(BRect(150,150,430,280));
            myAbout->Show();
			break;
		/* Quit */
		case MENU_FILE_QUIT:
			be_app->PostMessage(B_QUIT_REQUESTED);
			break;
		/* View */
		case MENU_VIEW_HELP:
           	myHelp=new HelpWindow(BRect(200,150,450,350));
            myHelp->Show();
			break;
		case MENU_VIEW_PREFS:
           	myPrefs=new PrefsWindow(BRect(200,150,435,350));
            myPrefs->Show();
			break;
			
		case MENU_VIEW_MORE:
			if (viewMore==false)
			{
				ResizeTo(266,205);
				viewMore=true;
				MenuItemLessMore->SetLabel("Less");
				myView->ViewMore();
			}
			else
			{
				ResizeTo(148,205);
				viewMore=false;
				MenuItemLessMore->SetLabel("More");
				myView->ViewLess();
			}
			break;
		/* Base */
		case POPUP_BIN:
		case POPUP_OCT:
		case POPUP_DEC:
		case POPUP_HEX:
			myView->MessageReceived(message);
			break;
		/* Cut/Copy/Paste */
		case MENU_EDIT_CUT:
		case MENU_EDIT_COPY:
		case MENU_EDIT_PASTE:
			myView->MessageReceived(message);
			break;
		/* Default */
		default:
			BWindow::MessageReceived(message);
			break;

	}
}

/* 
 * Window Quit : quit application
 */

bool XCalcWindow :: QuitRequested()
{
	BRect rec = Frame();
	Prefs.SetTop(rec.top);
	Prefs.SetLeft(rec.left);

	// Save preferences
	Prefs.SavePrefs();
	
	be_app->PostMessage(B_QUIT_REQUESTED);
	return(true);
}



