/**************************************************************************
 **
 ** XCalcView.h
 **
 ** The XCalc view header
 **
 **************************************************************************/

#ifndef XCalcView_h
#define XCalcView_h

#include <View.h>
#include <Button.h>
#include <TextView.h>
#include <ScrollView.h>
#include <MenuField.h>
#include <PopUpMenu.h>

#include "XCalcTextView.h"

#define POPUP_BIN		91
#define POPUP_OCT		92
#define POPUP_DEC		93
#define POPUP_HEX		94

/* 
 * The View contains a BTextView and a lot of BButtons !
 */

class XCalcView : public BView
{
	public:
		XCalcView(BRect rec);
		void MessageReceived(BMessage*);
		void AttachedToWindow();
		void ViewMore();
		void ViewLess();
		
	private:
		// Display for the calculator
		XCalcTextView *myDisplay;
		BScrollView *myScrollBar;

		// The buttons of the keypad
		BButton *Button7, *Button8, *Button9,
				*Button4, *Button5, *Button6,
				*Button1, *Button2, *Button3,
				*Button0;
					
		BButton *ButtonEuro, *ButtonCurr;

		BButton *ButtonAdd, *ButtonSub, *ButtonDiv,
				*ButtonMult, *ButtonLeftPar, *ButtonRightPar;

		BButton *ButtonP2, *ButtonRoot, *ButtonPow,
				*ButtonLn, *ButtonExp, *ButtonPi,
				*ButtonCos, *ButtonSin, *ButtonTan,
				*ButtonAcos, *ButtonAsin, *ButtonAtan;

		BButton *ButtonA, *ButtonB, *ButtonC, *ButtonD,
				*ButtonE, *ButtonF;
		
		BButton *ButtonClear, *ButtonBack, *ButtonDot,
				*ButtonRes;

		BMenuField *MenuFieldBase;
		BPopUpMenu *PopUpBase;

		// For string manipulation		
		char *myLine;
		
};

#endif /* XCalcView_h */
