/**************************************************************************
 **
 ** XCalcView.cpp
 **
 ** The XCalc view
 **
 **************************************************************************
 **
 ** Author  : Nicolas Mougel
 ** E-Mail  : mougel@netcourrier.com
 **
 ** If you update this program, please contact the author.
 **
 **************************************************************************/

#include <MenuItem.h>

#include "XCalcWindow.h" 
#include "XCalcView.h"
#include "Preferences.h"

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

// The Preferences
extern Preferences Prefs;

/* 
 * View constructor : add the display and the keypad
 */

XCalcView :: XCalcView(BRect rec) :
	BView(rec, "XCalc View", B_FOLLOW_ALL_SIDES, B_WILL_DRAW)
{
	SetViewColor(216,216,216);
	BMenuItem *myMenuItem;

	// Show display	

	BFont *myFont= new BFont(be_plain_font); 
	myFont->SetSize(14.0); 

	myDisplay = new XCalcTextView(BRect(7, 30, 140, 46), "myDisplay", BRect(0, 0, 2048, 16), B_FOLLOW_ALL_SIDES, B_WILL_DRAW | B_NAVIGABLE);
	myDisplay->SetAlignment(B_ALIGN_RIGHT);
	myDisplay->SetFontAndColor(myFont);
	myScrollBar = new BScrollView("TextScroll", myDisplay, B_FOLLOW_ALL_SIDES, 0, false, false);
	AddChild(myScrollBar);

	// Keypad

	// ^2 sqrt base ( ) / * -

	PopUpBase = new BPopUpMenu("Base");
	myMenuItem= new BMenuItem("Bin",new BMessage(POPUP_BIN));
	PopUpBase->AddItem(myMenuItem);
	myMenuItem= new BMenuItem("Oct",new BMessage(POPUP_OCT));
	PopUpBase->AddItem(myMenuItem);
	myMenuItem= new BMenuItem("Dec",new BMessage(POPUP_DEC));
	myMenuItem->SetMarked(true);
	PopUpBase->AddItem(myMenuItem);
	myMenuItem= new BMenuItem("Hex",new BMessage(POPUP_HEX));
	PopUpBase->AddItem(myMenuItem);

	ButtonP2 = new BButton( BRect(5,55,35,75), "ButtonP2", "^2", new BMessage('bp2'));	
	ButtonRoot = new BButton( BRect(37,55,67,75), "ButtonRoot", "sqrt", new BMessage('brt'));	
	MenuFieldBase = new BMenuField( BRect(69,55,121,75), "Base menu", NULL, PopUpBase, true, B_FOLLOW_NONE);

	ButtonLeftPar = new BButton( BRect(5,55,35,75), "ButtonLeftPar", "(", new BMessage('bltp'));	
	AddChild(ButtonLeftPar);
	ButtonRightPar = new BButton( BRect(37,55,62,75), "ButtonRightPar", ")", new BMessage('brtp'));	
	AddChild(ButtonRightPar);
	ButtonDiv = new BButton( BRect(64,55,89,75), "ButtonDiv", "/", new BMessage('bdiv'));	
	AddChild(ButtonDiv);
	ButtonMult = new BButton( BRect(91,55,116,75), "ButtonMult", "*", new BMessage('bmul'));	
	AddChild(ButtonMult);
	ButtonSub = new BButton( BRect(119,55,143,75), "ButtonSub", "-", new BMessage('bsub'));	
	AddChild(ButtonSub);

	// exp ln E F 7 8 9 +

	ButtonExp = new BButton( BRect(5,84,35,104), "ButtonExp", "exp", new BMessage('bexp'));	
	ButtonLn = new BButton( BRect(37,84,67,104), "ButtonLn", "ln", new BMessage('bln'));	
	ButtonE = new BButton( BRect(69,84,94,104), "ButtonE", "E", new BMessage('be'));	
	ButtonF = new BButton( BRect(96,84,121,104), "ButtonF", "F", new BMessage('bf'));	

	ButtonBack = new BButton( BRect(5,84,35,104), "ButtonBack", "<-", new BMessage('bbck'));	
	AddChild(ButtonBack);
	Button7 = new BButton( BRect(37,84,62,104), "Button7", "7", new BMessage('b7'));	
	AddChild(Button7);
	Button8 = new BButton( BRect(64,84,89,104), "Button8", "8", new BMessage('b8'));	
	AddChild(Button8);
	Button9 = new BButton( BRect(91,84,116,104), "Button8", "9", new BMessage('b9'));	
	AddChild(Button9);
	ButtonAdd = new BButton( BRect(119,84,143,137), "ButtonAdd", "+", new BMessage('badd'));	
	AddChild(ButtonAdd);

	// cos acos C D euro 4 5 6

	ButtonCos = new BButton( BRect(5,113,35,133), "ButtonCos", "cos", new BMessage('bcos'));	
	ButtonAcos = new BButton( BRect(37,113,67,133), "ButtonAcos", "acos", new BMessage('baco'));	
	ButtonC = new BButton( BRect(69,113,94,133), "ButtonC", "C", new BMessage('bc'));	
	ButtonD = new BButton( BRect(96,113,121,133), "ButtonD", "D", new BMessage('bd'));	

	ButtonEuro = new BButton( BRect(5,113,35,133), "ButtonEuro", "euro", new BMessage('beur'));	
	AddChild(ButtonEuro);
	Button4 = new BButton( BRect(37,113,62,133), "Button4", "4", new BMessage('b4'));	
	AddChild(Button4);
	Button5 = new BButton( BRect(64,113,89,133), "Button5", "5", new BMessage('b5'));	
	AddChild(Button5);
	Button6 = new BButton( BRect(91,113,116,133), "Button6", "6", new BMessage('b6'));	
	AddChild(Button6);

	// sin asin A B curr 1 2 3 =

	ButtonSin = new BButton( BRect(5,142,35,162), "ButtonSin", "sin", new BMessage('bsin'));	
	ButtonAsin = new BButton( BRect(37,142,67,162), "ButtonAsin", "asin", new BMessage('basi'));	
	ButtonA = new BButton( BRect(69,142,94,162), "ButtonA", "A", new BMessage('ba'));	
	ButtonB = new BButton( BRect(96,142,121,162), "ButtonB", "B", new BMessage('bb'));	

	ButtonCurr = new BButton( BRect(5,142,35,162), "ButtonCurr", "curr", new BMessage('bcur'));	
	AddChild(ButtonCurr);
	Button1 = new BButton( BRect(37,142,62,162), "Button1", "1", new BMessage('b1'));	
	AddChild(Button1);
	Button2 = new BButton( BRect(64,142,89,162), "Button2", "2", new BMessage('b2'));	
	AddChild(Button2);
	Button3 = new BButton( BRect(91,142,116,162), "Button3", "3", new BMessage('b3'));	
	AddChild(Button3);
	ButtonRes = new BButton( BRect(118,142,143,195), "ButtonRes", "=", new BMessage('bres'));	
	AddChild(ButtonRes);

	// tan atan pi ^y clear 0 .

	ButtonTan = new BButton( BRect(5,171,35,191), "ButtonTan", "tan", new BMessage('btan'));	
	ButtonAtan = new BButton( BRect(37,171,67,191), "ButtonAtan", "atan", new BMessage('bata'));	
	ButtonPi = new BButton( BRect(69,171,94,191), "ButtonPi", "pi", new BMessage('bpi'));	
	ButtonPow = new BButton( BRect(96,171,121,191), "ButtonPow", "^y", new BMessage('bpow'));	

	ButtonClear = new BButton( BRect(5,171,35,191), "ButtonClear", "clear", new BMessage('bcls'));	
	AddChild(ButtonClear);
	Button0 = new BButton( BRect(37,171,89,191), "Button0", "0", new BMessage('b0'));	
	AddChild(Button0);
	ButtonDot = new BButton( BRect(91,171,116,191), "ButtonDot", ".", new BMessage('bdot'));	
	AddChild(ButtonDot);

	// Alloc memory for text manipulation
	myLine=(char *)malloc(1024*sizeof(char));

	ButtonA->SetEnabled(false);
	ButtonB->SetEnabled(false);
	ButtonC->SetEnabled(false);
	ButtonD->SetEnabled(false);
	ButtonE->SetEnabled(false);
	ButtonF->SetEnabled(false);
	
	myDisplay->MakeFocus();
}


/* 
 * View Messages : mouse click on BButtons to put the corresponding
 *				caracters on the display.
 *
 */

void XCalcView :: MessageReceived(BMessage* message)
{
	char myString[2];
	
	int32 start_cursor, finish_cursor;
	myDisplay->GetSelection(&start_cursor, &finish_cursor);

	switch(message->what)
	{
		/* 0 */
		case 'b0':
			myDisplay->KeyDown("0", (int32) 1);
			break;
		/* 1 */
		case 'b1':
			myDisplay->KeyDown("1", (int32) 1);
			break;
		/* 2 */
		case 'b2':
			myDisplay->KeyDown("2", (int32) 1);
			break;
		/* 3 */
		case 'b3':
			myDisplay->KeyDown("3", (int32) 1);
			break;
		/* 4 */
		case 'b4':
			myDisplay->KeyDown("4", (int32) 1);
			break;
		/* 5 */
		case 'b5':
			myDisplay->KeyDown("5", (int32) 1);
			break;
		/* 6 */
		case 'b6':
			myDisplay->KeyDown("6", (int32) 1);
			break;
		/* 7 */
		case 'b7':
			myDisplay->KeyDown("7", (int32) 1);
			break;
		/* 8 */
		case 'b8':
			myDisplay->KeyDown("8", (int32) 1);
			break;
		/* 9 */
		case 'b9':
			myDisplay->KeyDown("9", (int32) 1);
			break;
		/* A */
		case 'ba':
			myDisplay->KeyDown("A", (int32) 1);
			break;
		/* B */
		case 'bb':
			myDisplay->KeyDown("B", (int32) 1);
			break;
		/* C */
		case 'bc':
			myDisplay->KeyDown("C", (int32) 1);
			break;
		/* D */
		case 'bd':
			myDisplay->KeyDown("D", (int32) 1);
			break;
		/* E */
		case 'be':
			myDisplay->KeyDown("E", (int32) 1);
			break;
		/* F */
		case 'bf':
			myDisplay->KeyDown("F", (int32) 1);
			break;
		/* + */
		case 'badd':
			myDisplay->KeyDown("+", (int32) 1);
			break;
		/* - */
		case 'bsub':
			myDisplay->KeyDown("-", (int32) 1);
			break;
		/* * */
		case 'bmul':
			myDisplay->KeyDown("*", (int32) 1);
			break;
		/* / */
		case 'bdiv':
			myDisplay->KeyDown("/", (int32) 1);
			break;
		/* . */
		case 'bdot':
			myDisplay->KeyDown(".", (int32) 1);
			break;
		/* ( */
		case 'bltp':
			myDisplay->KeyDown("(", (int32) 1);
			break;
		/* ) */
		case 'brtp':
			myDisplay->KeyDown(")", (int32) 1);
			break;
		/* cos */
		case 'bcos':
			myDisplay->KeyDown("cos ", (int32) 4);			
			break;
		/* sin */
		case 'bsin':
			myDisplay->KeyDown("sin ", (int32) 4);			
			break;
		/* tan */
		case 'btan':
			myDisplay->KeyDown("tan ", (int32) 4);			
			break;
		/* acos */
		case 'baco':
			myDisplay->KeyDown("acos ", (int32) 5);			
			break;
		/* asin */
		case 'basi':
			myDisplay->KeyDown("asin ", (int32) 5);			
			break;
		/* atan */
		case 'bata':
			myDisplay->KeyDown("atan ", (int32) 5);			
			break;
		/* x^y */
		case 'bpow':
			myDisplay->KeyDown("^", (int32) 1);
			break;
		/* x^2 */
		case 'bp2':
			myDisplay->KeyDown("^2", (int32) 2);
			break;
		/* sqrt */
		case 'brt':
			myDisplay->KeyDown("sqrt ", (int32) 5);			
			break;
		/* exp */
		case 'bexp':
			myDisplay->KeyDown("exp ", (int32) 4);			
			break;
		/* ln */
		case 'bln':
			myDisplay->KeyDown("ln ", (int32) 3);			
			break;
		/* pi */
		case 'bpi':
			myDisplay->KeyDown("pi", (int32) 2);			
			break;
		/* clear */
		case 'bcls':
			strcpy(myLine,"");
			myDisplay->SetText("");
			break;
		/* <- */
		case 'bbck':
			myString[0]=B_BACKSPACE;
			myString[1]='\0';
			myDisplay->KeyDown(myString, (int32) 1);			
			break;
		/* = */
		case 'bres':
			myString[0]=B_ENTER;
			myString[1]='\0';
			myDisplay->KeyDown(myString, (int32) 1);			
			break;

		/* euro */
		case 'beur':
			Prefs.SetEuroMode(P_EUR);
			myString[0]=B_ENTER;
			myString[1]='\0';
			myDisplay->KeyDown(myString, (int32) 1);
			Prefs.SetEuroMode(P_NOT);
			break;

		/* currency */
		case 'bcur':
			Prefs.SetEuroMode(P_CUR);
			myString[0]=B_ENTER;
			myString[1]='\0';
			myDisplay->KeyDown(myString, (int32) 1);
			Prefs.SetEuroMode(P_NOT);
			break;

		/* bin */
		case POPUP_BIN:
			Prefs.SetBaseOutput(P_BIN);
			myString[0]=B_ENTER;
			myString[1]='\0';
			myDisplay->KeyDown(myString, (int32) 1);			
			Prefs.SetBase(P_BIN);
			Button2->SetEnabled(false);
			Button3->SetEnabled(false);
			Button4->SetEnabled(false);
			Button5->SetEnabled(false);
			Button6->SetEnabled(false);
			Button7->SetEnabled(false);
			Button8->SetEnabled(false);
			Button9->SetEnabled(false);
			ButtonA->SetEnabled(false);
			ButtonB->SetEnabled(false);
			ButtonC->SetEnabled(false);
			ButtonD->SetEnabled(false);
			ButtonE->SetEnabled(false);
			ButtonF->SetEnabled(false);
			break;
		/* oct */
		case POPUP_OCT:
			Prefs.SetBaseOutput(P_OCT);
			myString[0]=B_ENTER;
			myString[1]='\0';
			myDisplay->KeyDown(myString, (int32) 1);			
			Prefs.SetBase(P_OCT);
			Button2->SetEnabled(true);
			Button3->SetEnabled(true);
			Button4->SetEnabled(true);
			Button5->SetEnabled(true);
			Button6->SetEnabled(true);
			Button7->SetEnabled(true);
			Button8->SetEnabled(false);
			Button9->SetEnabled(false);
			ButtonA->SetEnabled(false);
			ButtonB->SetEnabled(false);
			ButtonC->SetEnabled(false);
			ButtonD->SetEnabled(false);
			ButtonE->SetEnabled(false);
			ButtonF->SetEnabled(false);
			break;
		/* dec */
		case POPUP_DEC:
			Prefs.SetBaseOutput(P_DEC);
			myString[0]=B_ENTER;
			myString[1]='\0';
			myDisplay->KeyDown(myString, (int32) 1);			
			Prefs.SetBase(P_DEC);
			Button2->SetEnabled(true);
			Button3->SetEnabled(true);
			Button4->SetEnabled(true);
			Button5->SetEnabled(true);
			Button6->SetEnabled(true);
			Button7->SetEnabled(true);
			Button8->SetEnabled(true);
			Button9->SetEnabled(true);
			ButtonA->SetEnabled(false);
			ButtonB->SetEnabled(false);
			ButtonC->SetEnabled(false);
			ButtonD->SetEnabled(false);
			ButtonE->SetEnabled(false);
			ButtonF->SetEnabled(false);
			break;
		/* hex */
		case POPUP_HEX:
			Prefs.SetBaseOutput(P_HEX);
			myString[0]=B_ENTER;
			myString[1]='\0';
			myDisplay->KeyDown(myString, (int32) 1);			
			Prefs.SetBase(P_HEX);
			Button2->SetEnabled(true);
			Button3->SetEnabled(true);
			Button4->SetEnabled(true);
			Button5->SetEnabled(true);
			Button6->SetEnabled(true);
			Button7->SetEnabled(true);
			Button8->SetEnabled(true);
			Button9->SetEnabled(true);
			ButtonA->SetEnabled(true);
			ButtonB->SetEnabled(true);
			ButtonC->SetEnabled(true);
			ButtonD->SetEnabled(true);
			ButtonE->SetEnabled(true);
			ButtonF->SetEnabled(true);
			break;

		/* Cut/Copy/Paste */
		case MENU_EDIT_CUT:
		case MENU_EDIT_COPY:
		case MENU_EDIT_PASTE:
			myDisplay->MessageReceived(message);
			break;
	}

}

/* 
 * View Attached To Window : to catch the button clicks in the view
 */

void XCalcView :: AttachedToWindow()
{
	// ^2 base sqrt ( ) / * -
	ButtonP2->SetTarget(this);
	ButtonRoot->SetTarget(this);
	ButtonLeftPar->SetTarget(this);
	ButtonRightPar->SetTarget(this);
	ButtonDiv->SetTarget(this);
	ButtonMult->SetTarget(this);
	ButtonSub->SetTarget(this);

	// exp ln E F <- 7 8 9 +
	ButtonExp->SetTarget(this);
	ButtonLn->SetTarget(this);
	ButtonE->SetTarget(this);
	ButtonF->SetTarget(this);
	ButtonBack->SetTarget(this);
	Button7->SetTarget(this);
	Button8->SetTarget(this);
	Button9->SetTarget(this);
	ButtonAdd->SetTarget(this);

	// cos acos C D euro 4 5 6
	ButtonCos->SetTarget(this);
	ButtonAcos->SetTarget(this);
	ButtonC->SetTarget(this);
	ButtonD->SetTarget(this);
	ButtonEuro->SetTarget(this);
	ButtonP2->SetTarget(this);
	Button4->SetTarget(this);
	Button5->SetTarget(this);
	Button6->SetTarget(this);

	// sin asin A B curr 1 2 3 =
	ButtonSin->SetTarget(this);
	ButtonAsin->SetTarget(this);
	ButtonA->SetTarget(this);
	ButtonB->SetTarget(this);
	ButtonCurr->SetTarget(this);
	Button1->SetTarget(this);
	Button2->SetTarget(this);
	Button3->SetTarget(this);
	ButtonRes->SetTarget(this);

	// tan atan pi ^y clear 0 .
	ButtonTan->SetTarget(this);
	ButtonAtan->SetTarget(this);
	ButtonPi->SetTarget(this);
	ButtonPow->SetTarget(this);
	ButtonClear->SetTarget(this);
	Button0->SetTarget(this);
	ButtonDot->SetTarget(this);

	myDisplay->MakeFocus();
}

/* 
 * View More
 */

void XCalcView :: ViewMore()
{
	// Add buttons
	AddChild(ButtonP2);
	AddChild(ButtonRoot);
	AddChild(ButtonExp);
	AddChild(ButtonLn);
	AddChild(ButtonCos);
	AddChild(ButtonAcos);
	AddChild(ButtonSin);
	AddChild(ButtonAsin);
	AddChild(ButtonTan);
	AddChild(ButtonAtan);
	AddChild(ButtonA);
	AddChild(ButtonB);
	AddChild(ButtonC);
	AddChild(ButtonD);
	AddChild(ButtonE);
	AddChild(ButtonF);
	AddChild(ButtonPi);
	AddChild(ButtonPow);
	AddChild(MenuFieldBase);

	// Move others
	ButtonLeftPar->MoveBy(118,0);
	ButtonRightPar->MoveBy(118,0);
	ButtonDiv->MoveBy(118,0);
	ButtonMult->MoveBy(118,0);
	ButtonSub->MoveBy(118,0);

	ButtonBack->MoveBy(118,0);
	Button7->MoveBy(118,0);
	Button8->MoveBy(118,0);
	Button9->MoveBy(118,0);

	ButtonEuro->MoveBy(118,0);
	Button4->MoveBy(118,0);
	Button5->MoveBy(118,0);
	Button6->MoveBy(118,0);
	ButtonAdd->MoveBy(118,0);

	ButtonCurr->MoveBy(118,0);
	Button1->MoveBy(118,0);
	Button2->MoveBy(118,0);
	Button3->MoveBy(118,0);
	ButtonRes->MoveBy(118,0);

	ButtonClear->MoveBy(118,0);
	Button0->MoveBy(118,0);
	ButtonDot->MoveBy(118,0);
}

/* 
 * View Less
 */

void XCalcView :: ViewLess()
{
	// Remove buttons
	RemoveChild(ButtonP2);
	RemoveChild(ButtonRoot);
	RemoveChild(ButtonExp);
	RemoveChild(ButtonLn);
	RemoveChild(ButtonCos);
	RemoveChild(ButtonAcos);
	RemoveChild(ButtonSin);
	RemoveChild(ButtonAsin);
	RemoveChild(ButtonTan);
	RemoveChild(ButtonAtan);
	RemoveChild(ButtonA);
	RemoveChild(ButtonB);
	RemoveChild(ButtonC);
	RemoveChild(ButtonD);
	RemoveChild(ButtonE);
	RemoveChild(ButtonF);
	RemoveChild(ButtonPi);
	RemoveChild(ButtonPow);
	RemoveChild(MenuFieldBase);

	// Move others
	ButtonLeftPar->MoveBy(-118,0);
	ButtonRightPar->MoveBy(-118,0);
	ButtonDiv->MoveBy(-118,0);
	ButtonMult->MoveBy(-118,0);
	ButtonSub->MoveBy(-118,0);

	ButtonBack->MoveBy(-118,0);
	Button7->MoveBy(-118,0);
	Button8->MoveBy(-118,0);
	Button9->MoveBy(-118,0);

	ButtonEuro->MoveBy(-118,0);
	Button4->MoveBy(-118,0);
	Button5->MoveBy(-118,0);
	Button6->MoveBy(-118,0);
	ButtonAdd->MoveBy(-118,0);

	ButtonCurr->MoveBy(-118,0);
	Button1->MoveBy(-118,0);
	Button2->MoveBy(-118,0);
	Button3->MoveBy(-118,0);
	ButtonRes->MoveBy(-118,0);

	ButtonClear->MoveBy(-118,0);
	Button0->MoveBy(-118,0);
	ButtonDot->MoveBy(-118,0);
}
