/**************************************************************************
 **
 ** XCalcHelp.cpp
 **
 ** The Help window
 **
 **************************************************************************
 **
 ** Author  : Nicolas Mougel
 ** E-Mail  : mougel@netcourrier.com
 **
 ** If you update this program, please contact the author.
 **
 **************************************************************************/


#include <Application.h>
#include "XCalcHelp.h"

/* 
 * Help window constructor : add a BView
 */

HelpWindow :: HelpWindow(BRect frame) :
	BWindow(frame, "Quick Help", B_TITLED_WINDOW_LOOK, B_NORMAL_WINDOW_FEEL, B_NOT_RESIZABLE | B_NOT_ZOOMABLE)
{
	//myView = new HelpView(Bounds());

	myTextView = new BTextView(BRect(0,0,237,200), "List", Bounds(), B_FOLLOW_ALL_SIDES, B_WILL_DRAW);
	myTextView->SetText("	Known Commands :\n	----------------------------\n\n	+, -			add, substract\n	*, /			multiply, divide\n	()			brackets\n	<-			back button\n	clear			clear button\n	=			compute expression\n	euro			currency to euro\n	curr			euro to currency\n	cos()			cosine\n	sin()			sine\n	tan()			tangent\n	acos()		arc cosine\n	asin()			arc sine\n	atan()			arc tangent\n	exp()			exponential\n	ln()			logarithm\n	^2			square\n	sqrt()			square root\n	^y			power\n	pi			pi number\n	b1011			1011 is a binary number\n	o7201		7201 is an octal number\n	d457			457 is a decimal number\n	xFE			FE is an hexa number\n");
     
	myScrollView = new BScrollView("Help view", myTextView,	B_FOLLOW_LEFT | B_FOLLOW_TOP, B_FOLLOW_ALL_SIDES, false, true, B_FANCY_BORDER);
	AddChild(myScrollView);
}

