/**************************************************************************
 **
 ** XCalcAbout.cpp
 **
 ** The About window with the application's icon
 **
 **************************************************************************
 **
 ** Author  : Nicolas Mougel
 ** E-Mail  : mougel@netcourrier.com
 **
 ** If you update this program, please contact the author.
 **
 ** Edited by BeForum <beforum@hotbox.ru>
 **
 **************************************************************************/


#include <Application.h>
#include <Button.h>
#include <File.h>
#include <AppFileInfo.h>
#include <Bitmap.h>
#include <Roster.h>
#include "XCalcAbout.h"

/* 
 * About window constructor : add a BView
 */

AboutWindow :: AboutWindow(BRect frame) :
	BWindow(frame, "About", B_TITLED_WINDOW_LOOK, B_MODAL_APP_WINDOW_FEEL, B_NOT_RESIZABLE | B_NOT_ZOOMABLE)
{
	AboutView *myView = new AboutView(Bounds());
	AddChild(myView);
}

/* 
 * About view constructor : add a BButton
 */

AboutView :: AboutView(BRect rec) :
	BView(rec, "About View", B_FOLLOW_ALL_SIDES, B_WILL_DRAW)
{
	SetViewColor(216,216,216);
	greatButton=new BButton(BRect(200,100,270,110), "Validate", "Great", new BMessage('vld'));
	AddChild(greatButton);
}

/* 
 * About view : to catch the BButton click in this view
 */

void AboutView :: AttachedToWindow()
{
	greatButton->SetTarget(this);
}

/* 
 * About view : catch the BButtton message
 */

void AboutView :: MessageReceived(BMessage* message)
{
	switch(message->what)
	{
		/* The user wants to close the window */
		case 'vld':
			(Window())->Quit();
			break;
	}
}

/* 
 * About view : display about text and icon 
 */

void AboutView :: Draw(BRect frame)
{
	// Show the About text
	DrawString("XCalc v2.5.1 for BeOS", BPoint(50,20));
	DrawString("Copyright © 1999 Nicolas Mougel", BPoint(50,35));
	DrawString("E-mail : mougel@netcourrier.com", BPoint(50,50));
	DrawString("Home Page : www.chez.com/beos", BPoint(50,65));
	DrawString("R5 support by BeForum (beforum@hotbox.ru)", BPoint(50,80));
	DrawString("Thanks to William Bull for the icon.", BPoint(50,95));
	
	// Display the icon from the application info
	BFile file;
	BAppFileInfo fileinfo;
	app_info info;

	SetHighColor(152,152,152);
	FillRect(BRect(0,0,30,150));
	
	BBitmap icon(BRect(0,0,31,31 ), B_CMAP8);
	be_app->GetAppInfo(&info);
	file.SetTo(&(info.ref), B_READ_ONLY);
	fileinfo.SetTo(&file);
	fileinfo.GetIcon(&icon, B_LARGE_ICON);
	SetLowColor(ViewColor());
	SetDrawingMode(B_OP_OVER);
	DrawBitmap(&icon, BPoint(5,10));

}

