/**************************************************************************
 **
 ** XCalc.cpp
 **
 ** A GUI Calculator
 **
 ** Copyright © 1999 Nicolas Mougel
 **
 ** Under GPL License
 **
 **************************************************************************
 **
 ** Author  : Nicolas Mougel
 ** E-Mail  : mougel@netcourrier.com
 **
 ** If you update this program, please contact the author.
 **
 **************************************************************************
 **
 ** History :
 **
 ** Dec 1995 : First Release (Windows, Unix)
 ** Dec 1998 : Let's go to the BeOS World !
 ** Oct 1999 : GUI Version of XCalc
 ** Dec 1999 : Improvements :
 **			   - Base conversion added
 **			   - Euro conversion
 **			   - Cut/Copy/Paste Menu
 **			   - Preferences Menu
 **			   - View Less/More
 **			   - More math functions
 **			   - Use of BTextView instead of BTextControl
 **			   - When an error occurs put the cursor on the wrong character
 **			   Bugs corrected :
 **			   - Bugs of the parser (expressions like -2-2-2 or 3/3/3 now work)
 **
 **************************************************************************/
 
#include <Application.h>

#include "XCalcWindow.h"
#include "XCalc.h"

/* 
 * Create a window for the Calculator
 */

XCalcApp :: XCalcApp() : BApplication("application/x-vnd.mougel.xcalc")
{
	myWindow = new XCalcWindow(BRect(100, 100, 248, 305));
	myWindow->Show();
}

/* 
 * Main Program
 */

int main()
{ 
	XCalcApp myApp;
	myApp.Run();
	return(B_NO_ERROR);
}

