#ifndef HOOKS_H
#define HOOKS_H


#include <stdlib.h>
#include <math.h>
#include <OS.h>
#include "fteinput.h"


#ifdef __cplusplus
#define EXTERN extern "C"
#else
#define EXTERN
#endif


#define mylog10(xx) (((xx) > 0.0) ? log10(xx) : (- log10(HUGE_VAL)))


#define PLOT_WINDOW_SIZE 400


enum BeUI_MessageCode {Quit, Clear, DrawLine, Arc, Text, DefineColor, 
                       DefineLineStyle, SetLineStyle, SetColor, Update};


struct BeUI_Message {
   /* These are used by DrawLine, Arc, and Text. */
   int x1, y1;
   int x2, y2;
   
   /* These are used by Arc. */
   int radius;
   double theta1, theta2;
   
   /* These are used by DefineColor and SetColor. */ 
   int colorid;
   double red, green, blue;
   
   /* This is used by DefineLineStyle and SetLineStyle. */
   int linestyleid;

   /* This is used by Text. */
   char text[256];
};


EXTERN int BeUI_Init(void);
EXTERN int BeUI_NewViewport(GRAPH *graph);
EXTERN int BeUI_Close(void);
EXTERN int BeUI_Clear(void);
EXTERN int BeUI_DrawLine(int x1, int y1, int x2, int y2);
EXTERN int BeUI_Arc(int x, int y, int radius, 
					 double theta1, double theta2);
EXTERN int BeUI_Text(char *text, int x, int y);
EXTERN int BeUI_DefineColor(int colorid, 
							 double red, double green, double blue);
EXTERN int BeUI_DefineLinestyle(int linestyleid);
EXTERN int BeUI_SetLinestyle(int linestyleid);
EXTERN int BeUI_SetColor(int colorid);
EXTERN int BeUI_Update(void);
EXTERN int BeUI_Input(REQUEST *request, RESPONSE *response);
EXTERN int BeUI_DatatoScreen(GRAPH *graph, double x, double y,
                            int *screenx, int *screeny);


#endif
