#include "hooks.h"


#define STUB { printf("not yet implemented: line %d\n", __LINE__); }


port_id spice_display_port;


EXTERN int BeUI_Init(void)
{
   spice_display_port = create_port(100, "spice_plot_port");
   return 0;
}


EXTERN int BeUI_NewViewport(GRAPH *graph)
{	
   graph->fontwidth = 8;
   graph->fontheight = 8;
   
   graph->absolute.width = PLOT_WINDOW_SIZE;
   graph->absolute.height = PLOT_WINDOW_SIZE;
   
   return 0;
}


EXTERN int BeUI_Close(void)
{
   write_port(spice_display_port, Quit, NULL, 0);
   return 1;
}


EXTERN int BeUI_Clear(void)
{
   system("spice_plot &");
   write_port(spice_display_port, Clear, NULL, 0);
   return 1;
}


EXTERN int BeUI_DrawLine(int x1, int y1, int x2, int y2)
{
   //printf("DrawLine: head=(%d,%d)  tail=(%d,%d)\n", x1, y1, x2, y2);
   //the_view->StrokeLine(BPoint(x1, y1), BPoint(x2, y2));

   struct BeUI_Message msg;

   msg.x1 = x1;
   msg.y1 = PLOT_WINDOW_SIZE - y1;
   msg.x2 = x2;
   msg.y2 = PLOT_WINDOW_SIZE - y2;
	
   write_port(spice_display_port, DrawLine, &msg, sizeof(msg));

   return 1;
}


EXTERN int BeUI_Arc(int x, int y, int radius, double theta1, double theta2)
{
   //printf("Arc: center=(%d,%d)  radius=%d   Theta1=%f  Theta2=%f\n",
   //       x0, y0, radius, theta1, theta2);
   //the_view->StrokeArc(BPoint(x0, y0), radius, radius, theta1, theta2-theta1);

   struct BeUI_Message msg;

   msg.x1 = x;
   msg.y1 = PLOT_WINDOW_SIZE - y;
   msg.radius = radius;
   msg.theta1 = theta1;
   msg.theta2 = theta2;
   
   write_port(spice_display_port, Arc, &msg, sizeof(msg));

   return 1;
}


EXTERN int BeUI_Text(char *text, int x, int y)
{
   //printf("Text: text='%s'  location=(%d,%d)\n", text, x, y);
   //the_view->DrawString(text, BPoint(x, y));

   struct BeUI_Message msg;
   
   msg.x1 = x;
   msg.y1 = PLOT_WINDOW_SIZE - y;
   strcpy(msg.text, text);
   
   write_port(spice_display_port, Text, &msg, sizeof(msg));

   return 1;
}


EXTERN int BeUI_DefineColor(int colorid, double red, double green, double blue)
{
   //printf("DefineColor: colorid=%d  red=%f  greee=%f  blue=%f\n", 
   //       colorid, red, green, blue);
   return 0;
}


EXTERN int BeUI_DefineLinestyle(int linestyleid)
{
   //printf("DefineLinestyle: linestyleid=%d\n", linestyleid);
   return 0;
}


EXTERN int BeUI_SetLinestyle(int linestyleid)
{
   //printf("SetLinestyle: linestyleid=%d\n", linestyleid);

   struct BeUI_Message msg;
   
   msg.x1 = linestyleid;
   
   write_port(spice_display_port, SetLineStyle, &msg, sizeof(msg));

   return 0;
}


EXTERN int BeUI_SetColor(int colorid)
{
   //printf("SetColor: colorid=%d\n", colorid);

   struct BeUI_Message msg;
   
   msg.x1 = colorid;
   
   write_port(spice_display_port, SetColor, &msg, sizeof(msg));

   return 0;
}


EXTERN int BeUI_Update(void)
{
   return 0;
}


EXTERN int BeUI_Input(REQUEST *request, RESPONSE *response)
{
   response->option = error_option;
   return 0;
}


EXTERN int BeUI_DatatoScreen(GRAPH *graph, double x, double y,
			     int *screenx, int *screeny)
{
   double low, high;

   if ((graph->grid.gridtype == GRID_LOGLOG) ||
       (graph->grid.gridtype == GRID_YLOG)) {
      low = mylog10(graph->datawindow.ymin);
      high = mylog10(graph->datawindow.ymax);
      *screeny = (mylog10(y) - low) / (high - low) * 
	 graph->viewport.height + 0.5 + graph->viewportyoff;
   } else {
      *screeny = ((y - graph->datawindow.ymin) / graph->aspectratioy)
	 + 0.5 + graph->viewportyoff;
   }

   if ((graph->grid.gridtype == GRID_LOGLOG) ||
       (graph->grid.gridtype == GRID_XLOG)) {
      low = mylog10(graph->datawindow.xmin);
      high = mylog10(graph->datawindow.xmax);
      *screenx = (mylog10(x) - low) / (high - low) * 
	 graph->viewport.width + 0.5 + graph->viewportxoff;
   } else {
      *screenx = ((x - graph->datawindow.xmin) / graph->aspectratiox)
	 + 0.5 + graph->viewportxoff;
   }

   //printf("DatatoScreen: data=(%f,%f)  screen=(%d,%d)\n",
   //       x, y, *screenx, *screeny);

   return 0;
}
