//*************************************************************	
//  CalendarWindow.cpp    
//	Last Update 980114/18:00
//*************************************************************/

#include	"CalendarWindow.h"
#include	"MonthView.h"
#include	"CalendarMMYY.h"
#include	<string.h>

///////////////////////////////////////////////////////////////
// Menus
//
//
XMenuItem xFileMenu[] = {
    {   "CalendarJ について",   B_ABOUT_REQUESTED,  0   },
    { 	"年月の変更",		X_MMYY,		0   },
    {   "新しく開く",              	X_NEW,              0   },
	{	"祝日表示",				X_HOLIDAYS,	0	},
     {   "閉じる",           		X_CLS,              0   },
   {   NULL,               0,  0 }
};

XMenuItem xMonthMenu[] = {
	{	"１月",			X_JAN,  0},
	{	"２月",			X_FEB,	0},
	{	"３月",			X_MAR,	0},
	{	"４月",			X_APR,	0},
	{	"５月",			X_MAY,	0},
	{	"６月",			X_JUN,	0},
	{	"７月",			X_JUL,	0},
	{	"８月",			X_AUG,	0},
	{	"９月",			X_SEP,	0},
	{	"１０月",			X_OCT,	0},
	{	"１１月",			X_NOV,	0},
	{	"１２月",			X_DEC,	0},
    {   NULL,               0,  0 }
};

XMenuItem xYearMenu[] = {
	{	"来年",		X_NEXT,	0},
	{	"去年",		X_PREV, 0},
    {   NULL,               0,  0 }
};

///////////////////////////////////////////////////////////
//   ReadMenu()
//
//
void
ReadMenu(
    const XMenuItem *items, BMenu *menu, BWindow *win )
{
    while (items->title) {
        if (items->title[0]) {
        	BMessage *msg = new BMessage(items->command);
        	if ( items->command == X_MMYY )
        		msg->AddPointer( "window", win );
            BMenuItem *item = new BMenuItem(items->title, msg, items->key);
            if ( items->command == X_MMYY )
				item->SetTarget( be_app );
			if ( items->command == X_HOLIDAYS )
				item->SetMarked( true );
            menu->AddItem(item);
        } else {
                menu->AddSeparatorItem();
        }
        items++;
    }
};

/////////////////////////////////////////////////////////
// SetupMenus
//
//
void CalendarWindow::SetupMenus()
{
    BMenu		*aMenu;
    BMenuBar	*menuBar;
    BWindow		*win =  (BWindow*) this;

    BRect dummyRect( 0, 0, 10, 10 );
    menuBar = new BMenuBar( dummyRect, "menubar" );

    aMenu = new BMenu( "File" );
    ReadMenu( xFileMenu, aMenu, win );
    menuBar->AddItem( aMenu );
    aMenu = new BMenu( "Month" );
    ReadMenu( xMonthMenu, aMenu, win );
    menuBar->AddItem( aMenu );
    aMenu = new BMenu( "Year" );
    ReadMenu( xYearMenu, aMenu, win );
    menuBar->AddItem( aMenu );
	//"Font Menu"
	aMenu = new BMenu("Font");
		int32	fontNum = count_font_families();
		int32	styleNum;
		int32	i;
		int32	ii;
		font_family	fFamily;
		font_style	fStyle;
		BMenu*	styleMenu;
		BMenuItem*	styleItem;
			
		for(i=0; i<fontNum; i++){
			get_font_family(i,&fFamily);
			styleMenu = new BMenu(fFamily);
			styleNum = count_font_styles(fFamily);
			for(ii=0; ii<styleNum; ii++){
				get_font_style(fFamily,ii,&fStyle);
				styleItem = new BMenuItem(fStyle,new BMessage(X_STYLE));
				styleMenu->AddItem(styleItem);
				styleItem->SetTarget(NULL,this);
			}
			//styleMenu->SetRadioMode(true);
			aMenu->AddItem(styleMenu);
		}
	//aMenu->SetRadioMode(true);
	menuBar->AddItem(aMenu);
	AddChild( menuBar );
}

/////////////////////////////////////////////////////////////////////
// CalendarWindow QuitRequested
//
//
bool CalendarWindow::QuitRequested( void )
{
	return BWindow::QuitRequested();
}

/////////////////////////////////////////////////////////////////////
// CalendarWindow Quit
//
//
void CalendarWindow::Quit( void )
{
	be_app->PostMessage( X_WCLS );
	BWindow::Quit();
	
	return;
} 


/////////////////////////////////////////////////////////////////////
// CalendarWindow MessageReceived
//
//
void CalendarWindow::MessageReceived( BMessage *message )
{
	switch (message->what) {
	case X_NEXT:
        Hide();
		aView->year++;
        aView->Invalidate();
        Show(); 
		break;
	case X_PREV:
        Hide();
		aView->year--;
        aView->Invalidate();
        Show(); 
		break;
	case X_JAN:
        Hide();
		aView->month=1;
        aView->Invalidate();
        Show(); 
		break;
	case X_FEB:
        Hide();
		aView->month=2;
        aView->Invalidate();
        Show(); 
		break;
	case X_MAR:
        Hide();
		aView->month=3;
        aView->Invalidate();
        Show(); 
		break;
	case X_APR:
        Hide();
		aView->month=4;
        aView->Invalidate();
        Show(); 
		break;
	case X_MAY:
        Hide();
		aView->month=5;
        aView->Invalidate();
        Show(); 
		break;
	case X_JUN:
        Hide();
		aView->month=6;
        aView->Invalidate();
        Show(); 
		break;
	case X_JUL:
        Hide();
		aView->month=7;
        aView->Invalidate();
        Show(); 
		break;
	case X_AUG:
        Hide();
		aView->month=8;
        aView->Invalidate();
        Show(); 
		break;
	case X_SEP:
        Hide();
		aView->month=9;
        aView->Invalidate();
        Show(); 
		break;
	case X_OCT:
        Hide();
		aView->month=10;
        aView->Invalidate();
        Show(); 
		break;
	case X_NOV:
        Hide();
		aView->month=11;
        aView->Invalidate();
        Show(); 
		break;
	case X_DEC:
        Hide();
		aView->month=12;
        aView->Invalidate();
        Show(); 
		break;
	case X_CLS:
		Quit();
		break;
	case X_STYLE:
		BMenuItem* menuitem;
		message->FindPointer("source", &menuitem);
		BMenu *aMenu  = menuitem->Menu()->Supermenu();
		for (int i=0; i < aMenu->CountItems(); i++) {
			BMenuItem *item = aMenu->ItemAt(i);
			item->SetMarked(false);
			BMenu *submenu = item->Submenu();
			if (submenu) {
				for (int ii= 0; ii < submenu->CountItems(); ii++)
					submenu->ItemAt(ii)->SetMarked(false);
			}
		}
		BFont font; 
		aView->GetFont(&font);
		strcpy((char *)aView->family, 
			(char *)menuitem->Menu()->Superitem()->Label());
		strcpy((char *)aView->style, (char *)menuitem->Label());
		font.SetFamilyAndStyle(aView->family, aView->style);
		aView->SetFont(&font);
		menuitem->SetMarked(true);
		menuitem->Menu()->Superitem()->SetMarked(true);
		Hide();
		aView->Invalidate();
		Show();
		break;
	case X_HOLIDAYS:
		message->FindPointer("source", &menuitem);
		if (aView->showHolidays) {
			aView->showHolidays = false;
			menuitem->SetMarked(false);
		} else {
			aView->showHolidays = true;
			menuitem->SetMarked(true);
		}
		Hide();
		aView->Invalidate();
		Show();
		break;

	default:
		be_app->MessageReceived( message );
		break;
	}
}


//====================================================
// CalendarWindow Constructor
//====================================================

CalendarWindow::CalendarWindow( BRect frame, int32 m, int32 y )
    : BWindow( frame, "CalendarJ", B_TITLED_WINDOW, 0 ),
      month( m ),
      year( y )
{
    BRect   aRect = frame;

    SetupMenus();

    aRect.bottom -= 20;
    aRect.OffsetTo( 0., 20. );
    aView = new BTSMonthViewJ( aRect, "MonthViewJ" , month, year);
    
    Lock();
    AddChild( aView );
    
    BDragger *dragger;
    BRect	dframe;
    
    dframe = aView->Bounds();
    dframe.top = dframe.bottom - 7;
    dframe.right = dframe.left + 7;
    
    dragger = new BDragger(dframe, aView, 
    	B_FOLLOW_BOTTOM|B_FOLLOW_LEFT);
    aView->AddChild(dragger);
    
    Unlock();

    Show();
}

