//*********************************************************
//	CalendarMMYY.cpp
//	Last Update: 981008
//*********************************************************
#include 	"CalendarWindow.h"
#include 	"MonthView.h"
#include	"CalendarMMYY.h"
#include	<string.h>

MMYYWindow::MMYYWindow(BRect frame )
	:BWindow(frame, "MMYY", B_BORDERED_WINDOW,
		B_NOT_RESIZABLE|B_NOT_ZOOMABLE|B_NOT_CLOSABLE)

{
	mmyyView = new  MMYYView( Bounds() );
	AddChild( mmyyView );
	be_app->SetCursor( B_HAND_CURSOR );
}

bool
MMYYWindow::QuitRequested()
{
	return true;
}

/*void								//981008
MMYYWindow::WindowActivated(bool state)
{
        //
        if(state){
                Lock();
                mmyyView->yyView->SelectAll();
                Unlock();
        }
        //
}
*/   
void
MMYYWindow::SetMMYY()
{
	mmyyView->yyView->GetText( 0, 20, yyString );
	mmyyView->mmView->GetText( 0, 20, mmString );
	aWin->Lock();
	aWin->Hide();
	if (yyString[0])
		aView->year = atoi( yyString );
	if (mmString[0])
		aView->month = atoi( mmString );
	aView->Invalidate();
	aWin->Unlock();
	aWin->Show();
}

void
MMYYWindow::SetTargetWindow( CalendarWindow *w )
{
	aWin = w;
	aView = aWin->aView;
	sprintf( yyString, "%ld", aView->year );
	sprintf( mmString, "%ld", aView->month );
	Lock();
	mmyyView->yyView->SetText( yyString, strlen(yyString) );
	mmyyView->mmView->SetText( mmString, strlen(mmString) );
	Unlock();
}

void
MMYYWindow::MessageReceived( BMessage *msg )
{
	
	switch ( msg->what )
	{
		case OK_BUTTON_PRESSED:
			SetMMYY();
			
		case CANCEL_BUTTON_PRESSED:
			Hide();
			break;
			
		default:
			BWindow::MessageReceived( msg );
	}
}

MMYYView::MMYYView(BRect  frame )
	: BView( frame, "年月の変更", B_FOLLOW_ALL, B_WILL_DRAW)
{
	BRect	viewRect =  Bounds();
	//int32	i;									//981008
	
	////////////////////
	//  Add Buttons
	////////////////////
	
	//"OK" button
	BButton*	button;
	BRect	buttonFrame(0, 0, 65, 25 );
	buttonFrame.OffsetBy( viewRect.Width() - 80, viewRect.Height()- 35 );
	button = new  BButton( buttonFrame, "okbutton", "設定", 
		new BMessage( OK_BUTTON_PRESSED));
	AddChild( button );
	button->MakeDefault( true );
	button->SetFont( be_bold_font, B_FONT_ALL);
	
	//"cancel" button
	buttonFrame.OffsetBy( -80, 0 );
	button = new BButton( buttonFrame, "cancelbutton", "取消",
		new  BMessage( CANCEL_BUTTON_PRESSED));
	AddChild( button );
	button->SetFont( be_bold_font, B_FONT_ALL );
	
	////////////////////
	//   Add String View
	////////////////////
	BStringView*	stringview;
	BRect	stringFrame( 0, 0, 50, 20 );
	BPoint	point( 10, 40 );	// FontMenu's LeftTop point
	
	stringFrame.OffsetBy( 60, 10 );
	stringview = new BStringView( stringFrame, "stringview", "年" );
	AddChild( stringview );
	stringview->SetFont( be_bold_font, B_FONT_ALL );
	
	stringFrame.OffsetBy( 80, 0 );
	stringFrame.right -= 20;
	stringview = new BStringView( stringFrame, "stringview", "月" );
	AddChild( stringview );
	stringview->SetFont( be_bold_font, B_FONT_ALL );
	
	////////////////////
	//   Add TextView
	////////////////////
	BBox*		bbox;
	BRect		boxFrame( 0, 0, 50, 20 );
	BRect		textFrame;
	
	textFrame = boxFrame;
	textFrame.OffsetTo( B_ORIGIN );
	boxFrame.OffsetBy( 10, 10 );
	
	textFrame.top++;
	textFrame.left++;
	textFrame.bottom -= 2;
	textFrame.right -= 2;
	
	bbox =  new BBox( boxFrame, "bbox" );
	
	yyView  =  new MMYYTextView(  textFrame, "yyview", textFrame,
						B_FOLLOW_ALL, B_WILL_DRAW );
	bbox->AddChild( yyView );
	AddChild( bbox );
	
	boxFrame.right -= 25;
	textFrame.right -= 25;
	boxFrame.OffsetBy( 100, 0 );
	
	bbox = new BBox( boxFrame, "bbox" );
	
	mmView = new MMYYTextView( textFrame, "mmview", textFrame,
						B_FOLLOW_ALL, B_WILL_DRAW );
	bbox->AddChild( mmView );
	AddChild( bbox );
	
	yyView->SetNextView( mmView );
	mmView->SetNextView( yyView );
}

void
MMYYView::AttachedToWindow()
{
	rgb_color	color = { 240, 240, 240 };
	SetViewColor( color );
}

MMYYTextView::MMYYTextView(BRect frame, const char *name,
	BRect textRect, uint32 resizeMask, uint32 flags )
	: BTextView( frame, name, textRect, resizeMask, flags )
{
	nextView = NULL;
}

void
MMYYTextView::KeyDown( const char *bytes, int32 numBytes )
{
	key_info	keyinfo;
	get_key_info( &keyinfo );
	
	if (numBytes == 1 && *bytes == B_TAB && IsFocus() ) {
		if ((keyinfo.modifiers &  B_SHIFT_KEY) == 0 && nextView ) {
				nextView->MakeFocus( true );
				nextView->SelectAll();
		} 
	}else
			BTextView::KeyDown( bytes,  numBytes );
}
	
	
	