//*************************************************************	
//    CalendarApp.cpp 
//    Last Update 981008  
//*************************************************************

#include "CalendarApp.h"

/////////////////////////////////////////////////////////
// CalendarApplication::NewWindow()
//
//
void CalendarApplication::NewWindow()
{
    fCountWindow++;
    BRect			frame;
    CalendarWindow *aWindow;
    int				incr = fCountWindow*20;

    frame.Set( 100+incr, 20+incr, 300+incr, 200+incr );
    aWindow = new CalendarWindow( frame, month, year );
    aWindow->Show();
} 

////////////////////////////////////////////////////////////
//   CalendarApplication:: CloseWindow()
//
//
void CalendarApplication::CloseWindow()
{
	if ( --fCountWindow == 0)
		QuitRequested();
	return;
}

/////////////////////////////////////////////////////////
//    CalendarApplication::  QuitRequested()
//
//
bool CalendarApplication::QuitRequested()
{
	be_app->PostMessage(B_QUIT_REQUESTED);
	return  TRUE ;
}

/////////////////////////////////////////////////////////////
// CalendarApp MessageReceived
//
//
void CalendarApplication::MessageReceived(BMessage *message)
{
	BWindow*	window;
	BRect		screenRect;
	BScreen*	screen;
	
	switch (message->what) {
	case  X_NEW:
		NewWindow();
		break;
	case X_MMYY:
		message->FindPointer( "window", &window );
		BRect frame = window->Frame();
		//mmyyWindow->Hide();
		mmyyWindow->MoveTo(frame.left, frame.top + 40.);
		//if  (mmyyWindow->IsHidden())
		mmyyWindow->Show();
		mmyyWindow->SetTargetWindow((CalendarWindow *)window);
		mmyyWindow->Activate();
		break;
	case X_CREATE_MMYY_WINDOW:
		screen = new BScreen( B_MAIN_SCREEN_ID );
		screenRect = screen->Frame();
		delete screen;
	
		BRect	mmyyFrame( 0, 0, 175, 75 );
	
		mmyyFrame.OffsetBy(0.5  * (screenRect.Width() - mmyyFrame.Width()),
			0.5 * (screenRect.Height() - mmyyFrame.Height() - 50.0));;
		mmyyWindow = new  MMYYWindow(mmyyFrame );
		break;
	case B_ABOUT_REQUESTED:
		AboutRequested();
		break;
	case X_WCLS:
		CloseWindow();
		break;
	default:
		BApplication::MessageReceived(message);
	}
	return;
}

/////////////////////////////////////////////////////////////
// AboutRequested
//
//
void CalendarApplication::AboutRequested()
{
	const char msg[] =
			"CalendarJ\n"
            "Version 1.8 for BeOS R3\n\n"
			"By T.Yamagata (yamagata@sie.co.jp)\n"
			"S I Electronics Ltd., Tokyo, Japan\n\n"
			"Modified from ftp.be.com/pub/Samples/January";

	BAlert * alert = new BAlert(NULL, msg, "OK");
	alert->Go();
}

/////////////////////////////////////////////////////////////////////
// CalendarApplication constructer
//
//
const char *app_signature = "application/x-vnd.SIE-CalendarJ1.8";

CalendarApplication::CalendarApplication(int32 m, int32 y)
		: BApplication(app_signature),
		  month( m ),
		  year( y )
{
    fCountWindow = 0;
    NewWindow();
    PostMessage(X_CREATE_MMYY_WINDOW);
}
