//*************************************************************	
//  CalendarWindow.cpp    
//	Last Update 980108/14:30
//*************************************************************

#include	"CalendarWindow.h"
#include	"MonthView.h"
#include	"CalendarMMYY.h"

///////////////////////////////////////////////////////////////
// Menus
//
//
XMenuItem xFileMenu[] = {
    {   "About Calendar",   	B_ABOUT_REQUESTED,  0 },
    { 	"Change Year,Month",	X_MMYY,				0 },
    {   "New",              	X_NEW,              0 },
    {	"Show Japanese Holidays", X_HOLIDAYS,		0 },
    {   "Close",           		X_CLS,              0 },
    {   NULL,               	0,  				0 }
};

XMenuItem xMonthMenu[] = {
	{	"January",		X_JAN,  0},
	{	"Feburary",		X_FEB,	0},
	{	"March",		X_MAR,	0},
	{	"April",		X_APR,	0},
	{	"May",			X_MAY,	0},
	{	"June",			X_JUN,	0},
	{	"July",			X_JUL,	0},
	{	"August",		X_AUG,	0},
	{	"September",	X_SEP,	0},
	{	"October",		X_OCT,	0},
	{	"November",		X_NOV,	0},
	{	"December",		X_DEC,	0},
    {   NULL,           0,  	0}
};

XMenuItem xYearMenu[] = {
	{	"Next",		X_NEXT,	0},
	{	"Prev",		X_PREV, 0},
    {   NULL,       0,		0}
};

///////////////////////////////////////////////////////////
//   ReadMenu()
//
//
void
ReadMenu(
    const XMenuItem *items, BMenu *menu, BWindow *win )
{
    while (items->title) {
        if (items->title[0]) {
        	BMessage *msg = new BMessage(items->command);
        	if ( items->command == X_MMYY )
        		msg->AddPointer( "window", win );
            BMenuItem *item = new BMenuItem(items->title, msg, items->key);
            if ( items->command == X_MMYY )
				item->SetTarget( be_app );
            menu->AddItem(item);
        } else {
                menu->AddSeparatorItem();
        }
        items++;
    }
};

/////////////////////////////////////////////////////////
// SetupMenus
//
//
void CalendarWindow::SetupMenus()
{
    BMenu		*aMenu;
    BMenuBar	*menuBar;
    BWindow		*win =  (BWindow*) this;

    BRect dummyRect( 0, 0, 10, 10 );
    menuBar = new BMenuBar( dummyRect, "menubar" );

    aMenu = new BMenu( "File" );
    ReadMenu( xFileMenu, aMenu, win );
    menuBar->AddItem( aMenu );
    aMenu = new BMenu( "Month" );
    ReadMenu( xMonthMenu, aMenu, win );
    menuBar->AddItem( aMenu );
    aMenu = new BMenu( "Year" );
    ReadMenu( xYearMenu, aMenu, win );
    menuBar->AddItem( aMenu );
	//"Font Menu"
	aMenu = new BMenu("Font");
		int32	fontNum = count_font_families();
		int32	styleNum;
		int32	i;
		int32	ii;
		font_family	fFamily;
		font_style	fStyle;
		BMenu*	styleMenu;
		BMenuItem*	styleItem;
			
		for(i=0; i<fontNum; i++){
			get_font_family(i,&fFamily);
			styleMenu = new BMenu(fFamily);
			styleNum = count_font_styles(fFamily);
			for(ii=0; ii<styleNum; ii++){
				get_font_style(fFamily,ii,&fStyle);
				styleItem = new BMenuItem(fStyle,new BMessage(X_STYLE));
				styleMenu->AddItem(styleItem);
				styleItem->SetTarget(NULL,this);
			}
			aMenu->AddItem(styleMenu);
		}
	menuBar->AddItem(aMenu);
    AddChild( menuBar );
}

/////////////////////////////////////////////////////////////////////
// CalendarWindow QuitRequested
//
//
bool CalendarWindow::QuitRequested( void )
{
	return BWindow::QuitRequested();
}

/////////////////////////////////////////////////////////////////////
// CalendarWindow Quit
//
//
void CalendarWindow::Quit( void )
{
	be_app->PostMessage( X_WCLS );
	BWindow::Quit();
	
	return;
} 


/////////////////////////////////////////////////////////////////////
// CalendarWindow MessageReceived
//
//
void CalendarWindow::MessageReceived( BMessage *message )
{
	switch (message->what) {
	case X_NEXT:
        Hide();
		aView->year++;
        aView->Invalidate();
        Show(); 
		break;
	case X_PREV:
        Hide();
		aView->year--;
        aView->Invalidate();
        Show(); 
		break;
	case X_JAN:
        Hide();
		aView->month=1;
        aView->Invalidate();
        Show(); 
		break;
	case X_FEB:
        Hide();
		aView->month=2;
        aView->Invalidate();
        Show(); 
		break;
	case X_MAR:
        Hide();
		aView->month=3;
        aView->Invalidate();
        Show(); 
		break;
	case X_APR:
        Hide();
		aView->month=4;
        aView->Invalidate();
        Show(); 
		break;
	case X_MAY:
        Hide();
		aView->month=5;
        aView->Invalidate();
        Show(); 
		break;
	case X_JUN:
        Hide();
		aView->month=6;
        aView->Invalidate();
        Show(); 
		break;
	case X_JUL:
        Hide();
		aView->month=7;
        aView->Invalidate();
        Show(); 
		break;
	case X_AUG:
        Hide();
		aView->month=8;
        aView->Invalidate();
        Show(); 
		break;
	case X_SEP:
        Hide();
		aView->month=9;
        aView->Invalidate();
        Show(); 
		break;
	case X_OCT:
        Hide();
		aView->month=10;
        aView->Invalidate();
        Show(); 
		break;
	case X_NOV:
        Hide();
		aView->month=11;
        aView->Invalidate();
        Show(); 
		break;
	case X_DEC:
        Hide();
		aView->month=12;
        aView->Invalidate();
        Show(); 
		break;
	case X_CLS:
		Quit();
		break;
	case X_STYLE:
		BMenuItem* menuitem;
		message->FindPointer("source", &menuitem);
		BMenu *aMenu = menuitem->Menu()->Supermenu();
		for (int i =0; i < aMenu->CountItems(); i++) {
			BMenuItem *item = aMenu->ItemAt(i);
			item->SetMarked(false);
			BMenu *submenu = item->Submenu();
			if (submenu) {
				for (int ii= 0; ii < submenu->CountItems(); ii++)
					submenu->ItemAt(ii)->SetMarked(false);
			}
		}

		BFont font;
		aView->GetFont(&font);
		font.SetFamilyAndStyle(
			(char *)menuitem->Menu()->Superitem()->Label(),
			(char *)menuitem->Label());
		aView->SetFont(&font);
		menuitem->SetMarked(true);
		menuitem->Menu()->Superitem()->SetMarked(true);
		Hide();
		aView->Invalidate();
		Show();
		break;
	case X_HOLIDAYS:
		message->FindPointer("source", &menuitem);
		if (aView->showHolidays) {
			aView->showHolidays = false;
			menuitem->SetMarked(false);
		} else {
			aView->showHolidays = true;
			menuitem->SetMarked(true);
		}
		Hide();
		aView->Invalidate();
		Show();
		break;
	default:
		be_app->MessageReceived( message );
		break;
	}
}


//====================================================
// CalendarWindow Constructor
//====================================================

CalendarWindow::CalendarWindow( BRect frame, int32 m, int32 y )
    : BWindow( frame, "Calendar", B_TITLED_WINDOW, 0 ),
      month( m ),
      year( y )
{
    BRect   aRect = frame;

    SetupMenus();

    aRect.bottom -= 20;
    aRect.OffsetTo( 0., 20. );
    aView = new BTSMonthView( aRect, "MonthView" , month, year);
    
    Lock();
    AddChild( aView );
    
    BDragger *dragger;
    BRect	dframe;
    
    dframe = aView->Bounds();
    dframe.top = dframe.bottom - 7;
    dframe.right = dframe.left + 7;
    
    dragger = new BDragger(dframe, aView, 
    	B_FOLLOW_BOTTOM|B_FOLLOW_LEFT);
    aView->AddChild(dragger);
    
    Unlock();

    Show();
}

