/*--------------------------------------------------------*/
/*
 File:	AtoZ.cpp

 Client App - learning and running
 © Christophe Morvant - QuBernan Project

 AtoZ recognizes alphabetic caracters. Each caracter is coded
 in 5x5 board.

*/
/*--------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include<iostream.h>

#ifndef ATOZ_H
#include "AtoZ.h"
#endif
#ifndef _LIST_H
#include <List.h>
#endif
#ifndef _APPLICATION_H
#include <Application.h>
#endif
#ifndef _MESSENGER_H
#include <Messenger.h>
#endif
/*--------------------------------------------------------*/
enum {


	LESSON			= 'less', // What BMessage for learning process
	THINKNOW		= 'thin', // What BMessage for running process
	LEARN_RESULT    = 'leok', // What BMessage [received] sent by server when learning process is OK
	BRAINBOX_ERR	= 'boko', // What BMessage [received] Errors occured in server
	THINK_RESULT	= 'thok', // What BMessage [received] sent by server when running process is OK
	RESULTAT        = 'rslt'  // What BMessage : reply
};


/*--------------------------------------------------------*/




main(int argc, char* argv[])

{


	ClientrunApp* Application = new ClientrunApp();

	Application->Run();


	delete Application;
	return 0;
}


/*--------------------------------------------------------*/


ClientrunApp::ClientrunApp()
	: BApplication("application/x-vnd.Braininabox-ClientAtoZ")
{
}

void ClientrunApp::MessageReceived(BMessage *mess)

{



	char *Texte;
	switch (mess->what){
		case LEARN_RESULT: // This BMessage is sent by the server only if the client always running.
						   // By this way, client app knows when the learning process is finished
			mess->FindString("LearningResult", &Texte);
			cout << endl << "[LearningResult] = " << Texte << endl;
			break;
		case BRAINBOX_ERR: // This BMessage is sent by the server when an error occured in learning
						   // or running process (if, for example, signature_app BMessage is missing)
			mess->FindString("BraininboxErr", &Texte);
			cout << endl << "[Error] = " << Texte << endl;
			break;
		case THINK_RESULT: // This BMessage is sent by the server when running (thinking) process
						   // is finished.
			double in_value;
			double out_value;
			int32 input_neurons;
			int32 output_neurons;
			int32 count_found_for_in;

			mess->FindInt32("Number_Scheme", &count_found_for_in); // Server returns number of scheme to evaluate
			cout << endl << "[RESULT OF THINKING PROCESS]" << endl;
						
			mess->FindInt32("Input_Neurons", &input_neurons); // Number of input neurons
			mess->FindInt32("Output_Neurons", &output_neurons); // Number of output neurons

			int32 index_in = 0;  // Index BMessage
			int32 index_out = 0;

			for (int32 i = 0; i < count_found_for_in; i++) // Until read all results per scheme
			{

			
				cout << "Scheme #" << i+1 << endl;
				for (int32 j = 0; j < input_neurons; j++) // Until read all input values
				{

					mess->FindDouble("YouSend", index_in, &in_value); // Server returns the Scheme to evaluate
					cout << in_value;
					index_in++;
					if (j == 4 || j == 14 ||  j == 24 || j == 9
						|| j == 19)
						cout << endl;
				}
								
				cout << endl << "I think : " << endl;
				for (int32 j = 0; j < output_neurons; j++)
				{
					mess->FindDouble("IThink", index_out, &out_value); // .. And its result found during running process
					if (out_value > 0.9) // this test depends on values produce by the network.
										 // with others learning parameters the test value (0.9)
										 // could be changed.
					{
						out_value = 1;
					}
					else
					{
						out_value = 0;
					}
					cout << out_value;
					
					if (j == 4 || j == 14 ||  j == 24 || j == 9
						|| j == 19)
						cout << endl;
					index_out++;
				
				
				}
					
				cout << endl;
			}
			break;
		default:
			BApplication::MessageReceived(mess);
			break;
			
	}

}

void ClientrunApp::ReadyToRun( )
{
	BMessage reply;
	char *Texte;

/*---------------- Thinking Part -----------------------------
	double input_values[25]; // Array of input neurons : 5x5


	BMessenger message = BMessenger("application/x-vnd.QuBernan_Braininabox", -1); // Connect with the Server
	BMessage msg(THINKNOW); // THINKNOW for running process

	
	msg.AddString("signature_app", "application/x-vnd.Braininabox-ClientAtoZ");
	msg.AddInt32("generation", 0); // 0 if you want the last paramters file created by the learning process
								   // This item is optional. By default the server sets to 0 the
								   // file's generation
// First scheme to evaluate
		// A
	input_values[0] = 1.0; 
	input_values[1] = 1.0;
	input_values[2] = 1.0; 
	input_values[3] = 1.0;
	input_values[4] = 1.0; 
	input_values[5] = 1.0;
	input_values[6] = 0.0; 
	input_values[7] = 0.0;
	input_values[8] = 0.0; 
	input_values[9] = 1.0;
	input_values[10] = 1.0; 
	input_values[11] = 1.0;
	input_values[12] = 1.0; 
	input_values[13] = 1.0;
	input_values[14] = 1.0; 
	input_values[15] = 1.0;
	input_values[16] = 0.0; 
	input_values[17] = 0.0;
	input_values[18] = 0.0; 
	input_values[19] = 1.0;
	input_values[20] = 1.0; 
	input_values[21] = 0.0;
	input_values[22] = 0.0; 
	input_values[23] = 0.0;
	input_values[24] = 1.0; 
	msg.AddData("input_values", B_DOUBLE_TYPE, &input_values, sizeof(input_values)); // send the array of input values

			// C
			
	input_values[0] = 1.0; 
	input_values[1] = 1.0;
	input_values[2] = 1.0; 
	input_values[3] = 1.0;
	input_values[4] = 1.0; 
	input_values[5] = 1.0;
	input_values[6] = 0.0; 
	input_values[7] = 0.0;
	input_values[8] = 0.0; 
	input_values[9] = 0.0;
	input_values[10] = 1.0; 
	input_values[11] = 0.0;
	input_values[12] = 0.0; 
	input_values[13] = 0.0;
	input_values[14] = 0.0; 
	input_values[15] = 1.0;
	input_values[16] = 0.0; 
	input_values[17] = 0.0;
	input_values[18] = 0.0; 
	input_values[19] = 0.0;
	input_values[20] = 1.0; 
	input_values[21] = 1.0;
	input_values[22] = 1.0; 
	input_values[23] = 1.0;
	input_values[24] = 1.0; 
	msg.AddData("input_values", B_DOUBLE_TYPE, &input_values, sizeof(input_values)); // send the array of input values

/*---------------end of Thinking Part --------------------------*/

//****************
// Learning Part *
//****************


	double input_values[25]; // Array of input neurons : 5 x 5
	double output_values[25]; // Array of output neurons : 5 x 5 
	BMessenger message = BMessenger("application/x-vnd.QuBernan_Braininabox", -1); // Connect to the server
	BMessage msg(LESSON); // BMessage for learning process

	msg.AddDouble("learning_rate", 0.2); // Learning_rate. You cand modify this value. Positive value
										  // and under 1. Learning rate is used to compute error
										  // between found ouput and desired output
										  
	msg.AddDouble("momentum_term", 0.8);  // momentum_term adds some noise fighting local minima.
										  // You can modify this value (between 0 and 1).
	
	msg.AddDouble("tolerance", 0.01);	  // tolerance stops the learning process the computed error
										  // is less than this parameter. You can modify this value.
										  // (between 0 and 1).
	
	msg.AddString("signature_app", "application/x-vnd.Braininabox-ClientAtoZ");
// Gives the number of neurons in each layer
	msg.AddInt32("neurons_in_layer", 25); // First item = number of neurons of INPUT layer
	msg.AddInt32("neurons_in_layer", 12); // middle item = number of neurons of MIDDLE (hidden) layer
										 // You can increase the number of hidden layer adding a new
										 // neurons_in_layer item
	msg.AddInt32("neurons_in_layer", 25); // Last item = number of neuron of OUTPUT layer

// Schemes to evaluate. Each input_values message is a scheme for the input neurons
// A is coding on 5x5 board as: 
// 11111
// 1   1
// 11111
// 1   1
// 1   1 
							// Fist scheme : A
	input_values[0] = 1.0; 
	input_values[1] = 1.0;
	input_values[2] = 1.0; 
	input_values[3] = 1.0;
	input_values[4] = 1.0; 
	input_values[5] = 1.0;
	input_values[6] = 0.0; 
	input_values[7] = 0.0;
	input_values[8] = 0.0; 
	input_values[9] = 1.0;
	input_values[10] = 1.0; 
	input_values[11] = 1.0;
	input_values[12] = 1.0; 
	input_values[13] = 1.0;
	input_values[14] = 1.0; 
	input_values[15] = 1.0;
	input_values[16] = 0.0; 
	input_values[17] = 0.0;
	input_values[18] = 0.0; 
	input_values[19] = 1.0;
	input_values[20] = 1.0; 
	input_values[21] = 0.0;
	input_values[22] = 0.0; 
	input_values[23] = 0.0;
	input_values[24] = 1.0; 

	msg.AddData("input_values", B_DOUBLE_TYPE, &input_values, sizeof(input_values));


// Desired output respectively linked to each input scheme
							// First ouput : A = same as input

	msg.AddData("output_values", B_DOUBLE_TYPE, &input_values, sizeof(input_values));


// 1111 
// 1   1
// 1111 
// 1   1
// 1111     
							// Second scheme : B
	input_values[0] = 1.0; 
	input_values[1] = 1.0;
	input_values[2] = 1.0; 
	input_values[3] = 1.0;
	input_values[4] = 0.0; 
	input_values[5] = 1.0;
	input_values[6] = 0.0; 
	input_values[7] = 0.0;
	input_values[8] = 0.0; 
	input_values[9] = 1.0;
	input_values[10] = 1.0; 
	input_values[11] = 1.0;
	input_values[12] = 1.0; 
	input_values[13] = 1.0;
	input_values[14] = 0.0; 
	input_values[15] = 1.0;
	input_values[16] = 0.0; 
	input_values[17] = 0.0;
	input_values[18] = 0.0; 
	input_values[19] = 1.0;
	input_values[20] = 1.0; 
	input_values[21] = 1.0;
	input_values[22] = 1.0; 
	input_values[23] = 1.0;
	input_values[24] = 0.0; 

	msg.AddData("input_values", B_DOUBLE_TYPE, &input_values, sizeof(input_values));


// Desired output respectively linked to each input scheme
							// First ouput : B = same as input

	msg.AddData("output_values", B_DOUBLE_TYPE, &input_values, sizeof(input_values));

// 11111
// 1    
// 1  
// 1 
// 11111     
							// Third scheme : C
	input_values[0] = 1.0; 
	input_values[1] = 1.0;
	input_values[2] = 1.0; 
	input_values[3] = 1.0;
	input_values[4] = 1.0; 
	input_values[5] = 1.0;
	input_values[6] = 0.0; 
	input_values[7] = 0.0;
	input_values[8] = 0.0; 
	input_values[9] = 0.0;
	input_values[10] = 1.0; 
	input_values[11] = 0.0;
	input_values[12] = 0.0; 
	input_values[13] = 0.0;
	input_values[14] = 0.0; 
	input_values[15] = 1.0;
	input_values[16] = 0.0; 
	input_values[17] = 0.0;
	input_values[18] = 0.0; 
	input_values[19] = 0.0;
	input_values[20] = 1.0; 
	input_values[21] = 1.0;
	input_values[22] = 1.0; 
	input_values[23] = 1.0;
	input_values[24] = 1.0; 

	msg.AddData("input_values", B_DOUBLE_TYPE, &input_values, sizeof(input_values));


// Desired output respectively linked to each input scheme
							// Third ouput : C
	msg.AddData("output_values", B_DOUBLE_TYPE, &input_values, sizeof(input_values));

// 1111
// 1   1    
// 1   1  
// 1   1 
// 1111     
							// Fourth scheme : D
	input_values[0] = 1.0; 
	input_values[1] = 1.0;
	input_values[2] = 1.0; 
	input_values[3] = 1.0;
	input_values[4] = 0.0; 
	input_values[5] = 1.0;
	input_values[6] = 0.0; 
	input_values[7] = 0.0;
	input_values[8] = 0.0; 
	input_values[9] = 1.0;
	input_values[10] = 1.0; 
	input_values[11] = 0.0;
	input_values[12] = 0.0; 
	input_values[13] = 0.0;
	input_values[14] = 1.0; 
	input_values[15] = 1.0;
	input_values[16] = 0.0; 
	input_values[17] = 0.0;
	input_values[18] = 0.0; 
	input_values[19] = 1.0;
	input_values[20] = 1.0; 
	input_values[21] = 1.0;
	input_values[22] = 1.0; 
	input_values[23] = 1.0;
	input_values[24] = 0.0; 

	msg.AddData("input_values", B_DOUBLE_TYPE, &input_values, sizeof(input_values));


// Desired output respectively linked to each input scheme
							// Fourth ouput : D
	msg.AddData("output_values", B_DOUBLE_TYPE, &input_values, sizeof(input_values));

// 11111
// 1       
// 111  
// 1 
// 11111     
							// Fifth scheme : E
	input_values[0] = 1.0; 
	input_values[1] = 1.0;
	input_values[2] = 1.0; 
	input_values[3] = 1.0;
	input_values[4] = 1.0; 
	input_values[5] = 1.0;
	input_values[6] = 0.0; 
	input_values[7] = 0.0;
	input_values[8] = 0.0; 
	input_values[9] = 0.0;
	input_values[10] = 1.0; 
	input_values[11] = 1.0;
	input_values[12] = 1.0; 
	input_values[13] = 0.0;
	input_values[14] = 0.0; 
	input_values[15] = 1.0;
	input_values[16] = 0.0; 
	input_values[17] = 0.0;
	input_values[18] = 0.0; 
	input_values[19] = 0.0;
	input_values[20] = 1.0; 
	input_values[21] = 1.0;
	input_values[22] = 1.0; 
	input_values[23] = 1.0;
	input_values[24] = 1.0; 

	msg.AddData("input_values", B_DOUBLE_TYPE, &input_values, sizeof(input_values));


// Desired output respectively linked to each input scheme
							// Fifth ouput : E
	msg.AddData("output_values", B_DOUBLE_TYPE, &input_values, sizeof(input_values));

	msg.PrintToStream();

// And so on until Z...

//*********************
// End Learning Part  *
//*********************
	
/*----------- Common Code --------------------------------*/
	message.SendMessage(&msg, &reply);
	if (reply.FindString("GetIt", &Texte) != B_OK)
	{
		cout << endl << "[ERROR] Invalid reply " << endl;
	}
	else
	{
		cout << endl << "[GetIt] = " << Texte << endl;
	}

}
