#include <stdio.h>
#include <stdlib.h>
#include <math.h>

int 	xcount, ycount, zcount;

void	print_usage( char *name );

void	print_connection(	char *prefix, char *tmplate,
							int x1, int y1, int z1,
							int x2, int y2, int z2 );

void	print_variable_and_vertex(	char *prefix, FILE *vertices, char *id,
									int x1, int y1, int z1,
									int x2, int y2, int z2,
									int xind, int yind );

void	print_variable_and_vertex_edge(	char *prefix, FILE *vertices, char *id,
										int x1, int y1, int z1,
										int x2, int y2, int z2,
										int ind );

void	print_variable_and_vertex_corner(	char *prefix, FILE *vertices, char *id,
											int x1, int y1, int z1,
											int x2, int y2, int z2 );

void	print_triangle_face(	char *prefix, char *id,
								int x1, int y1, int x2,
								int y2, int x3, int y3 );

void	print_triangle_edge_211(	char *prefix, char *id1, char *id2,
									int x1, int y1, int x2, int x3 );

void	print_triangle_edge_212(	char *prefix, char *id1, char *id2,
									int x1, int y1, int x2,
									int x3, int y3 );

void	print_triangle_edge_221(	char *prefix, char *id1, char *id2,
									int x1, int y1, int x2,
									int y2, int x3 );

void	print_usage( char *name )
{
	fprintf(stderr, "usage:\n%s <xcount> <ycount> <zcount> <prefix>\n", name );
	fprintf(stderr, "note:\tYou will probably want to edit the templates and\n" );
	fprintf(stderr, "\tdefinitions after you have created a new block.\n" );
}

void	print_connection(	char *prefix, char *tmplate,
							int x1, int y1, int z1,
							int x2, int y2, int z2 )
{
	printf("connection\n");
	printf("{\n");
	printf("\ttemplate\t{ \"%s_%s\" }\n", prefix, tmplate);
	printf(	"\tconnect\t\t{ \"%s %d_%d_%d\", \"%s %d_%d_%d\" }\n",
			prefix, x1, y1, z1, prefix, x2, y2, z2 );
	printf(	"\tname\t\t{ \"%s %d_%d_%d->%d_%d_%d\" }\n",
			prefix, x1, y1, z1, x2, y2, z2 );
	printf("}\n");
	printf("\n");
}

void	print_variable_and_vertex(	char *prefix, FILE *vertices, char *id,
									int x1, int y1, int z1,
									int x2, int y2, int z2,
									int xind, int yind )
{
	printf("\tvariable vector\n");
	printf("\t{\n");
	printf("\t\tfunction\n\t\t{\n\t\t\t((object{\"%s %d_%d_%d\"}.position - object{\"%s %d_%d_%d\"}.position) +\n\t\t\t", prefix, x1, y1, z1, prefix, x2, y2, z2);
	printf("(template object{\"%s\"}.radius)) + object{\"%s %d_%d_%d\"}.position\n\t\t}\n", prefix, prefix, x2, y2, z2 );
	printf("\t\tname\t\t{ \"%s %s %d_%d\" }\n", prefix, id, xind, yind );
	printf("\t}\n");
	printf("\n");

	fprintf( vertices, "\tvertex\n" );
	fprintf( vertices, "\t{\n" );
	fprintf( vertices, "\t\tmount\t\t{ variable vector{\"%s %s %d_%d\"} }\n", prefix, id, xind, yind );
	fprintf( vertices, "\t\tname\t\t{ \"%s vx %s %d_%d\" }\n", prefix, id, xind, yind );
	fprintf( vertices, "\t}\n" );
	fprintf( vertices, "\n" );
}


void	print_variable_and_vertex_edge(	char *prefix, FILE *vertices, char *id,
										int x1, int y1, int z1,
										int x2, int y2, int z2,
										int ind )
{
	printf("\tvariable vector\n");
	printf("\t{\n");
	printf("\t\tfunction\n\t\t{\n\t\t\t((object{\"%s %d_%d_%d\"}.position - object{\"%s %d_%d_%d\"}.position) +\n\t\t\t", prefix, x1, y1, z1, prefix, x2, y2, z2);
	printf("(template object{\"%s\"}.radius)) + object{\"%s %d_%d_%d\"}.position\n\t\t}\n", prefix, prefix, x2, y2, z2 );
	printf("\t\tname\t\t{ \"%s %s %d\" }\n", prefix, id, ind );
	printf("\t}\n");
	printf("\n");

	fprintf( vertices, "\tvertex\n" );
	fprintf( vertices, "\t{\n" );
	fprintf( vertices, "\t\tmount\t\t{ variable vector{\"%s %s %d\"} }\n", prefix, id, ind );
	fprintf( vertices, "\t\tname\t\t{ \"%s vx %s %d\" }\n", prefix, id, ind );
	fprintf( vertices, "\t}\n" );
	fprintf( vertices, "\n" );
}

void	print_variable_and_vertex_corner(	char *prefix, FILE *vertices, char *id,
											int x1, int y1, int z1,
											int x2, int y2, int z2 )
{
	printf("\tvariable vector\n");
	printf("\t{\n");
	printf("\t\tfunction\n\t\t{\n\t\t\t((object{\"%s %d_%d_%d\"}.position - object{\"%s %d_%d_%d\"}.position) +\n\t\t\t", prefix, x1, y1, z1, prefix, x2, y2, z2);
	printf("(template object{\"%s\"}.radius)) + object{\"%s %d_%d_%d\"}.position\n\t\t}\n", prefix, prefix, x2, y2, z2 );
	printf("\t\tname\t\t{ \"%s %s\" }\n", prefix, id );
	printf("\t}\n");
	printf("\n");

	fprintf( vertices, "\tvertex\n" );
	fprintf( vertices, "\t{\n" );
	fprintf( vertices, "\t\tmount\t\t{ variable vector{\"%s %s\"} }\n", prefix, id );
	fprintf( vertices, "\t\tname\t\t{ \"%s vx %s\" }\n", prefix, id );
	fprintf( vertices, "\t}\n" );
	fprintf( vertices, "\n" );
}

void	print_triangle_face(	char *prefix, char *id,
								int x1, int y1, int x2,
								int y2, int x3, int y3 )
{
	printf("\ttriangle\n");
	printf("\t{\n");
	printf("\t\ttemplate\t{ \"%s triangle\" }\n", prefix);
	printf("\t\tmount\n");
	printf("\t\t{\n");
	printf("\t\t\tvertex\t{\"%s vx %s %d_%d\"},\n", prefix, id, x1, y1);
	printf("\t\t\tvertex\t{\"%s vx %s %d_%d\"},\n", prefix, id, x2, y2);
	printf("\t\t\tvertex\t{\"%s vx %s %d_%d\"}\n", prefix, id, x3, y3);
	printf("\t\t}\n");
	if( strcmp( id, "<x" ) == 0 )
	{
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,y1,x1, prefix, 0,y2,x2 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,y2,x2, prefix, 0,y3,x3 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,y3,x3, prefix, 0,y1,x1 );
	}
	if( strcmp( id, ">x" ) == 0 )
	{
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,y1,x1, prefix, xcount-1,y2,x2 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,y2,x2, prefix, xcount-1,y3,x3 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,y3,x3, prefix, xcount-1,y1,x1 );
	}
	if( strcmp( id, "<y" ) == 0 )
	{
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, x1,0,y1, prefix, x2,0,y2 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, x2,0,y2, prefix, x3,0,y3 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, x3,0,y3, prefix, x1,0,y1 );
	}
	if( strcmp( id, ">y" ) == 0 )
	{
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, x1,ycount-1,y1, prefix, x2,ycount-1,y2 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, x2,ycount-1,y2, prefix, x3,ycount-1,y3 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, x3,ycount-1,y3, prefix, x1,ycount-1,y1 );
	}
	if( strcmp( id, "<z" ) == 0 )
	{
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, x1,y1,0, prefix, x2,y2,0 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, x2,y2,0, prefix, x3,y3,0 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, x3,y3,0, prefix, x1,y1,0 );
	}
	if( strcmp( id, ">z" ) == 0 )
	{
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, x1,y1,zcount-1, prefix, x2,y2,zcount-1 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, x2,y2,zcount-1, prefix, x3,y3,zcount-1 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, x3,y3,zcount-1, prefix, x1,y1,zcount-1 );
	}
	printf("\t}\n");
	printf("\n");
}

void	print_triangle_edge_211(	char *prefix, char *id1, char *id2,
									int x1, int y1, int x2, int x3 )
{
	printf("\ttriangle\n");
	printf("\t{\n");
	printf("\t\ttemplate\t{ \"%s triangle\" }\n", prefix);
	printf("\t\tmount\n");
	printf("\t\t{\n");
	printf("\t\t\tvertex{\"%s vx %s %d_%d\"},\n", prefix, id2, x1, y1);
	printf("\t\t\tvertex{\"%s vx %s %d\"},\n", prefix, id1, x2 );
	printf("\t\t\tvertex{\"%s vx %s %d\"}\n", prefix, id1, x3 );
	printf("\t\t}\n");
	if( strcmp( id1, "<x<y" ) == 0 )
	{
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,0,x2, prefix, 0,0,x3 );
	}
	if( strcmp( id1, "<x<z" ) == 0 )
	{
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,x2,0, prefix, 0,x3,0 );
	}
	if( strcmp( id1, "<y<z" ) == 0 )
	{
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, x2,0,0, prefix, x3,0,0 );
	}
	if( strcmp( id1, ">x<y" ) == 0 )
	{
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,0,x2, prefix, xcount-1,0,x3 );
	}
	if( strcmp( id1, ">x<z" ) == 0 )
	{
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,x2,0, prefix, xcount-1,x3,0 );
	}
	if( strcmp( id1, ">y<z" ) == 0 )
	{
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, x2,ycount-1,0, prefix, x3,ycount-1,0 );
	}
	if( strcmp( id1, "<x>y" ) == 0 )
	{
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,ycount-1,x2, prefix, 0,ycount-1,x3 );
	}
	if( strcmp( id1, "<x>z" ) == 0 )
	{
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,x2,zcount-1, prefix, 0,x3,zcount-1 );
	}
	if( strcmp( id1, "<y>z" ) == 0 )
	{
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, x2,0,zcount-1, prefix, x3,0,zcount-1 );
	}
	if( strcmp( id1, ">x>y" ) == 0 )
	{
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,ycount-1,x2, prefix, xcount-1,ycount-1,x3 );
	}
	if( strcmp( id1, ">x>z" ) == 0 )
	{
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,x2,zcount-1, prefix, xcount-1,x3,zcount-1 );
	}
	if( strcmp( id1, ">y>z" ) == 0 )
	{
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, x2,ycount-1,zcount-1, prefix, x3,ycount-1,zcount-1 );
	}
	printf("\t}\n");
	printf("\n");
}

void	print_triangle_edge_212(	char *prefix, char *id1, char *id2,
									int x1, int y1, int x2,
									int x3, int y3 )
{
	printf("\ttriangle\n");
	printf("\t{\n");
	printf("\t\ttemplate\t{ \"%s triangle\" }\n", prefix);
	printf("\t\tmount\n");
	printf("\t\t{\n");
	printf("\t\t\tvertex{\"%s vx %s %d_%d\"},\n", prefix, id2, x1, y1);
	printf("\t\t\tvertex{\"%s vx %s %d\"},\n", prefix, id1, x2 );
	printf("\t\t\tvertex{\"%s vx %s %d_%d\"}\n", prefix, id2, x3, y3);
	printf("\t\t}\n");
	if( strcmp( id2, "<x" ) == 0 )
	{
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,y3,x3, prefix, 0,y1,x1 );
	}
	if( strcmp( id2, ">x" ) == 0 )
	{
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,y3,x3, prefix, xcount-1,y1,x1 );
	}
	if( strcmp( id2, "<y" ) == 0 )
	{
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, x3,0,y3, prefix, x1,0,y1 );
	}
	if( strcmp( id2, ">y" ) == 0 )
	{
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, x3,ycount-1,y3, prefix, x1,ycount-1,y1 );
	}
	if( strcmp( id2, "<z" ) == 0 )
	{
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, x3,y3,0, prefix, x1,y1,0 );
	}
	if( strcmp( id2, ">z" ) == 0 )
	{
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, x3,y3,zcount-1, prefix, x1,y1,zcount-1 );
	}
	printf("\t}\n");
	printf("\n");
}

void	print_triangle_edge_221(	char *prefix, char *id1, char *id2,
									int x1, int y1, int x2,
									int y2, int x3 )
{
	printf("\ttriangle\n");
	printf("\t{\n");
	printf("\t\ttemplate\t{ \"%s triangle\" }\n", prefix);
	printf("\t\tmount\n");
	printf("\t\t{\n");
	printf("\t\t\tvertex{\"%s vx %s %d_%d\"},\n", prefix, id2, x1, y1);
	printf("\t\t\tvertex{\"%s vx %s %d_%d\"},\n", prefix, id2, x2, y2);
	printf("\t\t\tvertex{\"%s vx %s %d\"}\n", prefix, id1, x3 );
	printf("\t\t}\n");
	if( strcmp( id2, "<x" ) == 0 )
	{
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,y2,x2, prefix, 0,y1,x1 );
	}
	if( strcmp( id2, ">x" ) == 0 )
	{
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,y2,x2, prefix, xcount-1,y1,x1 );
	}
	if( strcmp( id2, "<y" ) == 0 )
	{
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, x2,0,y2, prefix, x1,0,y1 );
	}
	if( strcmp( id2, ">y" ) == 0 )
	{
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, x2,ycount-1,y2, prefix, x1,ycount-1,y1 );
	}
	if( strcmp( id2, "<z" ) == 0 )
	{
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, x2,y2,0, prefix, x1,y1,0 );
	}
	if( strcmp( id2, ">z" ) == 0 )
	{
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, x2,y2,zcount-1, prefix, x1,y1,zcount-1 );
	}
	printf("\t}\n");
	printf("\n");
}

int main( int argc, char* argv[] )
{	
	char 	*prefix;

	int 	x, y, z;

	FILE	*vertices;
	int		c;
	
	vertices = tmpfile();

	if( argc == 5 )
	{
		xcount	= atoi( argv[1] );
		ycount	= atoi( argv[2] );
		zcount	= atoi( argv[3] );
		prefix	= argv[4];
	}
	else
	{
		print_usage( argv[0] );
		return -1;
	}

	if( ( xcount < 1 ) || ( ycount < 1 ) || ( zcount < 1 ) )
	{
		fprintf(stderr, "%s error: Dimensions must be > 0.\n", argv[0]);
		print_usage( argv[0] );
		return -1;
	}

	printf("air\t\t\t{ 0.1 }\n");
	printf("dt\t\t\t{ 0.001 }\n");
	printf("\n");

	/* useful definitions */

	printf("### start of block named -- %s -- ###\n", prefix);
	printf("\n");
	printf("\n");

	printf("# %s definitions\n", prefix);
	printf("# These definititions control the creation of the block\n");
	printf("\n");

	printf("# spacing between the objects\n");
	printf("\n");
	printf("constant real\n");
	printf("{\n");
	printf("\tname\t\t{ \"%s spacing\" }\n", prefix);
	printf("\texpression\t{ 1 }\n");
	printf("}\n");
	printf("\n");

	printf("# orientation of the x-axis of the block\n");
	printf("constant vector\n");
	printf("{\n");
	printf("\tname\t\t{ \"%s x axis\" }\n", prefix);
	printf("\texpression\t{ vector { 1, 0, 0 } }\n");
	printf("}\n");
	printf("\n");
	
	printf("# orientation of the y-axis of the block, or \"up\" vector.\n");
	printf("# This doesn't need to be orthogonal to the x axis.\n");
	printf("constant vector\n");
	printf("{\n");
	printf("\tname\t\t{ \"%s y axis\" }\n", prefix);
	printf("\texpression\t{ vector { 0, 1, 0 } }\n");
	printf("}\n");
	printf("\n");
	
	printf("# position of the center of the block\n");
	printf("constant vector\n");
	printf("{\n");
	printf("\tname\t\t{ \"%s position\" }\n", prefix);
	printf("\texpression\t{ vector { 0, 0, 0 } }\n");
	printf("}\n");

	printf("\n");

	printf("# velocity of the block\n");
	printf("constant vector\n");
	printf("{\n");
	printf("\tname\t\t{ \"%s velocity\" }\n", prefix);
	printf("\texpression\t{ vector { 0, 0, 0 } }\n");
	printf("}\n");

	printf("\n");

	printf("# angular velocity of the block\n");
	printf("constant vector\n");
	printf("{\n");
	printf("\tname\t\t{ \"%s angular velocity\" }\n", prefix);
	printf("\texpression\t{ vector { 0, 0, 0 } }\n");
	printf("}\n");

	printf("\n");

	printf("# pivot point for the angular velocity\n");
	printf("constant vector\n");
	printf("{\n");
	printf("\tname\t\t{ \"%s pivot\" }\n", prefix);
	printf("\texpression\t{ vector { 0, 0, 0 } }\n");
	printf("}\n");

	printf("\n");

	printf("# (all of the vectors above are specified in the scene coordinate system)\n");

	printf("\n");
	printf("# end of definitions\n");
	printf("\n");
	printf("\n");

	/* templates */
	printf("# %s templates\n", prefix);
	printf("# These templates are used by the objects and connections of the block.\n");
	printf("# At least the radius should be changed to fit the spacing.\n");
	printf("\n");

	printf("template object\n");
	printf("{\n");
	printf("\tmass\t\t{ 10 }\n");
	printf("\tradius\t\t{ 1 }\n");
	printf("\tdamp\t\t{ 1E2 }\n");
	printf("\tk\t\t\t{ 1E5 }\n");
	printf("\ttolerance\t{ 0.1 }\n");
	printf("\tgsource\t\t{ false }\n");
	printf("\tgrecipient\t{ false }\n");
	printf("\tname\t\t{ \"%s\" }\n", prefix);
	printf("}\n");

	printf("\n");


	printf("template connection\n");
	printf("{\n");
	printf("\tlength\t\t{ constant real{\"%s spacing\"} }\n", prefix );
	printf("\tdamp\t\t{ 5E2 }\n");
	printf("\tk\t\t\t{ 1E4 }\n");
	printf("\ttolerance\t{ 9E9 }\n");
	printf("\tname\t\t{ \"%s_straight\" }\n", prefix);
	printf("}\n");

	printf("\n");

	printf("template connection\n");
	printf("{\n");
	printf("\ttemplate\t{ \"%s_straight\" }\n", prefix);
	printf("\tlength\t\t{ constant real{\"%s spacing\"} * 2^(1/2) }\n", prefix);
	printf("\tname\t\t{ \"%s_2space_diagonal\" }\n", prefix);
	printf("}\n");

	printf("\n");

	printf("template connection\n");
	printf("{\n");
	printf("\ttemplate\t{ \"%s_straight\" }\n", prefix);
	printf("\tlength\t\t{ constant real{\"%s spacing\"} * 3^(1/2) }\n", prefix );
	printf("\tname\t\t{ \"%s_3space_diagonal\" }\n", prefix);
	printf("}\n");

	printf("\n");

	printf("# %s calculations\n", prefix);

	printf("\n");

	printf("# From the definitions we can now calculate the unit vectors for the block\n");
	printf("# coordinate system. First we normalize the x vector to get the x unit vector.\n");
	printf("# Then we find the y axis vector component orthogonal to the x unit vector.\n");
	printf("# We do this by projecting the y axis vector on the x unit vector, and then\n");
	printf("# subtracting this from the original y axis vector. This vector is then normalized\n");
	printf("# to produce the y unit vector. We can the take the cross product of the x and y\n");
	printf("# unit vectors to produce the z unit vector. We now have a new orthonormal basis\n");
	printf("# we can build the block with.\n");
	printf("\n");
	printf("constant vector\n");
	printf("{\n");
	printf("\tname\t\t{ \"%s x unit\" }\n", prefix);
	printf("\texpression\t{ constant vector {\"%s x axis\"} / | constant vector {\"%s x axis\"} | }\n", prefix, prefix);
	printf("}\n");
	printf("\n");

	printf("constant vector\n");
	printf("{\n");
	printf("\tname\t\t{ \"%s y normalized\" }\n", prefix);
	printf("\texpression\t{ constant vector {\"%s y axis\"} / | constant vector {\"%s y axis\"} | }\n", prefix, prefix);
	printf("}\n");
	printf("\n");

	printf("constant vector\n");
	printf("{\n");
	printf("\tname\t\t{ \"%s y ortho x\" }\n", prefix);
	printf("\texpression\t{\tconstant vector {\"%s y normalized\"} - constant vector {\"%s x unit\"} *\n", prefix, prefix);
	printf("\t\t\t\t\t( constant vector {\"%s y normalized\"} * constant vector {\"%s x unit\"} ) }\n", prefix, prefix );
	printf("}\n");
	printf("\n");

	printf("constant vector\n");
	printf("{\n");
	printf("\tname\t\t{ \"%s y unit\" }\n", prefix);
	printf("\texpression\t{ constant vector {\"%s y ortho x\"} / | constant vector {\"%s y ortho x\"} | }\n", prefix, prefix);
	printf("}\n");
	printf("\n");

	printf("constant vector\n");
	printf("{\n");
	printf("\tname\t\t{ \"%s z unit\" }\n", prefix);
	printf("\texpression\t{ constant vector {\"%s x unit\"} x constant vector {\"%s y unit\"} }\n", prefix, prefix);
	printf("}\n");
	printf("\n");

	printf("constant vector\n");
	printf("{\n");
	printf("\tname\t\t{ \"%s offset\" }\n", prefix);
	printf("\texpression\t{ constant vector{\"%s position\"} - constant real{\"%s spacing\"} * ( %f * constant vector{\"%s x unit\"} + %f * constant vector{\"%s y unit\"} + %f * constant vector{\"%s z unit\"} ) }\n", prefix, prefix, (xcount-1.0) / 2.0, prefix, (ycount-1.0) / 2.0, prefix, (zcount-1.0) / 2.0, prefix);
	printf("}\n");
	printf("\n");
	printf("\n");



	for(z = 0; z < zcount; z++)
	{
		for(y = 0; y < ycount; y++)
		{
			for(x = 0; x < xcount; x++)
			{
				printf("object\n");
				printf("{\n");
				printf("\ttemplate\t{ \"%s\" }\n", prefix);
				printf("\tposition {\tconstant vector{\"%s offset\"} + constant real{\"%s spacing\"} * vector {\n", prefix, prefix);
				printf("\t\t\t\t%d * constant vector{\"%s x unit\"}.x + %d * constant vector{\"%s y unit\"}.x + %d * constant vector{\"%s z unit\"}.x,\n", x, prefix, y, prefix, z, prefix);
				printf("\t\t\t\t%d * constant vector{\"%s x unit\"}.y + %d * constant vector{\"%s y unit\"}.y + %d * constant vector{\"%s z unit\"}.y,\n", x, prefix, y, prefix, z, prefix);
				printf("\t\t\t\t%d * constant vector{\"%s x unit\"}.z + %d * constant vector{\"%s y unit\"}.z + %d * constant vector{\"%s z unit\"}.z } }\n", x, prefix, y, prefix, z, prefix);
				printf("\tvelocity {\tconstant vector{\"%s velocity\"} + constant vector{\"%s angular velocity\"} x\n", prefix, prefix);
				printf("\t\t\t\t( object{this}.position - constant vector{\"%s pivot\"} ) }\n", prefix);
				printf("\tname\t\t{ \"%s %d_%d_%d\" }\n", prefix, x, y, z );
				printf("}\n");
				printf("\n");
			}
		}
	}

	for(z = 0; z < zcount; z++)
	{
		for(y = 0; y < ycount; y++)
		{
			for(x = 0; x < xcount; x++)
			{
				if(x+1 != xcount)
				{
					print_connection( prefix, "straight", x, y, z, x+1, y, z);
				}

				if(y+1 != ycount)
				{
					print_connection( prefix, "straight", x, y, z, x, y+1, z);
				}

				if(z+1 != zcount)
				{
					print_connection( prefix, "straight", x, y, z, x, y, z+1);
				}
			}
		}
	}





	for(z = 0; z < zcount; z++)
	{
		for(y = 0; y < ycount; y++)
		{
			for(x = 0; x < xcount; x++)
			{
				if( (x+1 != xcount) && (y+1 != ycount) )
				{
					print_connection( prefix, "2space_diagonal", x, y, z, x+1, y+1, z);
				}

				if( (x+1 != xcount) && (z+1 != zcount) )
				{
					print_connection( prefix, "2space_diagonal", x, y, z, x+1, y, z+1);
				}

				if( (y+1 != ycount) && (z+1 != zcount) )
				{
					print_connection( prefix, "2space_diagonal", x, y, z, x, y+1, z+1);
				}


				if( (x-1 != -1) && (y+1 != ycount) )
				{
					print_connection( prefix, "2space_diagonal", x, y, z, x-1, y+1, z);
				}

				if( (x-1 != -1) && (z+1 != zcount) )
				{
					print_connection( prefix, "2space_diagonal", x, y, z, x-1, y, z+1);
				}

				if( (y-1 != -1) && (z+1 != zcount) )
				{
					print_connection( prefix, "2space_diagonal", x, y, z, x, y-1, z+1);
				}
			}
		}
	}



	for(z = 0; z < zcount; z++)
	{
		for(y = 0; y < ycount; y++)
		{
			for(x = 0; x < xcount; x++)
			{
				if( (x+1 != xcount) && (y+1 != ycount) && (z+1 != zcount) )
				{
					print_connection( prefix, "3space_diagonal", x, y, z, x+1, y+1, z+1);
				}

				if( (x-1 != -1) && (y+1 != ycount) && (z+1 != zcount) )
				{
					print_connection( prefix, "3space_diagonal", x, y, z, x-1, y+1, z+1);
				}

				if( (x-1 != -1) && (y-1 != -1) && (z+1 != zcount) )
				{
					print_connection( prefix, "3space_diagonal", x, y, z, x-1, y-1, z+1);
				}


				if( (x+1 != xcount) && (y-1 != -1) && (z+1 != zcount) )
				{
					print_connection( prefix, "3space_diagonal", x, y, z, x+1, y-1, z+1);
				}
			}
		}
	}

/* graphics */

	/* variables */

	printf("camera\n");
	printf("{\n");

	printf("\tvariable vector\n");
	printf("\t{\n");
	printf("\t\tfunction\n\t\t{\n\t\t\t((object{\"%s %d_%d_%d\"}.position - object{\"%s %d_%d_%d\"}.position) * 0.5 ) +\n\t\t\t", prefix, 0, 0, 0, prefix, xcount-1, ycount-1, zcount-1);
	printf("object{\"%s %d_%d_%d\"}.position\n\t\t}\n", prefix, xcount-1, ycount-1, zcount-1 );
	printf("\t\tname\t\t{ \"%s center\" }\n", prefix );
	printf("\t}\n");
	printf("\n");

	for(z = 0; z < zcount; z++)
	{
		for(y = 0; y < ycount; y++)
		{
			for(x = 0; x < xcount; x++)
			{
				if( ( x == 0 ) && ( xcount>1 ) )
				{
					print_variable_and_vertex( prefix, vertices, "<x", x, y, z, x+1, y, z, z, y );
				}
			}
		}
	}


	for(z = 0; z < zcount; z++)
	{
		for(y = 0; y < ycount; y++)
		{
			for(x = 0; x < xcount; x++)
			{
				if( ( x == xcount-1 )  && ( xcount>1 ) )
				{
					print_variable_and_vertex( prefix, vertices, ">x", x, y, z, x-1, y, z, z, y );
				}
			}
		}
	}

	for(z = 0; z < zcount; z++)
	{
		for(y = 0; y < ycount; y++)
		{
			for(x = 0; x < xcount; x++)
			{
				if( ( y == 0 )  && ( ycount>1 ) )
				{
					print_variable_and_vertex( prefix, vertices, "<y", x, y, z, x, y+1, z, x, z );
				}
			}
		}
	}

	for(z = 0; z < zcount; z++)
	{
		for(y = 0; y < ycount; y++)
		{
			for(x = 0; x < xcount; x++)
			{
				if( ( y == ycount-1 )  && ( ycount>1 ) )
				{
					print_variable_and_vertex( prefix, vertices, ">y", x, y, z, x, y-1, z, x, z );
				}
			}
		}
	}

	for(z = 0; z < zcount; z++)
	{
		for(y = 0; y < ycount; y++)
		{
			for(x = 0; x < xcount; x++)
			{
				if( ( z == 0 )  && ( zcount>1 ) )
				{
					print_variable_and_vertex( prefix, vertices, "<z", x, y, z, x, y, z+1, x, y );
				}
			}
		}
	}

	for(z = 0; z < zcount; z++)
	{
		for(y = 0; y < ycount; y++)
		{
			for(x = 0; x < xcount; x++)
			{
				if( ( z == zcount-1 )  && ( zcount>1 ) )
				{
					print_variable_and_vertex( prefix, vertices, ">z", x, y, z, x, y, z-1, x, y );
				}
			}
		}
	}

	/* edges */

	for(z = 0; z < zcount; z++)
	{
		if( (xcount > 1) && (ycount > 1) )
		{
			print_variable_and_vertex_edge( prefix, vertices, "<x<y", 0, 0, z, 1, 1, z, z );
		}
	}

	for(z = 0; z < zcount; z++)
	{
		if( (xcount > 1) && (ycount > 1) )
		{
			print_variable_and_vertex_edge( prefix, vertices, ">x<y", xcount-1, 0, z, xcount-2, 1, z, z );
		}
	}

	for(z = 0; z < zcount; z++)
	{
		if( (xcount > 1) && (ycount > 1) )
		{
			print_variable_and_vertex_edge( prefix, vertices, "<x>y", 0, ycount-1, z, 1, ycount-2, z, z );
		}
	}

	for(z = 0; z < zcount; z++)
	{
		if( (xcount > 1) && (ycount > 1) )
		{
			print_variable_and_vertex_edge( prefix, vertices, ">x>y", xcount-1, ycount-1, z, xcount-2, ycount-2, z, z );
		}
	}






	for(x = 0; x < xcount; x++)
	{
		if( (zcount > 1) && (ycount > 1) )
		{
			print_variable_and_vertex_edge( prefix, vertices, "<y<z", x, 0, 0, x, 1, 1, x );
		}
	}

	for(x = 0; x < xcount; x++)
	{
		if( (zcount > 1) && (ycount > 1) )
		{
			print_variable_and_vertex_edge( prefix, vertices, "<y>z", x, 0, zcount-1, x, 1, zcount-2, x );
		}
	}

	for(x = 0; x < xcount; x++)
	{
		if( (zcount > 1) && (ycount > 1) )
		{
			print_variable_and_vertex_edge( prefix, vertices, ">y>z", x, ycount-1, zcount-1, x, ycount-2, zcount-2, x );
		}
	}

	for(x = 0; x < xcount; x++)
	{
		if( (zcount > 1) && (ycount > 1) )
		{
			print_variable_and_vertex_edge( prefix, vertices, ">y<z", x, ycount-1, 0, x, ycount-2, 1, x );
		}
	}




	for(y = 0; y < ycount; y++)
	{
		if( (xcount > 1) && (zcount > 1) )
		{
			print_variable_and_vertex_edge( prefix, vertices, "<x<z", 0, y, 0, 1, y, 1, y );
		}
	}

	for(y = 0; y < ycount; y++)
	{
		if( (xcount > 1) && (zcount > 1) )
		{
			print_variable_and_vertex_edge( prefix, vertices, ">x<z", xcount-1, y, 0, xcount-2, y, 1, y );
		}
	}

	for(y = 0; y < ycount; y++)
	{
		if( (xcount > 1) && (zcount > 1) )
		{
			print_variable_and_vertex_edge( prefix, vertices, ">x>z", xcount-1, y, zcount-1, xcount-2, y, zcount-2, y );
		}
	}

	for(y = 0; y < ycount; y++)
	{
		if( (xcount > 1) && (zcount > 1) )
		{
			print_variable_and_vertex_edge( prefix, vertices, "<x>z", 0, y, zcount-1, 1, y, zcount-2, y );
		}
	}

	/* corners */
	
	if( (xcount > 1) && (ycount > 1) && (zcount > 1) )
	{
		print_variable_and_vertex_corner( prefix, vertices, "<x<y<z", 0, 0, 0, 1, 1, 1 );
		print_variable_and_vertex_corner( prefix, vertices, ">x<y<z", xcount-1, 0, 0, xcount-2, 1, 1 );
		print_variable_and_vertex_corner( prefix, vertices, ">x<y>z", xcount-1, 0, zcount-1, xcount-2, 1, zcount-2 );
		print_variable_and_vertex_corner( prefix, vertices, "<x<y>z", 0, 0, zcount-1, 1, 1, zcount-2 );

		print_variable_and_vertex_corner( prefix, vertices, "<x>y<z", 0, ycount-1, 0, 1, ycount-2, 1 );
		print_variable_and_vertex_corner( prefix, vertices, ">x>y<z", xcount-1, ycount-1, 0, xcount-2, ycount-2, 1 );
		print_variable_and_vertex_corner( prefix, vertices, ">x>y>z", xcount-1, ycount-1, zcount-1, xcount-2, ycount-2, zcount-2 );
		print_variable_and_vertex_corner( prefix, vertices, "<x>y>z", 0, ycount-1, zcount-1, 1, ycount-2, zcount-2 );
	}


	/* vertices */

	rewind(vertices);
	while( (c=fgetc(vertices)) != EOF )
	{
		fputc(c,stdout);
	}
	if( fclose(vertices) == EOF )
		fprintf( stderr, "error closing tempfile\n" );

	/* triangles */
	
		
	printf("\n");
	printf("\n");

	printf("\ttemplate triangle\n");
	printf("\t{\n");
	printf("\t\tname\t\t{ \"%s triangle\" }\n", prefix);
	
	printf("\t}\n");
	printf("\n");


	if( (xcount>1) && (ycount>1) && (zcount>1))
	{

		/* <x */

		for(z = 0; z < zcount; z++)
		{
			for(y = 0; y < ycount; y++)
			{
				if( (y+1 != ycount) && (z+1 != zcount) )
				{
					/* chessboard pattern */
					if( (z%2) == (y%2) )
					{
						print_triangle_face( prefix, "<x", z, y, z+1, y, z, y+1 );
						print_triangle_face( prefix, "<x", z, y+1, z+1, y, z+1, y+1 );
					}
					else
					{
						print_triangle_face( prefix, "<x", z, y, z+1, y, z+1, y+1 );
						print_triangle_face( prefix, "<x", z, y, z+1, y+1, z, y+1 );
					}
				}


				if( (y+1 == ycount) && (z+1 != zcount))
				{
					if( (z%2) == (y%2) )
					{
						print_triangle_edge_221( prefix, "<x>y", "<x", z, y, z+1, y, z );
						print_triangle_edge_211( prefix, "<x>y", "<x", z+1, y, z+1, z );
					}
					else
					{
						print_triangle_edge_221( prefix, "<x>y", "<x", z, y, z+1, y, z+1 );
						print_triangle_edge_211( prefix, "<x>y", "<x", z, y, z+1, z );
					}
				}

				if( (y == 0) && (z+1 != zcount))
				{
					if( (z%2) == (y%2) )
					{
						print_triangle_edge_212( prefix, "<x<y", "<x", z, y, z, z+1, y );
						print_triangle_edge_211( prefix, "<x<y", "<x", z+1, y, z, z+1 );
					}
					else
					{
						print_triangle_edge_211( prefix, "<x<y", "<x", z, y, z, z+1 );
						print_triangle_edge_212( prefix, "<x<y", "<x", z, y, z+1, z+1, y );
					}
				}

				if( (z == 0) && (y+1 != ycount) )
				{
					if( (z%2) == (y%2) )
					{
						print_triangle_edge_221( prefix, "<x<z", "<x", z, y, z, y+1, y );
						print_triangle_edge_211( prefix, "<x<z", "<x", z, y+1, y+1, y );
					}
					else
					{
						print_triangle_edge_211( prefix, "<x<z", "<x", z, y, y+1, y );
						print_triangle_edge_221( prefix, "<x<z", "<x", z, y, z, y+1, y+1 );
					}
				}

				if( (z+1 == zcount) && (y+1 != ycount) )
				{
					if( (z%2) == (y%2) )
					{
						print_triangle_edge_212( prefix, "<x>z", "<x", z, y, y, z, y+1 );
						print_triangle_edge_211( prefix, "<x>z", "<x", z, y+1, y, y+1 );
					}
					else
					{
						print_triangle_edge_211( prefix, "<x>z", "<x", z, y, y, y+1 );
						print_triangle_edge_212( prefix, "<x>z", "<x", z, y, y+1, z, y+1 );
					}
				}
			}
		}	


		/* >x */

		for(z = 0; z < zcount; z++)
		{
			for(y = 0; y < ycount; y++)
			{
				if( (y+1 != ycount) && (z+1 != zcount) )
				{
					/* chessboard pattern */
					if( (z%2) == (y%2) )
					{
						print_triangle_face( prefix, ">x", z, y, z, y+1, z+1, y );
						print_triangle_face( prefix, ">x", z, y+1, z+1, y+1, z+1, y );
					}
					else
					{
						print_triangle_face( prefix, ">x", z, y, z+1, y+1, z+1, y );
						print_triangle_face( prefix, ">x", z, y, z, y+1, z+1, y+1 );
					}
				}

				if( (y+1 == ycount) && (z+1 != zcount))
				{
					if( (z%2) == (y%2) )
					{
						print_triangle_edge_212( prefix, ">x>y", ">x", z, y, z, z+1, y );
						print_triangle_edge_211( prefix, ">x>y", ">x", z+1, y, z, z+1 );
					}
					else
					{
						print_triangle_edge_211( prefix, ">x>y", ">x", z, y, z, z+1 );
						print_triangle_edge_212( prefix, ">x>y", ">x", z, y, z+1, z+1, y );
					}
				}

				if( (y == 0) && (z+1 != zcount))
				{
					if( (z%2) == (y%2) )
					{
						print_triangle_edge_221( prefix, ">x<y", ">x", z, y, z+1, y, z );
						print_triangle_edge_211( prefix, ">x<y", ">x", z+1, y, z+1, z );
					}
					else
					{
						print_triangle_edge_211( prefix, ">x<y", ">x", z, y, z+1, z );
						print_triangle_edge_221( prefix, ">x<y", ">x", z, y, z+1, y, z+1 );
					}
				}

				if( (z == 0) && (y+1 != ycount) )
				{
					if( (z%2) == (y%2) )
					{
						print_triangle_edge_212( prefix, ">x<z", ">x", z, y, y, z, y+1 );
						print_triangle_edge_211( prefix, ">x<z", ">x", z, y+1, y, y+1 );
					}
					else
					{
						print_triangle_edge_211( prefix, ">x<z", ">x", z, y, y, y+1 );
						print_triangle_edge_212( prefix, ">x<z", ">x", z, y, y+1, z, y+1 );
					}
				}

				if( (z+1 == zcount) && (y+1 != ycount) )
				{
					if( (z%2) == (y%2) )
					{
						print_triangle_edge_221( prefix, ">x>z", ">x", z, y, z, y+1, y );
						print_triangle_edge_211( prefix, ">x>z", ">x", z, y+1, y+1, y );
					}
					else
					{
						print_triangle_edge_211( prefix, ">x>z", ">x", z, y, y+1, y );
						print_triangle_edge_221( prefix, ">x>z", ">x", z, y, z, y+1, y+1 );
					}
				}
			}
		}	
	}




	if( (xcount>1) && (ycount>1) && (zcount>1))
	{

		/* <y */

		for(x = 0; x < xcount; x++)
		{
			for(z = 0; z < zcount; z++)
			{
				if( (x+1 != xcount) && (z+1 != zcount) )
				{
					/* chessboard pattern */
					if( (x%2) == (z%2) )
					{
						print_triangle_face( prefix, "<y", x, z, x+1, z, x, z+1 );
						print_triangle_face( prefix, "<y", x, z+1, x+1, z, x+1, z+1 );
					}
					else
					{
						print_triangle_face( prefix, "<y", x, z, x+1, z, x+1, z+1 );
						print_triangle_face( prefix, "<y", x, z, x+1, z+1, x, z+1 );
					}
				}

				if( (x == 0) && (z+1 != zcount) )
				{
					if( (z%2) == (x%2) )
					{
						print_triangle_edge_221( prefix, "<x<y", "<y", x, z, x, z+1, z );
						print_triangle_edge_211( prefix, "<x<y", "<y", x, z+1, z+1, z );
					}
					else
					{
						print_triangle_edge_211( prefix, "<x<y", "<y", x, z, z+1, z );
						print_triangle_edge_221( prefix, "<x<y", "<y", x, z, x, z+1, z+1 );
					}
				}

				if( (x+1 == xcount) && (z+1 != zcount) )
				{
					if( (z%2) == (x%2) )
					{
						print_triangle_edge_212( prefix, ">x<y", "<y", x, z, z, x, z+1 );
						print_triangle_edge_211( prefix, ">x<y", "<y", x, z+1, z, z+1 );
					}
					else
					{
						print_triangle_edge_211( prefix, ">x<y", "<y", x, z, z, z+1 );
						print_triangle_edge_212( prefix, ">x<y", "<y", x, z, z+1, x, z+1 );
					}
				}

				if( (z == 0) && (x+1 != xcount) )
				{
					if( (z%2) == (x%2) )
					{
						print_triangle_edge_212( prefix, "<y<z", "<y", x, z, x, x+1, z );
						print_triangle_edge_211( prefix, "<y<z", "<y", x+1, z, x, x+1 );
					}
					else
					{
						print_triangle_edge_211( prefix, "<y<z", "<y", x, z, x, x+1 );
						print_triangle_edge_212( prefix, "<y<z", "<y", x, z, x+1, x+1, z );
					}
				}

				if( (z+1 == zcount) && (x+1 != xcount) )
				{
					if( (z%2) == (x%2) )
					{
						print_triangle_edge_221( prefix, "<y>z", "<y", x, z, x+1, z, x );
						print_triangle_edge_211( prefix, "<y>z", "<y", x+1, z, x+1, x );
					}
					else
					{
						print_triangle_edge_211( prefix, "<y>z", "<y", x, z, x+1, x );
						print_triangle_edge_221( prefix, "<y>z", "<y", x, z, x+1, z, x+1 );
					}
				}

			}
		}	


		/* >y */

		for(x = 0; x < xcount; x++)
		{
			for(z = 0; z < zcount; z++)
			{
				if( (x+1 != xcount) && (z+1 != zcount) )
				{
					/* chessboard pattern */
					if( (x%2) == (z%2) )
					{
						print_triangle_face( prefix, ">y", x, z, x, z+1, x+1, z );
						print_triangle_face( prefix, ">y", x, z+1, x+1, z+1, x+1, z );
					}
					else
					{
						print_triangle_face( prefix, ">y", x, z, x+1, z+1, x+1, z );
						print_triangle_face( prefix, ">y", x, z, x, z+1, x+1, z+1 );
					}
				}

				if( (x == 0) && (z+1 != zcount))
				{
					if( (x%2) == (z%2) )
					{
						print_triangle_edge_221( prefix, "<x>y", ">y", x, z+1, x, z, z );
						print_triangle_edge_211( prefix, "<x>y", ">y", x, z+1, z, z+1 );

					}
					else
					{
						print_triangle_edge_221( prefix, "<x>y", ">y", x, z+1, x, z, z+1 );
						print_triangle_edge_211( prefix, "<x>y", ">y", x, z, z, z+1 );
					}
				}

				if( (x == 0) && (z+1 != zcount) )
				{
					if( (z%2) == (x%2) )
					{
						print_triangle_edge_221( prefix, "<x>y", ">y", x, z+1, x, z, z );
						print_triangle_edge_211( prefix, "<x>y", ">y", x, z+1, z, z+1 );
					}
					else
					{
						print_triangle_edge_221( prefix, "<x>y", ">y", x, z+1, x, z, z+1 );
						print_triangle_edge_211( prefix, "<x>y", ">y", x, z, z, z+1 );
					}
				}

				if( (x+1 == xcount) && (z+1 != zcount) )
				{
					if( (z%2) == (x%2) )
					{
						print_triangle_edge_221( prefix, ">x>y", ">y", x, z, x, z+1, z );
						print_triangle_edge_211( prefix, ">x>y", ">y", x, z+1, z+1, z );
					}
					else
					{
						print_triangle_edge_211( prefix, ">x>y", ">y", x, z, z+1, z );
						print_triangle_edge_221( prefix, ">x>y", ">y", x, z, x, z+1, z+1 );
					}
				}

				if( (z == 0) && (x+1 != xcount) )
				{
					if( (z%2) == (x%2) )
					{
						print_triangle_edge_221( prefix, ">y<z", ">y", x, z, x+1, z, x );
						print_triangle_edge_211( prefix, ">y<z", ">y", x+1, z, x+1, x );
					}
					else
					{
						print_triangle_edge_211( prefix, ">y<z", ">y", x, z, x+1, x );
						print_triangle_edge_221( prefix, ">y<z", ">y", x, z, x+1, z, x+1 );
					}
				}

				if( (z+1 == zcount) && (x+1 != xcount) )
				{
					if( (z%2) == (x%2) )
					{
						print_triangle_edge_212( prefix, ">y>z", ">y", x, z, x, x+1, z );
						print_triangle_edge_211( prefix, ">y>z", ">y", x+1, z, x, x+1 );
					}
					else
					{
						print_triangle_edge_211( prefix, ">y>z", ">y", x, z, x, x+1 );
						print_triangle_edge_212( prefix, ">y>z", ">y", x, z, x+1, x+1, z );
					}
				}

			}
		}	
	}



	if( (xcount>1) && (ycount>1) && (zcount>1))
	{

		/* <z */

		for(x = 0; x < xcount; x++)
		{
			for(y = 0; y < ycount; y++)
			{
				if( (x+1 != xcount) && (y+1 != ycount) )
				{
					/* chessboard pattern */
					if( (x%2) == (y%2) )
					{
						print_triangle_face( prefix, "<z", x, y, x, y+1, x+1, y );
						print_triangle_face( prefix, "<z", x, y+1, x+1, y+1, x+1, y );
					}
					else
					{
						print_triangle_face( prefix, "<z", x, y, x+1, y+1, x+1, y );
						print_triangle_face( prefix, "<z", x, y, x, y+1, x+1, y+1 );
					}
				}
				if( (y == 0) && (x+1 != xcount) )
				{
					if( (y%2) == (x%2) )
					{
						print_triangle_edge_221( prefix, "<y<z", "<z", x, y, x+1, y, x );
						print_triangle_edge_211( prefix, "<y<z", "<z", x+1, y, x+1, x );
					}
					else
					{
						print_triangle_edge_211( prefix, "<y<z", "<z", x, y, x+1, x );
						print_triangle_edge_221( prefix, "<y<z", "<z", x, y, x+1, y, x+1 );
					}
				}

				if( (y+1 == ycount) && (x+1 != xcount) )
				{
					if( (y%2) == (x%2) )
					{
						print_triangle_edge_212( prefix, ">y<z", "<z", x, y, x, x+1, y );
						print_triangle_edge_211( prefix, ">y<z", "<z", x+1, y, x, x+1 );
					}
					else
					{
						print_triangle_edge_211( prefix, ">y<z", "<z", x, y, x, x+1 );
						print_triangle_edge_212( prefix, ">y<z", "<z", x, y, x+1, x+1, y );
					}
				}

				if( (x == 0) && (y+1 != ycount) )
				{
					if( (y%2) == (x%2) )
					{
						print_triangle_edge_212( prefix, "<x<z", "<z", x, y, y, x, y+1 );
						print_triangle_edge_211( prefix, "<x<z", "<z", x, y+1, y, y+1 );
					}
					else
					{
						print_triangle_edge_211( prefix, "<x<z", "<z", x, y, y, y+1 );
						print_triangle_edge_212( prefix, "<x<z", "<z", x, y, y+1, x, y+1 );
					}
				}

				if( (x+1 == xcount) && (y+1 != ycount) )
				{
					if( (y%2) == (x%2) )
					{
						print_triangle_edge_221( prefix, ">x<z", "<z", x, y, x, y+1, y );
						print_triangle_edge_211( prefix, ">x<z", "<z", x, y+1, y+1, y );
					}
					else
					{
						print_triangle_edge_211( prefix, ">x<z", "<z", x, y, y+1, y );
						print_triangle_edge_221( prefix, ">x<z", "<z", x, y, x, y+1, y+1 );
					}
				}

			}
		}	




		/* >z */

		for(x = 0; x < xcount; x++)
		{
			for(y = 0; y < ycount; y++)
			{
				if( (x+1 != xcount) && (y+1 != ycount) )
				{
					/* chessboard pattern */
					if( (x%2) == (y%2) )
					{
						print_triangle_face( prefix, ">z", x, y, x+1, y, x, y+1 );
						print_triangle_face( prefix, ">z", x, y+1, x+1, y, x+1, y+1 );
					}
					else
					{
						print_triangle_face( prefix, ">z", x, y, x+1, y, x+1, y+1 );
						print_triangle_face( prefix, ">z", x, y, x+1, y+1, x, y+1 );
					}
				}

				if( (y == 0) && (x+1 != xcount) )
				{
					if( (y%2) == (x%2) )
					{
						print_triangle_edge_212( prefix, "<y>z", ">z", x, y, x, x+1, y );
						print_triangle_edge_211( prefix, "<y>z", ">z", x+1, y, x, x+1 );
					}
					else
					{
						print_triangle_edge_211( prefix, "<y>z", ">z", x, y, x, x+1 );
						print_triangle_edge_212( prefix, "<y>z", ">z", x, y, x+1, x+1, y );
					}
				}

				if( (y+1 == ycount) && (x+1 != xcount) )
				{
					if( (y%2) == (x%2) )
					{
						print_triangle_edge_221( prefix, ">y>z", ">z", x, y, x+1, y, x );
						print_triangle_edge_211( prefix, ">y>z", ">z", x+1, y, x+1, x );
					}
					else
					{
						print_triangle_edge_211( prefix, ">y>z", ">z", x, y, x+1, x );
						print_triangle_edge_221( prefix, ">y>z", ">z", x, y, x+1, y, x+1 );
					}
				}

				if( (x == 0) && (y+1 != ycount) )
				{
					if( (y%2) == (x%2) )
					{
						print_triangle_edge_221( prefix, "<x>z", ">z", x, y, x, y+1, y );
						print_triangle_edge_211( prefix, "<x>z", ">z", x, y+1, y+1, y );
					}
					else
					{
						print_triangle_edge_211( prefix, "<x>z", ">z", x, y, y+1, y );
						print_triangle_edge_221( prefix, "<x>z", ">z", x, y, x, y+1, y+1 );
					}
				}

				if( (x+1 == xcount) && (y+1 != ycount) )
				{
					if( (y%2) == (x%2) )
					{
						print_triangle_edge_212( prefix, ">x>z", ">z", x, y, y, x, y+1 );
						print_triangle_edge_211( prefix, ">x>z", ">z", x, y+1, y, y+1 );
					}
					else
					{
						print_triangle_edge_211( prefix, ">x>z", ">z", x, y, y, y+1 );
						print_triangle_edge_212( prefix, ">x>z", ">z", x, y, y+1, x, y+1 );
					}
				}

			}
		}	
	}

	if( xcount>1 && ycount>1 && zcount>1 )
	{
	
		// corner <x>y>z

		printf("\ttriangle\n");
		printf("\t{\n");
		printf("\t\ttemplate\t{ \"%s triangle\" }\n", prefix);
		printf("\t\tmount\n");
		printf("\t\t{\n");
		printf("\t\t\tvertex{\"%s vx <x %d_%d\"},\n", prefix, zcount-1, ycount-1 );
		printf("\t\t\tvertex{\"%s vx <x>z %d\"},\n", prefix, ycount-1 );
		printf("\t\t\tvertex{\"%s vx <x>y>z\"}\n", prefix );
		printf("\t\t}\n");
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,ycount-1,zcount-1, prefix, 1,ycount-1,zcount-1 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,ycount-1,zcount-1, prefix, 0,ycount-2,zcount-1 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,ycount-1,zcount-1, prefix, 0,ycount-1,zcount-2 );
		printf("\t}\n");
		printf("\n");

		printf("\ttriangle\n");
		printf("\t{\n");
		printf("\t\ttemplate\t{ \"%s triangle\" }\n", prefix);
		printf("\t\tmount\n");
		printf("\t\t{\n");
		printf("\t\t\tvertex{\"%s vx <x %d_%d\"},\n", prefix, zcount-1, ycount-1 );
		printf("\t\t\tvertex{\"%s vx <x>y>z\"},\n", prefix );
		printf("\t\t\tvertex{\"%s vx <x>y %d\"}\n", prefix, zcount-1 );
		printf("\t\t}\n");
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,ycount-1,zcount-1, prefix, 1,ycount-1,zcount-1 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,ycount-1,zcount-1, prefix, 0,ycount-2,zcount-1 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,ycount-1,zcount-1, prefix, 0,ycount-1,zcount-2 );
		printf("\t}\n");
		printf("\n");

		printf("\ttriangle\n");
		printf("\t{\n");
		printf("\t\ttemplate\t{ \"%s triangle\" }\n", prefix);
		printf("\t\tmount\n");
		printf("\t\t{\n");
		printf("\t\t\tvertex{\"%s vx >y %d_%d\"},\n", prefix, 0, zcount-1 );
		printf("\t\t\tvertex{\"%s vx <x>y %d\"},\n", prefix, zcount-1 );
		printf("\t\t\tvertex{\"%s vx <x>y>z\"}\n", prefix );
		printf("\t\t}\n");
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,ycount-1,zcount-1, prefix, 1,ycount-1,zcount-1 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,ycount-1,zcount-1, prefix, 0,ycount-2,zcount-1 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,ycount-1,zcount-1, prefix, 0,ycount-1,zcount-2 );
		printf("\t}\n");
		printf("\n");

		printf("\ttriangle\n");
		printf("\t{\n");
		printf("\t\ttemplate\t{ \"%s triangle\" }\n", prefix);
		printf("\t\tmount\n");
		printf("\t\t{\n");
		printf("\t\t\tvertex{\"%s vx >y %d_%d\"},\n", prefix, 0, zcount-1 );
		printf("\t\t\tvertex{\"%s vx <x>y>z\"},\n", prefix );
		printf("\t\t\tvertex{\"%s vx >y>z %d\"}\n", prefix, 0 );
		printf("\t\t}\n");
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,ycount-1,zcount-1, prefix, 1,ycount-1,zcount-1 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,ycount-1,zcount-1, prefix, 0,ycount-2,zcount-1 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,ycount-1,zcount-1, prefix, 0,ycount-1,zcount-2 );
		printf("\t}\n");
		printf("\n");

		printf("\ttriangle\n");
		printf("\t{\n");
		printf("\t\ttemplate\t{ \"%s triangle\" }\n", prefix);
		printf("\t\tmount\n");
		printf("\t\t{\n");
		printf("\t\t\tvertex{\"%s vx >z %d_%d\"},\n", prefix, 0, ycount-1 );
		printf("\t\t\tvertex{\"%s vx >y>z %d\"},\n", prefix, 0 );
		printf("\t\t\tvertex{\"%s vx <x>y>z\"}\n", prefix );
		printf("\t\t}\n");
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,ycount-1,zcount-1, prefix, 1,ycount-1,zcount-1 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,ycount-1,zcount-1, prefix, 0,ycount-2,zcount-1 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,ycount-1,zcount-1, prefix, 0,ycount-1,zcount-2 );
		printf("\t}\n");
		printf("\n");

		printf("\ttriangle\n");
		printf("\t{\n");
		printf("\t\ttemplate\t{ \"%s triangle\" }\n", prefix);
		printf("\t\tmount\n");
		printf("\t\t{\n");
		printf("\t\t\tvertex{\"%s vx >z %d_%d\"},\n", prefix, 0, ycount-1 );
		printf("\t\t\tvertex{\"%s vx <x>y>z\"},\n", prefix );
		printf("\t\t\tvertex{\"%s vx <x>z %d\"}\n", prefix, ycount-1 );
		printf("\t\t}\n");
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,ycount-1,zcount-1, prefix, 1,ycount-1,zcount-1 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,ycount-1,zcount-1, prefix, 0,ycount-2,zcount-1 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,ycount-1,zcount-1, prefix, 0,ycount-1,zcount-2 );
		printf("\t}\n");
		printf("\n");


		// corner >x>y>z

		printf("\ttriangle\n");
		printf("\t{\n");
		printf("\t\ttemplate\t{ \"%s triangle\" }\n", prefix);
		printf("\t\tmount\n");
		printf("\t\t{\n");
		printf("\t\t\tvertex{\"%s vx >x %d_%d\"},\n", prefix, zcount-1, ycount-1 );
		printf("\t\t\tvertex{\"%s vx >x>y>z\"},\n", prefix );
		printf("\t\t\tvertex{\"%s vx >x>z %d\"}\n", prefix, ycount-1 );
		printf("\t\t}\n");
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,ycount-1,zcount-1, prefix, xcount-2,ycount-1,zcount-1 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,ycount-1,zcount-1, prefix, xcount-1,ycount-2,zcount-1 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,ycount-1,zcount-1, prefix, xcount-1,ycount-1,zcount-2 );
		printf("\t}\n");
		printf("\n");

		printf("\ttriangle\n");
		printf("\t{\n");
		printf("\t\ttemplate\t{ \"%s triangle\" }\n", prefix);
		printf("\t\tmount\n");
		printf("\t\t{\n");
		printf("\t\t\tvertex{\"%s vx >x %d_%d\"},\n", prefix, zcount-1, ycount-1 );
		printf("\t\t\tvertex{\"%s vx >x>y %d\"},\n", prefix, zcount-1 );
		printf("\t\t\tvertex{\"%s vx >x>y>z\"}\n", prefix );
		printf("\t\t}\n");
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,ycount-1,zcount-1, prefix, xcount-2,ycount-1,zcount-1 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,ycount-1,zcount-1, prefix, xcount-1,ycount-2,zcount-1 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,ycount-1,zcount-1, prefix, xcount-1,ycount-1,zcount-2 );
		printf("\t}\n");
		printf("\n");

		printf("\ttriangle\n");
		printf("\t{\n");
		printf("\t\ttemplate\t{ \"%s triangle\" }\n", prefix);
		printf("\t\tmount\n");
		printf("\t\t{\n");
		printf("\t\t\tvertex{\"%s vx >y %d_%d\"},\n", prefix, xcount-1, zcount-1 );
		printf("\t\t\tvertex{\"%s vx >x>y>z\"},\n", prefix );
		printf("\t\t\tvertex{\"%s vx >x>y %d\"}\n", prefix, zcount-1 );
		printf("\t\t}\n");
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,ycount-1,zcount-1, prefix, xcount-2,ycount-1,zcount-1 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,ycount-1,zcount-1, prefix, xcount-1,ycount-2,zcount-1 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,ycount-1,zcount-1, prefix, xcount-1,ycount-1,zcount-2 );
		printf("\t}\n");
		printf("\n");

		printf("\ttriangle\n");
		printf("\t{\n");
		printf("\t\ttemplate\t{ \"%s triangle\" }\n", prefix);
		printf("\t\tmount\n");
		printf("\t\t{\n");
		printf("\t\t\tvertex{\"%s vx >y %d_%d\"},\n", prefix, xcount-1, zcount-1 );
		printf("\t\t\tvertex{\"%s vx >y>z %d\"},\n", prefix, xcount-1 );
		printf("\t\t\tvertex{\"%s vx >x>y>z\"}\n", prefix );
		printf("\t\t}\n");
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,ycount-1,zcount-1, prefix, xcount-2,ycount-1,zcount-1 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,ycount-1,zcount-1, prefix, xcount-1,ycount-2,zcount-1 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,ycount-1,zcount-1, prefix, xcount-1,ycount-1,zcount-2 );
		printf("\t}\n");
		printf("\n");

		printf("\ttriangle\n");
		printf("\t{\n");
		printf("\t\ttemplate\t{ \"%s triangle\" }\n", prefix);
		printf("\t\tmount\n");
		printf("\t\t{\n");
		printf("\t\t\tvertex{\"%s vx >z %d_%d\"},\n", prefix, xcount-1, ycount-1 );
		printf("\t\t\tvertex{\"%s vx >x>y>z\"},\n", prefix );
		printf("\t\t\tvertex{\"%s vx >y>z %d\"}\n", prefix, xcount-1 );
		printf("\t\t}\n");
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,ycount-1,zcount-1, prefix, xcount-2,ycount-1,zcount-1 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,ycount-1,zcount-1, prefix, xcount-1,ycount-2,zcount-1 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,ycount-1,zcount-1, prefix, xcount-1,ycount-1,zcount-2 );
		printf("\t}\n");
		printf("\n");

		printf("\ttriangle\n");
		printf("\t{\n");
		printf("\t\ttemplate\t{ \"%s triangle\" }\n", prefix);
		printf("\t\tmount\n");
		printf("\t\t{\n");
		printf("\t\t\tvertex{\"%s vx >z %d_%d\"},\n", prefix, xcount-1, ycount-1 );
		printf("\t\t\tvertex{\"%s vx >x>z %d\"},\n", prefix, ycount-1 );
		printf("\t\t\tvertex{\"%s vx >x>y>z\"}\n", prefix );
		printf("\t\t}\n");
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,ycount-1,zcount-1, prefix, xcount-2,ycount-1,zcount-1 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,ycount-1,zcount-1, prefix, xcount-1,ycount-2,zcount-1 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,ycount-1,zcount-1, prefix, xcount-1,ycount-1,zcount-2 );
		printf("\t}\n");
		printf("\n");


		// corner <x<y>z

		printf("\ttriangle\n");
		printf("\t{\n");
		printf("\t\ttemplate\t{ \"%s triangle\" }\n", prefix);
		printf("\t\tmount\n");
		printf("\t\t{\n");
		printf("\t\t\tvertex{\"%s vx <x %d_%d\"},\n", prefix, zcount-1, 0 );
		printf("\t\t\tvertex{\"%s vx <x<y>z\"},\n", prefix );
		printf("\t\t\tvertex{\"%s vx <x>z %d\"}\n", prefix, 0 );
		printf("\t\t}\n");
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,0,zcount-1, prefix, 1,0,zcount-1 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,0,zcount-1, prefix, 0,1,zcount-1 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,0,zcount-1, prefix, 0,0,zcount-2 );
		printf("\t}\n");
		printf("\n");

		printf("\ttriangle\n");
		printf("\t{\n");
		printf("\t\ttemplate\t{ \"%s triangle\" }\n", prefix);
		printf("\t\tmount\n");
		printf("\t\t{\n");
		printf("\t\t\tvertex{\"%s vx <x %d_%d\"},\n", prefix, zcount-1, 0 );
		printf("\t\t\tvertex{\"%s vx <x<y %d\"},\n", prefix, zcount-1 );
		printf("\t\t\tvertex{\"%s vx <x<y>z\"}\n", prefix );
		printf("\t\t}\n");
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,0,zcount-1, prefix, 1,0,zcount-1 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,0,zcount-1, prefix, 0,1,zcount-1 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,0,zcount-1, prefix, 0,0,zcount-2 );
		printf("\t}\n");
		printf("\n");

		printf("\ttriangle\n");
		printf("\t{\n");
		printf("\t\ttemplate\t{ \"%s triangle\" }\n", prefix);
		printf("\t\tmount\n");
		printf("\t\t{\n");
		printf("\t\t\tvertex{\"%s vx <y %d_%d\"},\n", prefix, 0, zcount-1 );
		printf("\t\t\tvertex{\"%s vx <x<y>z\"},\n", prefix );
		printf("\t\t\tvertex{\"%s vx <x<y %d\"}\n", prefix, zcount-1 );
		printf("\t\t}\n");
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,0,zcount-1, prefix, 1,0,zcount-1 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,0,zcount-1, prefix, 0,1,zcount-1 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,0,zcount-1, prefix, 0,0,zcount-2 );
		printf("\t}\n");
		printf("\n");

		printf("\ttriangle\n");
		printf("\t{\n");
		printf("\t\ttemplate\t{ \"%s triangle\" }\n", prefix);
		printf("\t\tmount\n");
		printf("\t\t{\n");
		printf("\t\t\tvertex{\"%s vx <y %d_%d\"},\n", prefix, 0, zcount-1 );
		printf("\t\t\tvertex{\"%s vx <y>z %d\"},\n", prefix, 0 );
		printf("\t\t\tvertex{\"%s vx <x<y>z\"}\n", prefix );
		printf("\t\t}\n");
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,0,zcount-1, prefix, 1,0,zcount-1 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,0,zcount-1, prefix, 0,1,zcount-1 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,0,zcount-1, prefix, 0,0,zcount-2 );
		printf("\t}\n");
		printf("\n");

		printf("\ttriangle\n");
		printf("\t{\n");
		printf("\t\ttemplate\t{ \"%s triangle\" }\n", prefix);
		printf("\t\tmount\n");
		printf("\t\t{\n");
		printf("\t\t\tvertex{\"%s vx >z %d_%d\"},\n", prefix, 0, 0 );
		printf("\t\t\tvertex{\"%s vx <x<y>z\"},\n", prefix );
		printf("\t\t\tvertex{\"%s vx <y>z %d\"}\n", prefix, 0 );
		printf("\t\t}\n");
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,0,zcount-1, prefix, 1,0,zcount-1 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,0,zcount-1, prefix, 0,1,zcount-1 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,0,zcount-1, prefix, 0,0,zcount-2 );
		printf("\t}\n");
		printf("\n");

		printf("\ttriangle\n");
		printf("\t{\n");
		printf("\t\ttemplate\t{ \"%s triangle\" }\n", prefix);
		printf("\t\tmount\n");
		printf("\t\t{\n");
		printf("\t\t\tvertex{\"%s vx >z %d_%d\"},\n", prefix, 0, 0 );
		printf("\t\t\tvertex{\"%s vx <x>z %d\"},\n", prefix, 0 );
		printf("\t\t\tvertex{\"%s vx <x<y>z\"}\n", prefix );
		printf("\t\t}\n");
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,0,zcount-1, prefix, 1,0,zcount-1 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,0,zcount-1, prefix, 0,1,zcount-1 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,0,zcount-1, prefix, 0,0,zcount-2 );
		printf("\t}\n");
		printf("\n");

		// corner >x<y>z

		printf("\ttriangle\n");
		printf("\t{\n");
		printf("\t\ttemplate\t{ \"%s triangle\" }\n", prefix);
		printf("\t\tmount\n");
		printf("\t\t{\n");
		printf("\t\t\tvertex{\"%s vx >x %d_%d\"},\n", prefix, zcount-1, 0 );
		printf("\t\t\tvertex{\"%s vx >x>z %d\"},\n", prefix, 0 );
		printf("\t\t\tvertex{\"%s vx >x<y>z\"}\n", prefix );
		printf("\t\t}\n");
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,0,zcount-1, prefix, xcount-2,0,zcount-1 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,0,zcount-1, prefix, xcount-1,1,zcount-1 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,0,zcount-1, prefix, xcount-1,0,zcount-2 );
		printf("\t}\n");
		printf("\n");

		printf("\ttriangle\n");
		printf("\t{\n");
		printf("\t\ttemplate\t{ \"%s triangle\" }\n", prefix);
		printf("\t\tmount\n");
		printf("\t\t{\n");
		printf("\t\t\tvertex{\"%s vx >x %d_%d\"},\n", prefix, zcount-1, 0 );
		printf("\t\t\tvertex{\"%s vx >x<y>z\"},\n", prefix );
		printf("\t\t\tvertex{\"%s vx >x<y %d\"}\n", prefix, zcount-1 );
		printf("\t\t}\n");
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,0,zcount-1, prefix, xcount-2,0,zcount-1 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,0,zcount-1, prefix, xcount-1,1,zcount-1 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,0,zcount-1, prefix, xcount-1,0,zcount-2 );
		printf("\t}\n");
		printf("\n");

		printf("\ttriangle\n");
		printf("\t{\n");
		printf("\t\ttemplate\t{ \"%s triangle\" }\n", prefix);
		printf("\t\tmount\n");
		printf("\t\t{\n");
		printf("\t\t\tvertex{\"%s vx <y %d_%d\"},\n", prefix, xcount-1, zcount-1 );
		printf("\t\t\tvertex{\"%s vx >x<y %d\"},\n", prefix, zcount-1 );
		printf("\t\t\tvertex{\"%s vx >x<y>z\"}\n", prefix );
		printf("\t\t}\n");
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,0,zcount-1, prefix, xcount-2,0,zcount-1 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,0,zcount-1, prefix, xcount-1,1,zcount-1 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,0,zcount-1, prefix, xcount-1,0,zcount-2 );
		printf("\t}\n");
		printf("\n");

		printf("\ttriangle\n");
		printf("\t{\n");
		printf("\t\ttemplate\t{ \"%s triangle\" }\n", prefix);
		printf("\t\tmount\n");
		printf("\t\t{\n");
		printf("\t\t\tvertex{\"%s vx <y %d_%d\"},\n", prefix, xcount-1, zcount-1 );
		printf("\t\t\tvertex{\"%s vx >x<y>z\"},\n", prefix );
		printf("\t\t\tvertex{\"%s vx <y>z %d\"}\n", prefix, xcount-1 );
		printf("\t\t}\n");
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,0,zcount-1, prefix, xcount-2,0,zcount-1 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,0,zcount-1, prefix, xcount-1,1,zcount-1 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,0,zcount-1, prefix, xcount-1,0,zcount-2 );
		printf("\t}\n");
		printf("\n");

		printf("\ttriangle\n");
		printf("\t{\n");
		printf("\t\ttemplate\t{ \"%s triangle\" }\n", prefix);
		printf("\t\tmount\n");
		printf("\t\t{\n");
		printf("\t\t\tvertex{\"%s vx >z %d_%d\"},\n", prefix, xcount-1, 0 );
		printf("\t\t\tvertex{\"%s vx <y>z %d\"},\n", prefix, xcount-1 );
		printf("\t\t\tvertex{\"%s vx >x<y>z\"}\n", prefix );
		printf("\t\t}\n");
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,0,zcount-1, prefix, xcount-2,0,zcount-1 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,0,zcount-1, prefix, xcount-1,1,zcount-1 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,0,zcount-1, prefix, xcount-1,0,zcount-2 );
		printf("\t}\n");
		printf("\n");

		printf("\ttriangle\n");
		printf("\t{\n");
		printf("\t\ttemplate\t{ \"%s triangle\" }\n", prefix);
		printf("\t\tmount\n");
		printf("\t\t{\n");
		printf("\t\t\tvertex{\"%s vx >z %d_%d\"},\n", prefix, xcount-1, 0 );
		printf("\t\t\tvertex{\"%s vx >x<y>z\"},\n", prefix );
		printf("\t\t\tvertex{\"%s vx >x>z %d\"}\n", prefix, 0 );
		printf("\t\t}\n");
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,0,zcount-1, prefix, xcount-2,0,zcount-1 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,0,zcount-1, prefix, xcount-1,1,zcount-1 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,0,zcount-1, prefix, xcount-1,0,zcount-2 );
		printf("\t}\n");
		printf("\n");



		// corner <x>y<z

		printf("\ttriangle\n");
		printf("\t{\n");
		printf("\t\ttemplate\t{ \"%s triangle\" }\n", prefix);
		printf("\t\tmount\n");
		printf("\t\t{\n");
		printf("\t\t\tvertex{\"%s vx <x %d_%d\"},\n", prefix, 0, ycount-1 );
		printf("\t\t\tvertex{\"%s vx <x>y<z\"},\n", prefix );
		printf("\t\t\tvertex{\"%s vx <x<z %d\"}\n", prefix, ycount-1 );
		printf("\t\t}\n");
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,ycount-1,0, prefix, 1,ycount-1,0 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,ycount-1,0, prefix, 0,ycount-2,0 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,ycount-1,0, prefix, 0,ycount-1,1 );
		printf("\t}\n");
		printf("\n");

		printf("\ttriangle\n");
		printf("\t{\n");
		printf("\t\ttemplate\t{ \"%s triangle\" }\n", prefix);
		printf("\t\tmount\n");
		printf("\t\t{\n");
		printf("\t\t\tvertex{\"%s vx <x %d_%d\"},\n", prefix, 0, ycount-1 );
		printf("\t\t\tvertex{\"%s vx <x>y %d\"},\n", prefix, 0 );
		printf("\t\t\tvertex{\"%s vx <x>y<z\"}\n", prefix );
		printf("\t\t}\n");
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,ycount-1,0, prefix, 1,ycount-1,0 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,ycount-1,0, prefix, 0,ycount-2,0 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,ycount-1,0, prefix, 0,ycount-1,1 );
		printf("\t}\n");
		printf("\n");

		printf("\ttriangle\n");
		printf("\t{\n");
		printf("\t\ttemplate\t{ \"%s triangle\" }\n", prefix);
		printf("\t\tmount\n");
		printf("\t\t{\n");
		printf("\t\t\tvertex{\"%s vx >y %d_%d\"},\n", prefix, 0, 0 );
		printf("\t\t\tvertex{\"%s vx <x>y<z\"},\n", prefix );
		printf("\t\t\tvertex{\"%s vx <x>y %d\"}\n", prefix, 0 );
		printf("\t\t}\n");
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,ycount-1,0, prefix, 1,ycount-1,0 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,ycount-1,0, prefix, 0,ycount-2,0 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,ycount-1,0, prefix, 0,ycount-1,1 );
		printf("\t}\n");
		printf("\n");

		printf("\ttriangle\n");
		printf("\t{\n");
		printf("\t\ttemplate\t{ \"%s triangle\" }\n", prefix);
		printf("\t\tmount\n");
		printf("\t\t{\n");
		printf("\t\t\tvertex{\"%s vx >y %d_%d\"},\n", prefix, 0, 0 );
		printf("\t\t\tvertex{\"%s vx >y<z %d\"},\n", prefix, 0 );
		printf("\t\t\tvertex{\"%s vx <x>y<z\"}\n", prefix );
		printf("\t\t}\n");
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,ycount-1,0, prefix, 1,ycount-1,0 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,ycount-1,0, prefix, 0,ycount-2,0 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,ycount-1,0, prefix, 0,ycount-1,1 );
		printf("\t}\n");
		printf("\n");

		printf("\ttriangle\n");
		printf("\t{\n");
		printf("\t\ttemplate\t{ \"%s triangle\" }\n", prefix);
		printf("\t\tmount\n");
		printf("\t\t{\n");
		printf("\t\t\tvertex{\"%s vx <z %d_%d\"},\n", prefix, 0, ycount-1 );
		printf("\t\t\tvertex{\"%s vx <x>y<z\"},\n", prefix );
		printf("\t\t\tvertex{\"%s vx >y<z %d\"}\n", prefix, 0 );
		printf("\t\t}\n");
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,ycount-1,0, prefix, 1,ycount-1,0 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,ycount-1,0, prefix, 0,ycount-2,0 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,ycount-1,0, prefix, 0,ycount-1,1 );
		printf("\t}\n");
		printf("\n");

		printf("\ttriangle\n");
		printf("\t{\n");
		printf("\t\ttemplate\t{ \"%s triangle\" }\n", prefix);
		printf("\t\tmount\n");
		printf("\t\t{\n");
		printf("\t\t\tvertex{\"%s vx <z %d_%d\"},\n", prefix, 0, ycount-1 );
		printf("\t\t\tvertex{\"%s vx <x<z %d\"},\n", prefix, ycount-1 );
		printf("\t\t\tvertex{\"%s vx <x>y<z\"}\n", prefix );
		printf("\t\t}\n");
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,ycount-1,0, prefix, 1,ycount-1,0 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,ycount-1,0, prefix, 0,ycount-2,0 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,ycount-1,0, prefix, 0,ycount-1,1 );
		printf("\t}\n");
		printf("\n");



		// corner >x>y<z

		printf("\ttriangle\n");
		printf("\t{\n");
		printf("\t\ttemplate\t{ \"%s triangle\" }\n", prefix);
		printf("\t\tmount\n");
		printf("\t\t{\n");
		printf("\t\t\tvertex{\"%s vx >x %d_%d\"},\n", prefix, 0, ycount-1 );
		printf("\t\t\tvertex{\"%s vx >x<z %d\"},\n", prefix, ycount-1 );
		printf("\t\t\tvertex{\"%s vx >x>y<z\"}\n", prefix );
		printf("\t\t}\n");
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,ycount-1,0, prefix, xcount-2,ycount-1,0 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,ycount-1,0, prefix, xcount-1,ycount-2,0 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,ycount-1,0, prefix, xcount-1,ycount-1,1 );
		printf("\t}\n");
		printf("\n");

		printf("\ttriangle\n");
		printf("\t{\n");
		printf("\t\ttemplate\t{ \"%s triangle\" }\n", prefix);
		printf("\t\tmount\n");
		printf("\t\t{\n");
		printf("\t\t\tvertex{\"%s vx >x %d_%d\"},\n", prefix, 0, ycount-1 );
		printf("\t\t\tvertex{\"%s vx >x>y<z\"},\n", prefix );
		printf("\t\t\tvertex{\"%s vx >x>y %d\"}\n", prefix, 0 );
		printf("\t\t}\n");
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,ycount-1,0, prefix, xcount-2,ycount-1,0 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,ycount-1,0, prefix, xcount-1,ycount-2,0 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,ycount-1,0, prefix, xcount-1,ycount-1,1 );
		printf("\t}\n");
		printf("\n");

		printf("\ttriangle\n");
		printf("\t{\n");
		printf("\t\ttemplate\t{ \"%s triangle\" }\n", prefix);
		printf("\t\tmount\n");
		printf("\t\t{\n");
		printf("\t\t\tvertex{\"%s vx >y %d_%d\"},\n", prefix, xcount-1, 0 );
		printf("\t\t\tvertex{\"%s vx >x>y %d\"},\n", prefix, 0 );
		printf("\t\t\tvertex{\"%s vx >x>y<z\"}\n", prefix );
		printf("\t\t}\n");
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,ycount-1,0, prefix, xcount-2,ycount-1,0 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,ycount-1,0, prefix, xcount-1,ycount-2,0 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,ycount-1,0, prefix, xcount-1,ycount-1,1 );
		printf("\t}\n");
		printf("\n");

		printf("\ttriangle\n");
		printf("\t{\n");
		printf("\t\ttemplate\t{ \"%s triangle\" }\n", prefix);
		printf("\t\tmount\n");
		printf("\t\t{\n");
		printf("\t\t\tvertex{\"%s vx >y %d_%d\"},\n", prefix, xcount-1, 0 );
		printf("\t\t\tvertex{\"%s vx >x>y<z\"},\n", prefix );
		printf("\t\t\tvertex{\"%s vx >y<z %d\"}\n", prefix, xcount-1 );
		printf("\t\t}\n");
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,ycount-1,0, prefix, xcount-2,ycount-1,0 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,ycount-1,0, prefix, xcount-1,ycount-2,0 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,ycount-1,0, prefix, xcount-1,ycount-1,1 );
		printf("\t}\n");
		printf("\n");

		printf("\ttriangle\n");
		printf("\t{\n");
		printf("\t\ttemplate\t{ \"%s triangle\" }\n", prefix);
		printf("\t\tmount\n");
		printf("\t\t{\n");
		printf("\t\t\tvertex{\"%s vx <z %d_%d\"},\n", prefix, xcount-1, ycount-1 );
		printf("\t\t\tvertex{\"%s vx >y<z %d\"},\n", prefix, xcount-1 );
		printf("\t\t\tvertex{\"%s vx >x>y<z\"}\n", prefix );
		printf("\t\t}\n");
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,ycount-1,0, prefix, xcount-2,ycount-1,0 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,ycount-1,0, prefix, xcount-1,ycount-2,0 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,ycount-1,0, prefix, xcount-1,ycount-1,1 );
		printf("\t}\n");
		printf("\n");

		printf("\ttriangle\n");
		printf("\t{\n");
		printf("\t\ttemplate\t{ \"%s triangle\" }\n", prefix);
		printf("\t\tmount\n");
		printf("\t\t{\n");
		printf("\t\t\tvertex{\"%s vx <z %d_%d\"},\n", prefix, xcount-1, ycount-1 );
		printf("\t\t\tvertex{\"%s vx >x>y<z\"},\n", prefix );
		printf("\t\t\tvertex{\"%s vx >x<z %d\"}\n", prefix, ycount-1 );
		printf("\t\t}\n");
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,ycount-1,0, prefix, xcount-2,ycount-1,0 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,ycount-1,0, prefix, xcount-1,ycount-2,0 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,ycount-1,0, prefix, xcount-1,ycount-1,1 );
		printf("\t}\n");
		printf("\n");


		// corner <x<y<z

		printf("\ttriangle\n");
		printf("\t{\n");
		printf("\t\ttemplate\t{ \"%s triangle\" }\n", prefix);
		printf("\t\tmount\n");
		printf("\t\t{\n");
		printf("\t\t\tvertex{\"%s vx <x %d_%d\"},\n", prefix, 0, 0 );
		printf("\t\t\tvertex{\"%s vx <x<z %d\"},\n", prefix, 0 );
		printf("\t\t\tvertex{\"%s vx <x<y<z\"}\n", prefix );
		printf("\t\t}\n");
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,0,0, prefix, 1,0,0 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,0,0, prefix, 0,1,0 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,0,0, prefix, 0,0,1 );
		printf("\t}\n");
		printf("\n");

		printf("\ttriangle\n");
		printf("\t{\n");
		printf("\t\ttemplate\t{ \"%s triangle\" }\n", prefix);
		printf("\t\tmount\n");
		printf("\t\t{\n");
		printf("\t\t\tvertex{\"%s vx <x %d_%d\"},\n", prefix, 0, 0 );
		printf("\t\t\tvertex{\"%s vx <x<y<z\"},\n", prefix );
		printf("\t\t\tvertex{\"%s vx <x<y %d\"}\n", prefix, 0 );
		printf("\t\t}\n");
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,0,0, prefix, 1,0,0 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,0,0, prefix, 0,1,0 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,0,0, prefix, 0,0,1 );
		printf("\t}\n");
		printf("\n");

		printf("\ttriangle\n");
		printf("\t{\n");
		printf("\t\ttemplate\t{ \"%s triangle\" }\n", prefix);
		printf("\t\tmount\n");
		printf("\t\t{\n");
		printf("\t\t\tvertex{\"%s vx <y %d_%d\"},\n", prefix, 0, 0 );
		printf("\t\t\tvertex{\"%s vx <x<y %d\"},\n", prefix, 0 );
		printf("\t\t\tvertex{\"%s vx <x<y<z\"}\n", prefix );
		printf("\t\t}\n");
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,0,0, prefix, 1,0,0 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,0,0, prefix, 0,1,0 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,0,0, prefix, 0,0,1 );
		printf("\t}\n");
		printf("\n");

		printf("\ttriangle\n");
		printf("\t{\n");
		printf("\t\ttemplate\t{ \"%s triangle\" }\n", prefix);
		printf("\t\tmount\n");
		printf("\t\t{\n");
		printf("\t\t\tvertex{\"%s vx <y %d_%d\"},\n", prefix, 0, 0 );
		printf("\t\t\tvertex{\"%s vx <x<y<z\"},\n", prefix );
		printf("\t\t\tvertex{\"%s vx <y<z %d\"}\n", prefix, 0 );
		printf("\t\t}\n");
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,0,0, prefix, 1,0,0 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,0,0, prefix, 0,1,0 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,0,0, prefix, 0,0,1 );
		printf("\t}\n");
		printf("\n");

		printf("\ttriangle\n");
		printf("\t{\n");
		printf("\t\ttemplate\t{ \"%s triangle\" }\n", prefix);
		printf("\t\tmount\n");
		printf("\t\t{\n");
		printf("\t\t\tvertex{\"%s vx <z %d_%d\"},\n", prefix, 0, 0 );
		printf("\t\t\tvertex{\"%s vx <y<z %d\"},\n", prefix, 0 );
		printf("\t\t\tvertex{\"%s vx <x<y<z\"}\n", prefix );
		printf("\t\t}\n");
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,0,0, prefix, 1,0,0 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,0,0, prefix, 0,1,0 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,0,0, prefix, 0,0,1 );
		printf("\t}\n");
		printf("\n");

		printf("\ttriangle\n");
		printf("\t{\n");
		printf("\t\ttemplate\t{ \"%s triangle\" }\n", prefix);
		printf("\t\tmount\n");
		printf("\t\t{\n");
		printf("\t\t\tvertex{\"%s vx <z %d_%d\"},\n", prefix, 0, 0 );
		printf("\t\t\tvertex{\"%s vx <x<y<z\"},\n", prefix );
		printf("\t\t\tvertex{\"%s vx <x<z %d\"}\n", prefix, 0 );
		printf("\t\t}\n");
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,0,0, prefix, 1,0,0 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,0,0, prefix, 0,1,0 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, 0,0,0, prefix, 0,0,1 );
		printf("\t}\n");
		printf("\n");

		// corner >x<y<z

		printf("\ttriangle\n");
		printf("\t{\n");
		printf("\t\ttemplate\t{ \"%s triangle\" }\n", prefix);
		printf("\t\tmount\n");
		printf("\t\t{\n");
		printf("\t\t\tvertex{\"%s vx >x %d_%d\"},\n", prefix, 0, 0 );
		printf("\t\t\tvertex{\"%s vx >x<y<z\"},\n", prefix );
		printf("\t\t\tvertex{\"%s vx >x<z %d\"}\n", prefix, 0 );
		printf("\t\t}\n");
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,0,0, prefix, xcount-2,0,0 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,0,0, prefix, xcount-1,1,0 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,0,0, prefix, xcount-1,0,1 );
		printf("\t}\n");
		printf("\n");

		printf("\ttriangle\n");
		printf("\t{\n");
		printf("\t\ttemplate\t{ \"%s triangle\" }\n", prefix);
		printf("\t\tmount\n");
		printf("\t\t{\n");
		printf("\t\t\tvertex{\"%s vx >x %d_%d\"},\n", prefix, 0, 0 );
		printf("\t\t\tvertex{\"%s vx >x<y %d\"},\n", prefix, 0 );
		printf("\t\t\tvertex{\"%s vx >x<y<z\"}\n", prefix );
		printf("\t\t}\n");
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,0,0, prefix, xcount-2,0,0 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,0,0, prefix, xcount-1,1,0 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,0,0, prefix, xcount-1,0,1 );
		printf("\t}\n");
		printf("\n");

		printf("\ttriangle\n");
		printf("\t{\n");
		printf("\t\ttemplate\t{ \"%s triangle\" }\n", prefix);
		printf("\t\tmount\n");
		printf("\t\t{\n");
		printf("\t\t\tvertex{\"%s vx <y %d_%d\"},\n", prefix, xcount-1, 0 );
		printf("\t\t\tvertex{\"%s vx >x<y<z\"},\n", prefix );
		printf("\t\t\tvertex{\"%s vx >x<y %d\"}\n", prefix, 0 );
		printf("\t\t}\n");
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,0,0, prefix, xcount-2,0,0 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,0,0, prefix, xcount-1,1,0 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,0,0, prefix, xcount-1,0,1 );
		printf("\t}\n");
		printf("\n");

		printf("\ttriangle\n");
		printf("\t{\n");
		printf("\t\ttemplate\t{ \"%s triangle\" }\n", prefix);
		printf("\t\tmount\n");
		printf("\t\t{\n");
		printf("\t\t\tvertex{\"%s vx <y %d_%d\"},\n", prefix, xcount-1, 0 );
		printf("\t\t\tvertex{\"%s vx <y<z %d\"},\n", prefix, xcount-1 );
		printf("\t\t\tvertex{\"%s vx >x<y<z\"}\n", prefix );
		printf("\t\t}\n");
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,0,0, prefix, xcount-2,0,0 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,0,0, prefix, xcount-1,1,0 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,0,0, prefix, xcount-1,0,1 );
		printf("\t}\n");
		printf("\n");

		printf("\ttriangle\n");
		printf("\t{\n");
		printf("\t\ttemplate\t{ \"%s triangle\" }\n", prefix);
		printf("\t\tmount\n");
		printf("\t\t{\n");
		printf("\t\t\tvertex{\"%s vx <z %d_%d\"},\n", prefix, xcount-1, 0 );
		printf("\t\t\tvertex{\"%s vx >x<y<z\"},\n", prefix );
		printf("\t\t\tvertex{\"%s vx <y<z %d\"}\n", prefix, xcount-1 );
		printf("\t\t}\n");
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,0,0, prefix, xcount-2,0,0 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,0,0, prefix, xcount-1,1,0 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,0,0, prefix, xcount-1,0,1 );
		printf("\t}\n");
		printf("\n");

		printf("\ttriangle\n");
		printf("\t{\n");
		printf("\t\ttemplate\t{ \"%s triangle\" }\n", prefix);
		printf("\t\tmount\n");
		printf("\t\t{\n");
		printf("\t\t\tvertex{\"%s vx <z %d_%d\"},\n", prefix, xcount-1, 0 );
		printf("\t\t\tvertex{\"%s vx >x<z %d\"},\n", prefix, 0 );
		printf("\t\t\tvertex{\"%s vx >x<y<z\"}\n", prefix );
		printf("\t\t}\n");
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,0,0, prefix, xcount-2,0,0 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,0,0, prefix, xcount-1,1,0 );
		printf("\t\tdepend\t{ connection{ object{\"%s %d_%d_%d\"}, object{\"%s %d_%d_%d\"} } }\n", prefix, xcount-1,0,0, prefix, xcount-1,0,1 );
		printf("\t}\n");
		printf("\n");
	}




/*
	for(z = 0; z < zcount; z++)
	{
		for(y = 0; y < ycount; y++)
		{
			for(x = 0; x < xcount; x++)
			{
				printf("\tsphere\n");
				printf("\t{\n");
//				printf("\t\ttemplate\t{ \"sphere1\" }\n", prefix);
				printf("\t\tradius\t{ template object{\"%s\"}.radius }\n", prefix );
				printf("\t\tmount\t\t{ \"%s %d_%d_%d\" }\n", prefix, x, y, z);
				printf("\t}\n");
				printf("\n");
			}
		}
	}
*/	
	printf("\twindow\t\t{ 300, 300 }\n");
	printf("\tmount\t\t{ vector { 0, 0, 10 } }\n");
	printf("\tlookat\t\t{ variable vector {\"%s center\"} }\n", prefix);
	printf("\tsamplerate\t{ 20 }\n");
	printf("\tname\t\t{ \"Camera 1\" }\n");
	printf("\torbit\t{ true }\n");
	printf("}\n");

	return 0;
}

